/*
===========================================================================
This file is added for the QUAGENTS 3 project as a place to put our director commands.
JUNE 24 2011

SEE HEADER FILE
===========================================================================
*/

/*****************************************************************************
 * name:		ai_directorcommands.c
 *
 * desc:		Quagents3 director functions.
 *
 *****************************************************************************/

#include "g_local.h"
#include "../botlib/botlib.h"
#include "../botlib/be_aas.h"
#include "../botlib/be_ea.h"
#include "../botlib/be_ai_char.h"
#include "../botlib/be_ai_chat.h"
#include "../botlib/be_ai_gen.h"
#include "../botlib/be_ai_goal.h"
#include "../botlib/be_ai_move.h"
#include "../botlib/be_ai_weap.h"
//
#include "ai_main.h"
#include "ai_dmq3.h"
#include "ai_quagentsnodes.h"
#include "ai_chat.h"
#include "ai_cmd.h"
#include "ai_dmnet.h"
#include "ai_team.h"
#include "ai_directorcommands.h"
//data file headers
#include "chars.h"			//characteristics
#include "inv.h"			//indexes into the inventory
#include "syn.h"			//synonyms
#include "match.h"			//string matching types and vars

// for the voice chats
#include "../../ui/menudef.h"

/*
==================
AI_DirectorOpCode
==================
*/
void AI_DirectorOpCode(int commandtype, char* opcode){
	switch(commandtype){
		case DCMD_EC: opcode[0]='e'; opcode[1]='c'; break;
		case DCMD_GP: opcode[0]='g'; opcode[1]='p'; break;
		case DCMD_SH: opcode[0]='s'; opcode[1]='h'; break;
		case DCMD_GH: opcode[0]='g'; opcode[1]='h'; break;
		case DCMD_SA: opcode[0]='s'; opcode[1]='a'; break;
		case DCMD_GA: opcode[0]='g'; opcode[1]='a'; break;
		case DCMD_SG: opcode[0]='s'; opcode[1]='g'; break;
		case DCMD_GG: opcode[0]='g'; opcode[1]='g'; break;
		case DCMD_DR: opcode[0]='d'; opcode[1]='r'; break;
		case DCMD_FD: opcode[0]='f'; opcode[1]='d'; break;
		case DCMD_PS: opcode[0]='p'; opcode[1]='s'; break;
		case DCMD_SS: opcode[0]='s'; opcode[1]='s'; break;
		case DCMD_GM: opcode[0]='g'; opcode[1]='m'; break;
		case DCMD_IW: opcode[0]='i'; opcode[1]='w'; break;
		case DCMD_SU: opcode[0]='s'; opcode[1]='u'; break;
		case DCMD_SM: opcode[0]='s'; opcode[1]='m'; break;
		case DCMD_FO: opcode[0]='f'; opcode[1]='o'; break;
		default: opcode[0]='?'; opcode[1]='?';
	}
	opcode[2]='\0';
}

/*
==================
AIExit_Director
==================
*/
void AIExit_Director(int cmdid, char commandtype, char* status){
	char opcode[3];
	char retstring[128];
	
	AI_DirectorOpCode(commandtype,opcode);
	Com_sprintf(retstring,127,"cp %s %d %s\n",opcode,cmdid,status);
	trap_Com_QuagentsDirectorWrite(retstring);
}

/*
==================
AI_DirectorCommand_Echo
==================
*/
void AI_DirectorCommand_Echo(int cmdid, char* string) {
	char retstring[128];

	Com_sprintf(retstring,127,"rs ec %s\n", string);
	trap_Com_QuagentsDirectorWrite(retstring);
	AIExit_Director(cmdid, DCMD_EC, "done");
}

/*
==================
AI_DirectorCommand_GetPositions
==================
*/
void AI_DirectorCommand_GetPositions(int cmdid, int entityid) {
	int i;
	char retstring[128];
	gentity_t *target;
	vec3_t location;

	if (entityid == -2) {
		for (i = 0; i < MAX_GENTITIES; i++) {
			target = &g_entities[i];
			if (target->inuse) {
				location[0] = target->r.currentOrigin[0];
				location[1] = target->r.currentOrigin[1];
				location[2] = target->r.currentOrigin[2];
				Com_sprintf(retstring,127,"rs gp %d %d %s %f %f %f\n", cmdid, i, target->classname, location[0], location[1], location[2]);
				trap_Com_QuagentsDirectorWrite(retstring);
			}
		}
	}
	else if (entityid == -1) {
		for (i = 0; i < MAX_GENTITIES; i++) {
			target = &g_entities[i];
			if (target->inuse && target->client != NULL) {
				location[0] = target->client->ps.origin[0];
				location[1] = target->client->ps.origin[1];
				location[2] = target->client->ps.origin[2];
				Com_sprintf(retstring,127,"rs gp %d %d %s %f %f %f\n", cmdid, target->client->ps.clientNum, target->classname, location[0], location[1], location[2]);
				trap_Com_QuagentsDirectorWrite(retstring);
			}
		}
	}
	else {
		target = &g_entities[entityid];
		if (target->inuse) {
			location[0] = target->r.currentOrigin[0];
			location[1] = target->r.currentOrigin[1];
			location[2] = target->r.currentOrigin[2];
			Com_sprintf(retstring,127,"rs gp %d %d %s %f %f %f\n", cmdid, target->s.number, target->classname, location[0], location[1], location[2]);
			trap_Com_QuagentsDirectorWrite(retstring);
		}
	}
	AIExit_Director(cmdid, DCMD_GP, "done");
}

/*
==================
AI_DirectorCommand_SetHealth
==================
*/
void AI_DirectorCommand_SetHealth(int cmdid, int id, int health) {
	int i;
	gentity_t *target;
	
	if (id == -1) {
		for (i = 0; i < MAX_GENTITIES; i++) {
			target = &g_entities[i];
			if (target->inuse && target->client != NULL) {
				target->health = health;
			}
		}
	}
	else {
		target = &g_entities[id];
		target->health = health;
	}
	AIExit_Director(cmdid, DCMD_SH, "done");
}

/*
==================
AI_DirectorCommand_GetHealth
==================
*/
void AI_DirectorCommand_GetHealth(int cmdid, int id) {
	int i;
	char retstring[128];
	gentity_t *target;
	
	if (id == -1) {
		for (i = 0; i < MAX_GENTITIES; i++) {
			target = &g_entities[i];
			if (target->inuse && target->client != NULL) {
				Com_sprintf(retstring,127,"rs gh %d %d %d\n", cmdid, target->client->ps.clientNum, target->health);
				trap_Com_QuagentsDirectorWrite(retstring);
			}
		}
	}
	else {
		target = &g_entities[id];
		Com_sprintf(retstring,127,"rs gh %d %d %d\n", cmdid, target->client->ps.clientNum, target->health);
		trap_Com_QuagentsDirectorWrite(retstring);
	}
	AIExit_Director(cmdid, DCMD_GH, "done");
}

/*
==================
AI_DirectorCommand_SetArmor
==================
*/
void AI_DirectorCommand_SetArmor(int cmdid, int id, int armor) {
	int i;
	gentity_t *target;
	
	if (id == -1) {
		for (i = 0; i < MAX_GENTITIES; i++) {
			target = &g_entities[i];
			if (target->inuse && target->client != NULL) {
				target->client->ps.stats[STAT_ARMOR] = armor;
			}
		}
	}
	else {
		target = &g_entities[id];
		target->client->ps.stats[STAT_ARMOR] = armor;
	}
	AIExit_Director(cmdid, DCMD_SA, "done");
}

/*
==================
AI_DirectorCommand_GetArmor
==================
*/
void AI_DirectorCommand_GetArmor(int cmdid, int id) {
	char retstring[128];
	int i;
	gentity_t *target;
	
	if (id == -1) {
		for (i = 0; i < MAX_GENTITIES; i++) {
			target = &g_entities[i];
			if (target->inuse && target->client != NULL) {
				Com_sprintf(retstring,127,"rs ga %d %d %d\n", cmdid, target->client->ps.clientNum, target->client->ps.stats[STAT_ARMOR]);
				trap_Com_QuagentsDirectorWrite(retstring);
			}
		}
	}
	else {
		target = &g_entities[id];
		Com_sprintf(retstring,127,"rs ga %d %d %d\n", cmdid, target->client->ps.clientNum, target->client->ps.stats[STAT_ARMOR]);
		trap_Com_QuagentsDirectorWrite(retstring);
	}
	AIExit_Director(cmdid, DCMD_GA, "done");
}

/*
==================
AI_DirectorCommand_SetGravity
==================
*/
void AI_DirectorCommand_SetGravity(int cmdid, float gravity) {
	char command[128];

	Com_sprintf(command,127,"set g_gravity %f", gravity);
	trap_SendConsoleCommand(EXEC_APPEND, command);
	AIExit_Director(cmdid, DCMD_SG, "done");
}

/*
==================
AI_DirectorCommand_GetGravity
==================
*/
void AI_DirectorCommand_GetGravity(int cmdid) {	
	char retstring[128];
	//G_Printf("%d\n", directorSock);

	Com_sprintf(retstring,127,"rs gg %d %f\n", cmdid, g_gravity.value);
	trap_Com_QuagentsDirectorWrite(retstring);
	AIExit_Director(cmdid, DCMD_GG, "done");
}

/*
==================
AI_DirectorCommand_Drop
==================
*/
void AI_DirectorCommand_Drop(int cmdid, int id, int q, float x, float y, float z) {
	gentity_t *itement;
	gitem_t* item;
	char *itemname;
	int itemid = id;
	int quantity = q;
	
	// choose item
	switch(itemid){
		case 0: 
			itemname = "quagent_item_treasure";
			break;	
		case 1: 
			itemname = "quagent_item_gold";
			break;
		default: 
			itemname = "invalid_item";
	}

	if (!strcmp(itemname, "invalid_item"))
		AIExit_Director(cmdid, DCMD_DR, "invalid_item");
	else if (quantity < 1)
		AIExit_Director(cmdid, DCMD_DR, "invalid_quantity");
	else {
		vec3_t vel;
		vec3_t origin;
		vel[0]=0;
		vel[1]=0;
		vel[2]=200;
		origin[0] = x;
		origin[1] = y;
		origin[2] = z;
		item=BG_FindItemByClassname(itemname);
		item->quantity = quantity;
		itement = G_Spawn();
		itement->s.eType = ET_ITEM;
		itement->s.modelindex = item - bg_itemlist;	// store item number in modelindex
		itement->s.modelindex2 = 1; // This is non-zero if it's a dropped item
		itement->classname = item->classname;
		itement->item = item;
		VectorSet (itement->r.mins, -ITEM_RADIUS, -ITEM_RADIUS, -ITEM_RADIUS);
		VectorSet (itement->r.maxs, ITEM_RADIUS, ITEM_RADIUS, ITEM_RADIUS);
		itement->r.contents = CONTENTS_TRIGGER;
		itement->touch = Touch_Item;
		G_SetOrigin( itement, origin);
		itement->s.pos.trType = TR_GRAVITY;
		itement->s.pos.trTime = level.time;
		VectorCopy( vel, itement->s.pos.trDelta );
		itement->s.eFlags |= EF_BOUNCE_HALF;
		itement->think = 0;				// don't do anything
		itement->nextthink = 0; 
		itement->flags = FL_DROPPED_ITEM;
		trap_LinkEntity (itement);
		AIExit_Director(cmdid, DCMD_DR, "done");
	}
}

/*
==================
AI_DirectorCommand_FindDist
==================
*/
void AI_DirectorCommand_FindDist(int cmdid, float x1, float y1, float z1, float x2, float y2, float z2) {
	char retstring[128];
	vec3_t point1;
	vec3_t point2;
	vec3_t diff;
	float distance;

	point1[0] = x1;
	point1[1] = y1;
	point1[2] = z1;
	point2[0] = x2;
	point2[1] = y2;
	point2[2] = z2;
	
	VectorSubtract(point1, point2, diff);
	distance = VectorNormalize(diff);
	Com_sprintf(retstring,127,"rs fd %d %f\n", cmdid, distance);
	trap_Com_QuagentsDirectorWrite(retstring);
	AIExit_Director(cmdid, DCMD_FD, "done");
}

/*
==================
AI_DirectorCommand_Pause
==================
*/
int pause = 0;
void AI_DirectorCommand_Pause(int cmdid) {
	char retstring[128];
	if (!pause) {
		trap_Cvar_Set( "cl_paused", "1" );
		Com_sprintf(retstring,127,"rs ps %d pause\n", cmdid);
		trap_Com_QuagentsDirectorWrite(retstring);
		pause = 1;
	}
	// does not unpause, not sure what the problem is. Can still unpause by toggling menu with ESC key.
	// server does not receive message until unpaused, even when paused by ESC.
	else {
		trap_Cvar_Set( "cl_paused", "0" );
		Com_sprintf(retstring,127,"rs ps %d unpause\n", cmdid);
		trap_Com_QuagentsDirectorWrite(retstring);
		pause = 0;
	}
	AIExit_Director(cmdid, DCMD_PS, "done");
}

/*
==================
AI_DirectorCommand_ScreenShot
==================
*/
void AI_DirectorCommand_ScreenShot(int cmdid) {
	trap_SendConsoleCommand(EXEC_APPEND, "screenshotJPEG");
	AIExit_Director(cmdid, DCMD_SS, "done");
}

/*
==================
AI_DirectorCommand_SetGameMap
==================
*/
void AI_DirectorCommand_SetGameMap(int cmdid, int type, char *map) {
	char command[128];

	Com_sprintf(command,127,"set g_gametype %d; map %s", type, map);
	trap_SendConsoleCommand(EXEC_APPEND, command);
	AIExit_Director(cmdid, DCMD_GM, "done");
}

/*
==================
AI_DirectorCommand_IsWithin
==================
*/
void AI_DirectorCommand_IsWithin(int cmdid, int id, float x1, float y1, float z1, float x2, float y2, float z2) {
	char retstring[128];
	int entityList[MAX_GENTITIES], numEntities, i, within;
	gentity_t *target;
	gentity_t *entity;
	vec3_t maxs;
	vec3_t mins;

	within = 0;
	target = &g_entities[id];
	mins[0] = x1;
	mins[1] = y1;
	mins[2] = z1;
	maxs[0] = x2;
	maxs[1] = y2;
	maxs[2] = z2;

	numEntities = trap_EntitiesInBox(mins, maxs, entityList, MAX_GENTITIES);

	for (i = 0; i < numEntities; i++) {
		entity=&g_entities[entityList[i]];

		if (entity == target)
			within = 1;
	}

	if (within) {
		Com_sprintf(retstring,127,"rs iw %d t\n", cmdid);
		trap_Com_QuagentsDirectorWrite(retstring);
	}
	else {
		Com_sprintf(retstring,127,"rs iw %d f\n", cmdid);
		trap_Com_QuagentsDirectorWrite(retstring);
	}
	AIExit_Director(cmdid, DCMD_IW, "done");
}

/*
==================
AI_DirectorCommand_SpeedUp
==================
*/
void AI_DirectorCommand_SpeedUp(int cmdid, float factor) {
	char command[128];

	Com_sprintf(command,127,"set timescale %f", factor);
	trap_SendConsoleCommand(EXEC_APPEND, command);
	AIExit_Director(cmdid, DCMD_SU, "done");
}

/*
==================
AI_DirectorCommand_SlowMo
==================
*/
void AI_DirectorCommand_SlowMo(int cmdid, float factor) {
	char command[128];

	Com_sprintf(command,127,"set timescale %f", 1/factor);
	trap_SendConsoleCommand(EXEC_APPEND, command);
	AIExit_Director(cmdid, DCMD_SM, "done");
}

/*
==================
AI_DirectorCommand_FollowViewpoint
==================
*/
void AI_DirectorCommand_FollowViewpoint(int cmdid, int id) {
	char command[128];

	if(id==-1) {
		Com_sprintf(command,127,"follow\n");
	}
	else {
		Com_sprintf(command,127,"follow %d\n", id);
	}
	trap_SendConsoleCommand(EXEC_APPEND, command);
	AIExit_Director(cmdid, DCMD_FO, "done");
}
