/*
===========================================================================
This file is added for the QUAGENTS 3 project as a place to put our director commands.
JUNE 24 2011
===========================================================================
*/
//

/*****************************************************************************
 * name:		ai_directorcommands.h
 *
 * desc:		Quagents3 direct command functions.
 *
 *****************************************************************************/

#define DCMD_EC	0
#define DCMD_GP	1
#define DCMD_SH	2
#define DCMD_GH	3
#define DCMD_SA	4
#define DCMD_GA	5
#define DCMD_SG	6
#define DCMD_GG	7
#define DCMD_DR	8
#define DCMD_FD 9
#define DCMD_PS 10
#define DCMD_SS 11
#define DCMD_GM 12
#define DCMD_IW 13
#define DCMD_SU 14
#define DCMD_SM 15
#define DCMD_FO 16

void AIExit_Director(int cmdid, char commandtype, char* status);
void AI_DirectorCommand_Echo(int cmdid, char* string);
void AI_DirectorCommand_GetPositions(int cmdid, int entityid);
void AI_DirectorCommand_SetHealth(int cmdid, int id, int health);
void AI_DirectorCommand_GetHealth(int cmdid, int id);
void AI_DirectorCommand_SetArmor(int cmdid, int id, int armor);
void AI_DirectorCommand_GetArmor(int cmdid, int id);
void AI_DirectorCommand_SetGravity(int cmdid, float gravity);
void AI_DirectorCommand_GetGravity(int cmdid);
void AI_DirectorCommand_Drop(int cmdid, int id, int q, float x, float y, float z);
void AI_DirectorCommand_FindDist(int cmdid, float x1, float y1, float z1, float x2, float y2, float z2);
void AI_DirectorCommand_Pause(int cmdid);
void AI_DirectorCommand_ScreenShot(int cmdid);
void AI_DirectorCommand_SetGameMap(int cmdid, int id, char *map);
void AI_DirectorCommand_IsWithin(int cmdid, int id, float x1, float y1, float z1, float x2, float y2, float z2);
void AI_DirectorCommand_SpeedUp(int cmdid, float factor);
void AI_DirectorCommand_SlowMo(int cmdid, float factor);
void AI_DirectorCommand_FollowViewpoint(int cmdid, int id);
