/*
===========================================================================
This file is added for the QUAGENTS 3 project as a place to put our AI nodes.
MAY 26 2011

All Quagent3 nodes have AINode_G*. The G stands for quaGents.
This is written so that it is easy to distinguish built-in and quagent behaviors.

Behaviors return qtrue if the bot's computation of this node is complete (and 
the game can advance), else qfalse to keep thinking.
===========================================================================
*/
//

/*****************************************************************************
 * name:		ai_quagentsnodes.h
 *
 * desc:		Quagents3 bot AI
 *
 *****************************************************************************/

#define QCMD_MI	0
#define QCMD_MB	1
#define QCMD_MT	2
#define QCMD_SK	3
#define QCMD_JU	4
#define QCMD_RO	5
#define QCMD_PO	6
#define QCMD_FA	7
#define QCMD_PA	8
#define QCMD_HM 9
#define QCMD_HC 10
#define QCMD_AM 11
#define QCMD_AC 12
#define QCMD_LC 13
#define QCMD_RF 14
#define QCMD_FW 15
#define QCMD_PK 16
#define QCMD_FC 17
#define QCMD_CS 18
#define QCMD_RA 19
#define QCMD_WI 20
#define QCMD_MF 21
#define QCMD_RB 22
#define QCMD_FM 23
#define QCMD_SW 24
#define QCMD_SC 25
#define QCMD_SV 26
#define QCMD_MC 27
#define QCMD_SY 28
#define QCMD_AL 29
#define QCMD_PU 30
#define QCMD_PD 31
#define QCMD_CI 32
#define QCMD_VC 33
#define QCMD_VD 34

void AIEnter_Quagents(bot_state_t *bs, char now, char cmd, unsigned int idnum, char val1, float valf1, float valf2, float valf3, float valf4, float valf5, float valf6, float valf7);

int AINode_GWalkForever(bot_state_t *bs);
int AINode_GWalkBy(bot_state_t *bs);
int AINode_GWalkTo(bot_state_t *bs);
int AINode_GJumpOnce(bot_state_t *bs);
int AINode_GRotate(bot_state_t*);
int AINode_GPop(bot_state_t*);
int AINode_GForgetAllTasks(bot_state_t*);
int AINode_GForgetMostTasks(bot_state_t*);
int AINode_GPause(bot_state_t*);
int AINode_GBasicQuery(bot_state_t *bs);
int AINode_GRangeFinder(bot_state_t *bs);
int AINode_GPeek(bot_state_t *bs);
int AINode_GShoot(bot_state_t *bs);
int AINode_GSkip(bot_state_t *bs);
int AINode_GCanSee(bot_state_t *bs);
int AINode_GWhatIs(bot_state_t *bs);
int AINode_GRadar(bot_state_t *bs);
int AINode_GWalkFor(bot_state_t *bs);
int AINode_GBatchRangeFinder(bot_state_t *bs);
int AINode_GSelectWeapon(bot_state_t *bs);
int AINode_GCrouch(bot_state_t *bs);
int AINode_GShove(bot_state_t *bs);
int AINode_GGetAmmo(bot_state_t *bs);
int AINode_GSay(bot_state_t *bs);
int AINode_GPickUp(bot_state_t *bs);
int AINode_GPutDown(bot_state_t *bs);
int AINode_GCheckInventory(bot_state_t *bs);
int AINode_GGetView(bot_state_t *bs);
/*		DEBUG: */
int AINode_GAlchemize(bot_state_t *bs);

