#! /usr/bin/perl

# usage:
# ./dbf2html.pl coordinate_mapping.txt shapefile

use File::Basename;
use lib dirname($0);	# look for libraries included with distribution
use Geo::ShapeFile;

# read in file with points in both co-ordinate systems
$coord_file = shift;
open(COORD, $coord_file) || die;
while (<COORD>) {
  next if (/^$/ || /^\#/);
  if (/^url=(.*)/) {
    $url = $1;
    ($field) = $url =~ /\$(\w*)/;
    print STDERR "$url\n";
    next;
  }
}
die "need url=... in config file" unless $url;

$shp_file = shift;

# read in .dbf file
my $shapefile = new Geo::ShapeFile($shp_file);

for $i (1 .. $shapefile->shapes()) {
  %db = $shapefile->get_dbf_record($i);
  $fn =~ s/ //g;
  $fn = $url;
  $fn =~ s/\$(\w*)/$db{$1}/g;	# replace variable name with field value
  $fn =~ s/ //g;		# remove spaces

  $fn =~ s/^.*\///;		# basename of url
  open(OUT, ">$fn");
  print OUT "<ul>\n";

  # print all database fields and their values
  for $f (keys %db) {
    print(OUT "<li>$f:\t$db{$f}\n");
  }

  print OUT "</ul>\n";
}
