#! /usr/bin/perl

# usage:
#  dump-shp.pl <shapefile>

# prints contents of .dbf file together with co-ordinates from .shp file
#

use File::Basename;
use lib dirname($0);	# look for libraries included with distribution
use Geo::ShapeFile;

my $shapefile = new Geo::ShapeFile(shift);

for(1 .. $shapefile->shapes()) {
  my $shape = $shapefile->get_shp_record($_);

  my %db = $shapefile->get_dbf_record($_);

  for $k (sort keys %db) {
    print "$k: $db{$k}\n";
  }
  if ($shape->shape_type_text() =~ /^Point/) {
    ($point) = $shape->points();
    $x = $point->X();
    $y = $point->Y();
    print "Point $shape->{shp_record_number}: $x $y\n";
  } else {
    print $shape->dump();
  }
  
}
