#! /usr/bin/perl

# usage:
#  shp2imagemap.pl coordinate_mapping.txt shapefile > imagemapfile.map

use File::Basename;
use lib dirname($0);	# look for libraries included with distribution
use Math::Matrix;
use Geo::ShapeFile;


# read in file with points in both co-ordinate systems
$coord_file = shift;
open(COORD, $coord_file) || 
    die("can't open coordinate mapping file $coord_file");
while (<COORD>) {
  next if (/^$/ || /^\#/);
  if (/^url=(.*)/) {
    $url = $1;
    ($field) = $url =~ /\$(\w*)/;
    print STDERR "$url\n";
    next;
  }
  @{$camp} = split;
  push (@xrows, [$camp->[2], $camp->[3], 1, $camp->[0]]);
  push (@yrows, [$camp->[2], $camp->[3], 1, $camp->[1]]);
}
die "need url=... in config file" unless $url;

$xE = new Math::Matrix(@xrows);
$xs = $xE->solve;

$yE = new Math::Matrix(@yrows);
$ys = $yE->solve;

print STDERR "co-ordinate transformation: $xs->[0][0],$xs->[1][0],$xs->[2][0]:$ys->[0][0],$ys->[1][0],$ys->[2][0]\n";

$shp_file = shift;	# 2nd argument on command line

my $shapefile = new Geo::ShapeFile($shp_file);

for (1 .. $shapefile->shapes()) {
  my %db = $shapefile->get_dbf_record($_);
  my $shape = $shapefile->get_shp_record($_);

  $fn = $url;
  $fn =~ s/\$(\w*)/$db{$1}/g;	# replace variable name with field value
  $fn =~ s/ //g;		# remove spaces

  $n = $shape->shape_id();
  if ($shape->shape_type_text() =~ /^Poly/) {
    if ($shape->shape_type_text() =~ /^Polygon/) {
      print "poly $fn ";  
    } elsif ($shape->shape_type_text() =~ /^PolyLine/) {
      print "line $fn 5,5 ";  	# of width 5 pixels
    }
    undef $lastx; undef $lasty;
    for $p (1 .. $shape->num_parts()) { 
      @points = $shape->get_part($p);
      for $point (@points) {
	$x = $point->X();
	$y = $point->Y();
	$xx = int ( $x*$xs->[0][0] + $y*$xs->[1][0] + $xs->[2][0] );
	$yy = int ( $x*$ys->[0][0] + $y*$ys->[1][0] + $ys->[2][0] );
	if ($fn && ($xx != $lastx || $yy != $lasty)) {
	  print $xx,',', $yy, " ";
	  $lastx = $xx;
	  $lasty = $yy;
	}
      }
    }
    print "\n";
  } elsif ($shape->shape_type_text() =~ /^Point/) {
    my ($point) = $shape->points();
    $x = $point->X();
    $y = $point->Y();
    $xx = int ( $x*$xs->[0][0] + $y*$xs->[1][0] + $xs->[2][0] );
    $yy = int ( $x*$ys->[0][0] + $y*$ys->[1][0] + $ys->[2][0] );
    print "rect $fn ", $xx-10,',', $yy-10, " ", $xx+10,',',$yy+10, "\n";
  } else {
    die "unkown shape type: ".$shape->shape_type_text();
  }
}
print "default MISSED\n";

