#!/usr/bin/perl 

# 5/2003 standalone cgi script

{
  # configuration variables

  # image files must be located under Map under this directory:
  $filepath = '/home/joeuser/public_html';

  # image files must be located under Map under this url:
  $urlpath = '/~joeuser';

  # location where log files will be written:
  $logpath = $filepath."/logs";

  $footer = "$filepath/Map/footer.txt";

  # header to appear at beginning of all web pages.
  # contains link to (empty in distribution) css style file.
  $html_header = '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<LINK rel="stylesheet" type="text/css" href="$urlpath/Map/IMG/map.css">';

}



require 'ctime.pl';

$timestring = &ctime(time());
chop($timestring);

# SET UP GLOBALS

$request_log = "$logpath/zoom_log";
$error_log = "$logpath/zoom-err_log";

$maproot = "$filepath/Map";
$mapurlpath = "$urlpath/Map";
$icons = "$urlpath/Map/IMG";

if (!$script) {
  # $script is also set by cgi-bin/muni
  # SCRIPT_URL includes PATH_INFO but not QUERY_STRING
  $script = "$ENV{SCRIPT_NAME}$ENV{PATH_INFO}";
}

if ($ENV{QUERY_STRING}) {
  &query_string();
  %FORM = %QS;
}

if (!$FORM{MAP}) {
  if ($ENV{PATH_INFO}) {
    $ENV{PATH_INFO} =~ s#^/##;
    $FORM{MAP} = $ENV{PATH_INFO};
    $FORM{ZOOM} += 0; $FORM{XPART} += 0; $FORM{YPART} += 0;
  } else {
    &handle_error("no map specified");
  }
}
(($mappath, $mapname) = ($FORM{MAP} =~ m/^(.*)\/([^\/]+)/)) ||  ($mapname = $FORM{MAP});

if ($mappath =~ /\/NEW$/) {
  $mappath =~ s/\/NEW$//;
  $new = 1;
}

# FIND MAP IN DATABASE

$found = &find_in_db($FORM{MAP});
if (!$found && $new) {
  $found = &find_in_db("$mappath/$mapname") && -d "$maproot/$FORM{MAP}";
}

&log_access();

if (!$found) {
  &handle_error('The map you requested was not found!', $FORM{MAP}, "$FORM{MAP} not in zoom.db");
} 

if (-e "$maproot/$FORM{MAP}-$depth.gif")
{
  ($hx, $hy) = &gifsize("$maproot/$FORM{MAP}-$depth.gif");
}

# map-specific footer
if (-e "$maproot/$mappath/Footer/$mapname.txt") {
  $footer = "$maproot/$mappath/Footer/$mapname.txt";
} 

# DETERMINE MODE

if (!-e "$maproot/$FORM{MAP}/")
{
  $maptitle .= " Download";
  &download(1);
} elsif (defined($FORM{'legend.x'})) {
  $maptitle = "Map Legend";
  &legend();
} elsif (defined($FORM{'download.x'})) {
  $maptitle .= " Download";
  &download();
} elsif (defined($FORM{'Map.x'})) {
  $oldsrc = "$FORM{MAP}/$mapname-$FORM{ZOOM}-$FORM{XPART}-$FORM{YPART}.gif";
  ($ix, $iy) = &gifsize("$maproot/$oldsrc");
  if ($FORM{MODE} && $FORM{MODE} eq "SELECT") {
    &select_route(); 
  } elsif ($FORM{MODE} && $FORM{MODE} eq "TRANSIT") {
    my($gx, $gy) = &absolute_gif_coords();
    open(DB, "$maproot/$FORM{MAP}.geo") || 
	&handle_error("Geocoding file not found $maproot/$name.geo",
		      '', '');
    my($x1,$x2,$x3,$y1,$y2,$y3) = split(/:/, <DB>);
    close(DB);
    $x = $gx * $x1 + $gy * $x2 + $x3;
    $y = $gx * $y1 + $gy * $y2 + $y3;

    &url("http://www.transitinfo.org/cgi-bin/location?x=$x&y=$y");

    open(DB,"$maproot/zoom.db") || die;
    while (<DB>) {
      chop;
      next if (/^$/);
      next if (/^\#/);
      my($name, $maptitle, $depth, $xnums, $ynums, $selectmode, $selectitem, $mile, $xc, $yc) = split(/:/);
      next unless ($xc && $yc);
      @XNUM = split(/,/, $xnums);
      @YNUM = split(/,/, $ynums);
      @xc = split(/,/, $xc);
      @yc = split(/,/, $yc);
      $xx = $x * $xc[0] + $y * $xc[1] + $xc[2];
      $yy = $x * $yc[0] + $y * $yc[1] + $yc[2];
      ($hx, $hy) = &gifsize("$maproot/$name-$depth.gif");
      if ($xx < $hx && $xx > 0 && $yy < $hy && $yy > 0) {
	$xpart = 0 + &min(int($xx / $hx * $XNUM[$depth] * 2 - .5) / 2,
			  $XNUM[$depth] - 1);
	$ypart = 0 + &min(int($yy / $hy * $YNUM[$depth] * 2 - .5) / 2,
			  $YNUM[$depth] - 1);
	my($acode) = $name =~ /^(..)/;
#	print 
	my $url = "http://www.transitinfo.org/cgi-bin/zoom/$name?XPART=$xpart&YPART=$ypart&ZOOM=$depth";
	push(@text, "This location on the <a href=\"$url\">$maptitle</a>");
	push(@url, $url);
#	last;
      }
    }
    if ($#url == 0) {
      &url($url[0]);
    } elsif ($#url < 0) { 
      &header;
      print "No local transit map available"; 
    } else {
      &header;
      print "<ul><li>", join ("<li>", @text), "</ul>";
      &footer;
    }
    close(DB);
    exit;
  } else {
    &zoom();
  }
} elsif (defined($FORM{'full.x'}) || (!defined($FORM{ZOOM}))) {
  $FORM{ZOOM} = $FORM{XPART} = $FORM{YPART} = 0;
  &printmap();
} else {
  &pan();
}

1;

#####################################################################

sub pan {

  if (defined($FORM{'u.x'}) || defined($FORM{'ul.x'}) || 
      defined($FORM{'ur.x'})) {
    $FORM{YPART} -= .5;
  } 
  if (defined($FORM{'d.x'}) || defined($FORM{'dl.x'}) || 
      defined($FORM{'dr.x'})) {
    $FORM{YPART} += .5;
  } 
  if (defined($FORM{'l.x'}) || defined($FORM{'ul.x'}) || 
      defined($FORM{'dl.x'})) {
    $FORM{XPART} -= .5;
  } 
  if (defined($FORM{'r.x'}) || defined($FORM{'ur.x'}) || 
      defined($FORM{'dr.x'})) {
    $FORM{XPART} += .5;
  }
  
  if ($FORM{zo} || defined($FORM{'zo.x'})) {
    $oldzoom = $FORM{ZOOM}--;
    $FORM{XPART} = 0 + &min(int($FORM{XPART} / $XNUM[$oldzoom] 
				* $XNUM[$FORM{ZOOM}] * 2 -.5) / 2,
			    $XNUM[$FORM{ZOOM}] - 1);
    $FORM{YPART} = 0 + &min(int($FORM{YPART} / $YNUM[$oldzoom] 
				* $YNUM[$FORM{ZOOM}] * 2 -.5) / 2,
			    $YNUM[$FORM{ZOOM}] - 1);
  }

  &printmap();
}

#####################################################################

sub zoom {
  if (-f "$maproot/$FORM{MAP}.inset") {
    &mapscan("$FORM{MAP}.inset", '');
    if ($match_data) {
      &url($match_data);
    }
  }

  $hi = ($FORM{XPART} + ($FORM{'Map.x'}/$ix)) / $XNUM[$FORM{ZOOM}];
  $hj = ($FORM{YPART} + ($FORM{'Map.y'}/$iy)) / $YNUM[$FORM{ZOOM}];
    
  $FORM{ZOOM}++;
  $FORM{XPART} = 0 + &min(int($hi * 
			      $XNUM[$FORM{ZOOM}] * 2 - .5) / 2, 
			  $XNUM[$FORM{ZOOM}] - 1);
  $FORM{YPART} = 0 + &min(int($hj * 
			      $YNUM[$FORM{ZOOM}] * 2 - .5) / 2,
			  $YNUM[$FORM{ZOOM}] - 1);

  &printmap();
}

#####################################################################

sub printmap {
  $space = "<IMG SRC=$icons/dot.gif WIDTH=5 HEIGHT=25 ALT=\"\">";
  #$space = " ";

  my $option_count = 0;
  $prompt = '';
  if ($depth > $FORM{ZOOM}) {
    $option_count++;
    $prompt .= "<INPUT TYPE=\"radio\" NAME=\"MODE\" VALUE=\"ZOOM\"> Zoom&nbsp;in<br>";
  }
  if (-f "$maproot/$FORM{MAP}.map" ||    
      -f "$maproot/$FORM{MAP}-$FORM{ZOOM}.map") {
    $interactive = 1;
    $option_count++;
    if (!$selectitem) {
      $selectitem = "Select a route";
    }
    $selectitem =~ s/ /&nbsp;/g;
    $prompt .= "<INPUT TYPE=\"radio\" NAME=\"MODE\" VALUE=\"SELECT\"> $selectitem<br>";
  }
  if (-e "$maproot/$FORM{MAP}.geo") {
    $option_count++;
    $prompt .= "<INPUT TYPE=\"radio\" NAME=\"MODE\" VALUE=\"TRANSIT\"> Zoom&nbsp;to&nbsp;location on local transit map ";
  }

  if ($option_count == 1) {
    $prompt =~ s/radio/hidden/;
    $prompt =~ s/>/ CHECKED>/;
    $prompt =~ s/> (.)/"> ".lc($1)/e;
    $prompt = "Click on the map to $prompt\n";
  } elsif ($option_count > 1) {
    $prompt =~ s/>/ CHECKED>/;
    $prompt = "<table><tr><td align=left>Click on the map to:<br>$prompt</td></tr></table>\n";
  }

  foreach $dir ('ul', 'u', 'ur', 'l', 'r', 'dl', 'd', 'dr') {
    $arrow{$dir} = "<INPUT TYPE=image NAME=$dir HEIGHT=25 WIDTH=25 SRC=$icons/$dir.gif BORDER=0>";
  }

  if (-d "$maproot/$mappath/Legend" || ($new && -d "$maproot/$mappath/NEW/Legend")) {
    $arrow{'legend'} = "<INPUT TYPE=image NAME=legend HEIGHT=25 WIDTH=62 SRC=$icons/new_legend.gif BORDER=0> ";
  } else {
    $arrow{'legend'} = '';
  }
  if ($mile) {
    ($dx) = &gifsize("$maproot/$mappath/${mapname}-$FORM{ZOOM}.gif");

    $scalex = $mile * $dx / $hx;
    $scaled = $scaleup = 1;

    while ($scalex > 200) { 
      $scalex /= 2; 
      $scaled *= 2;
    }
    while ($scalex < 20) { 
      $scalex *= 10; 
      $scaleup *= 10;
    }
    $scalex = int($scalex);
    
    if ($scaled > 1) {
      $unit = "1/$scaled mile";
    } elsif ($scaleup > 1) { 
      $unit = "$scaleup miles";
    } else {
      $unit = "1 mile";
    }
    
    $scale_prog = $ENV{SCRIPT_NAME};	# get directory that this file is in
    $scale_prog =~ s/[^\/]*$/scale/;	# replace zoom with scale

    $arrow{'scale'} = "<IMG SRC=\"$scale_prog?$scalex\" ALT=\"\" HEIGHT=9 WIDTH=$scalex> $unit ";
  } else {
    $arrow{'scale'} = '';
  }
  
  $arrow{'compass'} =  (-e "$maproot/$mappath/${mapname}_compass.gif") ?
      "<IMG SRC=\"/Map/$mappath/${mapname}_compass.gif\" ALT=\"\">" :
	  '';
    

  $arrow{'download'} = "<INPUT TYPE=image NAME=download HEIGHT=25 WIDTH=62 SRC=\"$icons/download.gif\" BORDER=0> ";

  $arrow{'zo'} = ($FORM{ZOOM}) ?
      "<INPUT TYPE=image NAME=zo HEIGHT=25 WIDTH=62 SRC=\"$icons/new_zo.gif\" BORDER=0>" :
	  '';

  if ($FORM{YPART} == 0) {
      &turn_off('ul', 'u', 'ur');
  }
  if ($FORM{YPART} == $YNUM[$FORM{ZOOM}] - 1) {
      &turn_off('dl', 'd', 'dr');
  }
  if ($FORM{XPART} == 0) {
      &turn_off('ul', 'l', 'dl');
  }
  if ($FORM{XPART} == $XNUM[$FORM{ZOOM}] - 1) {
      &turn_off('ur', 'r', 'dr');
  }

  $img_file = "$FORM{MAP}/$mapname-$FORM{ZOOM}-$FORM{XPART}-$FORM{YPART}.gif";
  local($width, $height) = &gifsize("$maproot/$img_file");
  if (($width == -1) || ($height == -1)) {
    &handle_error('An unexpected error has occurred!', 'The map image was not found.', "can't open $maproot/$img_file");
  }

  $size_tag = "WIDTH=$width HEIGHT=$height";
  $colwidth = int(($width - 25) / 2);
  $totalwidth = $width + 50;

  $img_file = "$mapurlpath/$img_file";

  &header;

  print "<FORM METHOD=GET ACTION=\"$script\">";

  if ($interactive || $depth > $FORM{ZOOM}) {
    $map = "<INPUT TYPE=\"image\" NAME=\"Map\" SRC=\"$img_file\" $size_tag align=middle>";
  } else { 
    $map = "<IMG SRC=\"$img_file\" $size_tag align=middle>";
  }

  if ($depth && $FORM{ZOOM}) {
      print <<"MAP1";

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=$totalwidth>
<TR ALIGN=CENTER VALIGN=bottom>
 <TD><NOBR>$arrow{ul}</TD>
 <TD WIDTH=$colwidth>$arrow{zo}$space$arrow{legend}$space$arrow{download}</TD>
 <TD>$arrow{u}</TD>
 <TD WIDTH=$colwidth>$prompt</TD>
 <TD>$arrow{ur}</NOBR></TD></TR>
<TR ALIGN=CENTER>
 <TD><NOBR>$arrow{l}</TD>
 <TD COLSPAN=3><TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2><TR><TD>$map</TD></TR></TABLE></TD>
 <TD>$arrow{r}</NOBR><BR></TD></TR>
<TR ALIGN=CENTER VALIGN=top>
 <TD><NOBR>$arrow{dl}</TD>
 <TD>$arrow{scale} </TD>
 <TD>$arrow{d}</TD>
 <TD>$arrow{compass} </TD>
 <TD>$arrow{dr}</NOBR><BR></TD></TR>
</TABLE>

MAP1
  } else {
    print <<"MAP2";

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
<TR ALIGN=CENTER VALIGN=bottom>
 <TD ALIGN=LEFT>$arrow{zo}$space$arrow{legend}$space$arrow{download}</TD>
 <TD><NOBR>$prompt</NOBR></TD>
 <TD ALIGN=RIGHT>$space$arrow{compass}</TD></TR>
<TR><TD></TD></TR>
<TR><TD COLSPAN=3>$map</TD></TR>
<TR><TD></TD></TR>
<TR ALIGN=RIGHT><TD COLSPAN=3>$arrow{scale} <IMG SRC=$icons/dot.gif WIDTH=5 HEIGHT=15 ALT=\"\"></TD></TR>
</TABLE>

MAP2
  }

  &hidden();

  print "</FORM>\n";
  &desc();
  if (!$noheader) {
    &footer();
  }
  if ($script =~ /Admin/) {
    # useful for linking map references
    print "<p>/$FORM{MAP}?ZOOM=$FORM{ZOOM}&XPART=$FORM{XPART}&YPART=$FORM{YPART}";
    printf "<p>$FORM{MAP} %d %d\n", $hi*$hx, $hj*$hy if $hi;
  }
}

#####################################################################

sub header 
{
  my $link = '';

  return if $noheader;

  print "Content-type: text/html\n\n";
  print $html_header;
  print "<TITLE>$maptitle</TITLE></HEAD><BODY>\n";

  return if (defined $FORM{header} && $FORM{header} == 0);

  $link = ": $maptitle";


  print "<H1>$maptitle</H1>\n";
  print "<A HREF=\"/\">Main Menu</A>$link\n<hr>\n";
}

#####################################################################

sub min {
  local($a, $b) = @_;
  $a < $b ? $a : $b;
}


#####################################################################

sub log_access {
# LOG THE REQUEST

  open(LOG, ">>$request_log");
  print LOG "[$timestring] ";
  print LOG "$ENV{REMOTE_ADDR} ";
  print LOG "P:$ENV{PATH_INFO} " if ($ENV{PATH_INFO});
  print LOG "Q:$ENV{QUERY_STRING} " if ($ENV{QUERY_STRING});
  print LOG "F:$buffer" if ($ENV{CONTENT_LENGTH});
  print LOG "\n";
  close(LOG);
}

sub handle_error {
  local($errorstring, $description, $logstring) = @_;

  &log_access();

  if (!$noheader) {
    print <<"ERROR_HEADER";
Content-type: text/html

$html_header
<TITLE>Mapping Error</TITLE></HEAD>
<BODY>
<IMG WIDTH=508 HEIGHT=23 SRC="/IMG/header.gif" ALT="">

<H1>Mapping Error</H1>

<A HREF="/">Main Menu</A> : Mapping Error
<HR><P>

ERROR_HEADER
  }

  print <<"END";
<H2>$errorstring</H2>
$description<P>

If you have a direct link to this page, the URL may have changed.  If
so, you can find the new link from the <A HREF="/">main index
page</A>.  If the error persists, please send a <A
HREF="/cgi-bin/comment-form">comment</A> describing how it occurred.<P>

END

  open(ERRLOG, ">>$error_log");
  print ERRLOG "$timestring\n";
  for $k (keys %ENV) {
    print ERRLOG "$k: $ENV{$k}\n";
  }
  print ERRLOG "error: $logstring\n";
  print ERRLOG "$buffer" if $buffer;
  print ERRLOG "\n\n";

  if (!$noheader) {
    &footer();
    die("zoom error: ".$ENV{REMOTE_ADDR}." \"$logstring\"");
  } else {
    exit;
  }
}

#####################################################################

sub turn_off {
  foreach $dir (@_) {
    $arrow{$dir} = "<IMG SRC=$icons/_arrow.gif WIDTH=25 HEIGHT=25 BORDER=0>";
#    $arrow{$dir} = " ";
  }
}

#####################################################################

sub desc {
    if (-f "$maproot/$FORM{MAP}.desc") {
      print "<p>\n";
      &cat("$maproot/$FORM{MAP}.desc");
      print "<p>\n";
    }
}

#####################################################################

sub legend 
{
  &header;

  print "<FORM METHOD=GET ACTION=\"$script\">";

  print "<INPUT TYPE=image NAME=return SRC=/Map/IMG/map.gif HEIGHT=47 WIDTH=47 BORDER=0> Return to the map<hr><p>\n";

  my $legend = "$maproot/$mappath/Legend/index.txt";

  if ($new && -e "$maproot/$mappath/NEW/Legend") {
    $legend = "$maproot/$mappath/NEW/Legend/index.txt";
  }

  &cat($legend);

  &hidden();
  print "</form>\n";

  if (!$noheader) {
    &footer();
  }
}

#####################################################################

sub download 
{
  my($force) = shift;

  &header;

  print "<FORM METHOD=GET ACTION=\"$script\">\n";

  if ($force)
  {
    print "<H3>This map is not currently available for online viewing</H3>\n";
    print "Viewable maps shall be available soon.  We apologize for the inconvenience.<P><HR><P>\n";
  }
  else
  {
    print "<INPUT TYPE=image NAME=return SRC=/Map/IMG/map.gif HEIGHT=47 WIDTH=47 BORDER=0> Return to the map<HR><P>\n";
  }

  print << "DOWNLOAD-HEADER";
This map is available in the following forms:<P>

<TABLE BORDER=1 CELLPADDING=5 CELLSPACING=0>
<TR><TH>Format</TH><TH>Image Size</TH><TH>File Size</TH><TH><BR></TH></TR>
DOWNLOAD-HEADER

  $file = "$FORM{MAP}.pdf";
  if (-e "$maproot/$file") {
    $acrobat = 1;
    push(@formats, "$mapurlpath/$file:Acrobat PDF:n/a:".(-s "$maproot/$file"));
  }

  $file = "$FORM{MAP}.ps";
  if (-e "$maproot/$file") {
    push(@formats, "$mapurlpath/$file:Postscript:n/a:".(-s "$maproot/$file"));
  }

  foreach $i (<$maproot/$FORM{MAP}-*.gif>) {
    ($file) = $i =~ /($FORM{MAP}-[^\/]*gif)$/;

    $isize = join('x', &gifsize("$maproot/$file"));
    if (-s "$maproot/$file" >= 2000000) {
      $note = '*';
      $large_gif_note = 1;
    } else {
      $note = '';
    }
    push(@formats, "$mapurlpath/$file:GIF$note:$isize:".(-s "$maproot/$file"));
  }

  foreach (@formats) {
    ($url, $format, $isize, $fsize) = split(/:/);
    $fsize = int($fsize / 1024);
    print "<TR ALIGN=CENTER><TD>$format</TD><TD>$isize</TD><TD>${fsize}k</TD><TD><A HREF=\"$url\">download</A></TR>\n";
  }
  print "</TABLE>\n";

  &hidden();
  print "</form><P>\n";

  if ($large_gif_note) {
    print "* Some browsers cannot display images this large.</p>";
  }

  if ($acrobat) {
#<A HREF="http://www.adobe.com/prodindex/acrobat/readstep.html"><IMG SRC="$icons/getacro.gif" WIDTH=88 HEIGHT=31 ALT="[Get Acrobat]" ALIGN=LEFT VALIGN=ABSMIDDLE></A> 

    print <<"ACROBAT";
Viewing PDF files requires the <A
HREF="http://www.adobe.com/prodindex/acrobat/readstep.html">Adobe
Acrobat Reader</A> application,<BR>
available free for a variety of computer platforms.<P>

<BR CLEAR=ALL>
ACROBAT
  }

  if (!$noheader) {
    &footer();
  }
}

#####################################################################

sub hidden {
  if (defined $FORM{header}) {
    print "<INPUT TYPE=hidden NAME=\"header\" VALUE=\"$FORM{header}\">\n";
  }
  print <<"HIDDEN";
<INPUT TYPE=hidden NAME="ZOOM" VALUE="$FORM{ZOOM}">
<INPUT TYPE=hidden NAME="XPART" VALUE="$FORM{XPART}">
<INPUT TYPE=hidden NAME="YPART" VALUE="$FORM{YPART}">
HIDDEN

}

#####################################################################

sub absolute_gif_coords {
  $x = int($hx * (($ix * $FORM{XPART}) + $FORM{'Map.x'}) /
	   ($ix * $XNUM[$FORM{ZOOM}]));
  $y = int($hy * (($iy * $FORM{YPART}) + $FORM{'Map.y'}) /
	   ($iy * $YNUM[$FORM{ZOOM}]));

  ($x) = ($x =~ /^([0-9]+)/);
  ($y) = ($y =~ /^([0-9]+)/);
  ($x, $y);
}

#####################################################################

sub mapscan {
  local($mapfile, $which_op) = @_; 

  ($x, $y) = &absolute_gif_coords();
  open (MAPSCAN, "./mapscan $which_op $maproot/$mapfile $x,$y|") || 
      print "Could not run mapscan helper program";
  $match_data = <MAPSCAN>;

  if (($error) = ($match_data =~ /ERROR:([^\n]*)/)) {
    &handle_error('The mapping server returned an error.', $error, $error);
  }

}

#####################################################################

sub url {
  local($url) = @_;

  if ($url !~ /^http/) {
    $url = "http://$ENV{'HTTP_HOST'}$url";
  }

  print <<"END";
Location: $url

Click <a href="$url">here</a> for the information you selected.
END

  exit;
}


sub find_in_db {
  local($name) = @_;

  if (-f "$maproot/$name.db") {
    open(DB,"$maproot/$name.db") || &handle_error('An unexpected error has occurred!', 'The map database is corrupted.', "Couldn't open $name.db");
    $_ = <DB>;
    close DB;
    (undef, $maptitle, $depth, $xnums, $ynums, $selectmode, $selectitem, $mile) = split(/:/);
    @XNUM = split(/,/, $xnums);
    @YNUM = split(/,/, $ynums);
    return 1;
  }

  open(DB,"$maproot/zoom.db") || &handle_error('An unexpected error has occurred!', 'The map database is corrupted.', "Couldn't open zoom.db");
  $found = 0;
  while (<DB>) {
    chop;
    next if (/^$/);
    next if (/^\#/);
    if (/^$name:/) {
      $found = 1;
      ($name, $maptitle, $depth, $xnums, $ynums, $selectmode, $selectitem, $mile) = split(/:/);
      @XNUM = split(/,/, $xnums);
      @YNUM = split(/,/, $ynums);

      last;
    }
  }
  close(DB);

  return $found;
}

##################################

sub footer {
    &cat("$footer");
};

sub gifsize {    # $filename needs to exist - otherwise returns (-1,-1)
  my($filename) = @_;
  my $header;
  open(GIF, "$filename") || warn("gifsize: could not open $filename");
  read(GIF, $header, 10);
  close(GIF);
  my($magic, $width, $height) = unpack("a6v2", $header);
  if ($magic ne 'GIF87a' && $magic ne 'GIF89a') {
     printf STDERR "Not a gif file: $filename\n";
     return (-1, -1);
  }
  return ($width, $height);
}

sub cat 
{
  my($filename) = (@_);

  open(FILE, $filename) || return;
  while (<FILE>) { 
    print ;
  }
  close FILE;
};




#####################################################################

sub select_route {
  #&mapscan("$FORM{MAP}.map", ($selectmode eq 'ALL') ? '-a' : '');
  if (-f "$maproot/$FORM{MAP}.map") {
    $imagemap_filename = "$FORM{MAP}.map";
  }
  if (-f "$maproot/$FORM{MAP}-$FORM{ZOOM}.map") {
    $imagemap_filename = "$FORM{MAP}-$FORM{ZOOM}.map";
  }
  &mapscan($imagemap_filename, ($selectmode eq 'ALL') ? '-a' : '');
  
  @routes = split(/\n/, $match_data);

# PROCESS MATCHES

  foreach $route (@routes) {
    $route =~ s/^\s*//g;
    $route =~ s/\s*$//g;

    next if ($route eq "MISSED");


# http://, //, or /
    if (($route =~ /^http:/) || ($route =~ /^\//)) {
      $route =~ s/^http://;

      local($link, $desc) = split(/:/, $route);
      $link =~ s/^\/\//http:\/\//;
      if (!$desc) {
	$desc = $link;
      }

      push(@output,"$desc\n$link");


# ANYTHING ELSE
    } else {
      push(@output, "$route\n");
    }
  }

# DISPLAY OR JUMP TO RESULT(S)

  if ($#output > 0) {
    &header();
    print "<H2>Matches</H2>\n";
    print "<UL>\n";
    foreach (sort @output) {
      local($text, $link) = split(/\n/);
      if ($link) {
	print "<LI><A HREF=\"$link\">$text</A>\n";
      } else {
	print "<LI>$text\n";
      }
    }
    print "</UL>\n";
    &footer();
    print "</BODY></HTML>\n";
  } else { #if ($#output == 0) {
    if ($routes[0] eq "MISSED") {
      if ($depth > $FORM{ZOOM}) { 
	&zoom();
      } else { 
#	&missed();
	&printmap();
      }
    } else {
      local($text, $link) = split(/\n/, $output[0]);
      &url($link);
    }
  }

  exit;
}

#####################################################################

sub missed {
  print "Content-type: text/html\n\n";

  print <<"END";
<HTML>
<HEAD><TITLE>No such link!</TITLE></HEAD>
<BODY>
<h1>No such link!</h1>
This portion of the map is not linked to anything.  Please try again.<p>
END
    &footer();
    print "</BODY></HTML>\n";

  exit;
}

#####################################################################

sub query_string {
  @pairs = split(/&/, $ENV{QUERY_STRING});

  foreach $pair (@pairs) {
    next unless ($pair =~ /=/);
    ($name, $value) = split(/=/, $pair);

    # Un-Webify plus signs and %-encoding
    $value =~ tr/+/ /;
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

    # Uncomment for debugging purposes
    # print "Setting $name to $value<P>";

    $QS{$name} = $value;
  }
}
