#include "gd.h"

#include <stdio.h>
#include <string.h>

#define MAXLINE 100


int white;
int black;
gdImagePtr im, im2;


int isname(char c)
{
  return (!isspace(c));
}

void draw_poly(double *pointarray_x, double *pointarray_y) 
{
  int i;
  for (i = 0; pointarray_x[i+1] != -1; i++) {
	gdImageLine(im, pointarray_x[i], pointarray_y[i], 
		    pointarray_x[i+1], pointarray_y[i+1], black);	
  }
  gdImageLine(im, pointarray_x[i], pointarray_y[i], 
      pointarray_x[0], pointarray_y[0], black);
}

void draw_rect(double *pointarray_x, double *pointarray_y) 
{
  gdImageLine(im, pointarray_x[0], pointarray_y[0], 
	      pointarray_x[0], pointarray_y[1], black);	
  gdImageLine(im, pointarray_x[0], pointarray_y[0], 
	      pointarray_x[1], pointarray_y[0], black);
  gdImageLine(im, pointarray_x[1], pointarray_y[0], 
	      pointarray_x[1], pointarray_y[1], black);
  gdImageLine(im, pointarray_x[0], pointarray_y[1], 
	      pointarray_x[1], pointarray_y[1], black);
}

void draw_line(double *pointarray_x, double *pointarray_y) 
{
  int i;
  for (i = 1; pointarray_x[i+1] != -1; i++) {
	gdImageLine(im, pointarray_x[i], pointarray_y[i], 
		    pointarray_x[i+1], pointarray_y[i+1], black);	
  }
}

void setup_gif(int test_x, int test_y) {
	/* First color allocated is background */
	white = gdImageColorAllocate(im, 255, 255, 255);
	/* Set transparent color */
	gdImageColorTransparent(im, white);
	black = gdImageColorAllocate(im, 0, 0, 0);
}

void write_gif() {
  /*out = stdout;*/
  /*fprintf(out, "Content-type: image/gif\n\n");*/
  /*if (!out) {
    fprintf(stderr, "Could not open %s for output\n", argv[2]);
    }*/
  gdImageGif(im, stdout);
  /*fclose(out);*/
  gdImageDestroy(im);
  /*return 0;*/
}

int main(int argc, char **argv)
{
  char *mapname, def[MAXLINE];
  int test_x, test_y;
  double *pointarray_x, *pointarray_y;
  int maxverts;
  int i, j, k, all, inset, negative;
  FILE *fp;
  char *t;
  
  all = 0;
  inset = 0;

  def[0] = '\0';

  while((argc > 1) && (*(t = argv[1]) == '-')) {
    argc--;
    argv++;
    t++;

    if (*t == 'a')
      all = 1;
    else if (*t == 'i')
      inset = 1;
  }

  if (argc != 3) {
    servererr("Usage: drawmap <mapname> <xsize>,<ysize>|<basegif>");
  }

  mapname = argv[1];
  
  if((!mapname) || (!mapname[0]))
    servererr("No map name given.");
  
  if(t = strchr(argv[2],',')) {
    *t++ = '\0';
    test_x = atoi(argv[2]);
    test_y = atoi(t);
    im = gdImageCreate(test_x, test_y);
  } else {
    FILE *g = fopen(argv[2], "r");
    if (!g)
      servererr("Couldn't background gif file.");
    im = gdImageCreateFromGif(g);
  }

  setup_gif(test_x, test_y);
  
  if(!(fp=fopen(mapname,"r")))
    servererr("Couldn't open map file.");
  
  maxverts = 100;
  pointarray_x = (double*)malloc(sizeof(double)*maxverts);
  pointarray_y = (double*)malloc(sizeof(double)*maxverts);

  while(!feof(fp)) {
    char type[MAXLINE];
    char url[MAXLINE];
    char num[10];
    
    char buf[MAXLINE];
    char *input,*tmp_dbuf,*dbuf_ptr;
    int dbuf_len;
    if (!fgets(buf, MAXLINE, fp))
      break;

    // this mess is to keep from having restrictions on the buffer size
    input=buf;
    dbuf_len=MAXLINE;
    while (!feof(fp) && input[strlen(input)-1]!='\n') {
      tmp_dbuf=(char *) malloc(MAXLINE+dbuf_len);
      memcpy(tmp_dbuf,input,dbuf_len);
      dbuf_len += MAXLINE;

      if (input != buf) {
	free(input);
      }
      input=tmp_dbuf;
      dbuf_ptr=input+strlen(input);
      fgets(dbuf_ptr, MAXLINE, fp);
    }
    // end buffer mashing
    
    if((input[0] == '#') || (!input[0]))
      continue;
    
    type[0] = '\0';url[0] = '\0';
    
    for(i=0;isname(input[i]) && (input[i]);i++)
      type[i] = input[i];
    type[i] = '\0';
    
    while(isspace(input[i])) ++i;
    for(j=0;input[i] && isname(input[i]);++i,++j)
      url[j] = input[i];
    url[j] = '\0';
    
    if(!strcmp(type,"default")) {
      strcpy(def,url);
      continue;
    }

    if (!strncmp("INSET=", url, 6) && !all && !inset)
      continue;

    k=0;
    while (input[i]) {
      while (isspace(input[i]) || input[i] == ',')
	i++;
      j = 0;
      negative = 1;
      if (input[i] == '-') {
	negative = -1;
	i++;
      }
      while (isdigit(input[i]))
	num[j++] = input[i++];
      num[j] = '\0';
      if (num[0] != '\0')
	pointarray_x[k] = negative * ((double) atoi(num));
      else
	break;
      while (isspace(input[i]) || input[i] == ',')
	i++;
      j = 0;
      negative = 1;
      if (input[i] == '-') {
        negative = -1;
        i++;
      }
      while (isdigit(input[i]))
	num[j++] = input[i++];
      num[j] = '\0';
      if (num[0] != '\0')
	pointarray_y[k++] = negative * ((double) atoi(num));
      else {
	fclose(fp);
	servererr("Missing y value.");
      }
      /*
	printf("%f,%f\n",pointarray_x[k-1], pointarray_y[k-1]);
	*/
      if (k == maxverts) {
	double *tmp;
	tmp = (double*)malloc(sizeof(double)*maxverts*2);
	memcpy(tmp, pointarray_x, sizeof(double)*maxverts);
	free(pointarray_x);
	pointarray_x = tmp;
	tmp = (double*)malloc(sizeof(double)*maxverts*2);
	memcpy(tmp, pointarray_y, sizeof(double)*maxverts);
	maxverts *= 2;
	free(pointarray_y);
	pointarray_y = tmp;
      }
    }
    if (input != buf) {
      free(input);
    }
    pointarray_x[k] = -1;
    if(!strcmp(type,"poly"))
      draw_poly(pointarray_x, pointarray_y);
    if(!strcmp(type,"rect"))
      draw_rect(pointarray_x, pointarray_y);
    if(!strcmp(type,"line"))
      draw_line(pointarray_x, pointarray_y);

    /*
    if(!strcmp(type,"circle"))
      if(pointincircle(testpoint,pointarray_x, pointarray_y))
	sendmesg(url, all);
    if(!strcmp(type,"rect"))
      if(pointinrect(testpoint,pointarray_x, pointarray_y))
	sendmesg(url, all);
    if(!strcmp(type,"line"))
      if(pointinline(testpoint,pointarray_x, pointarray_y))
	sendmesg(url, all);
    */
  }


  /*
    servererr("No default specified.");
    */
  write_gif();
  return 0;
}

servererr(char *msg)
{
  /*
    printf("Content-type: text/html%c%c",10,10);
    printf("<title>Mapping Server Error</title>");
    printf("<h1>Mapping Server Error</h1>");
    printf("This server encountered an error:<p>");
    */

  printf("ERROR:%s\n", msg);
  exit(-1);
}
