#include "gd.h"

/* Program to create cropped image with outline of each polygon */

#include <stdio.h>
#include <string.h>

#define MAXLINE 100


int white;
int black;
gdImagePtr im, im2;


int isname(char c)
{
  return (!isspace(c));
}

int draw_poly(gdImagePtr im, double *pointarray_x, double *pointarray_y) 
{
  int i;
  int black = gdImageColorAllocate(im, 255, 0, 0);
  for (i = 0; pointarray_x[i+1] != -1; i++) {
    if (pointarray_x[i] != -2 && pointarray_x[i+1] != -2)
	gdImageLine(im, pointarray_x[i], pointarray_y[i], 
		    pointarray_x[i+1], pointarray_y[i+1], black);	
  }
}

double max(double *pointarray) 
{
  int i;
  double max = -1;
  for (i = 0; pointarray[i] != -1; i++) {
    if (pointarray[i] > max)
      max = pointarray[i];
  }
  return max;
}

double min(double *pointarray) 
{
  int i;
  double min = pointarray[0];
  for (i = 0; pointarray[i] != -1; i++) {
    if (pointarray[i] < min && pointarray[i] > 0) 
      min = pointarray[i];
  }
  return min;
}

void shift_pointarray(double *pointarray, double d) 
{
  int i;
  for (i = 0; pointarray[i] != -1; i++) {
    if (pointarray[i] > 0)
      pointarray[i] += d;
  }
}

void setup_gif() {
	/* First color allocated is background */
	white = gdImageColorAllocate(im, 255, 255, 255);
	/* Set transparent color */
	gdImageColorTransparent(im, white);
	black = gdImageColorAllocate(im, 0, 0, 0);
}

void write_gif() {
  gdImageGif(im, stdout);
  gdImageDestroy(im);
}

void draw_outline(gdImagePtr im, double *pointarray_x, double *pointarray_y,
		  char *url) {
      	FILE *out;
	char *suffix;
	char buf[MAXLINE];
	gdImagePtr im2;
	int w, h, x, y, scanned;
	strcpy(buf, "/www/docs/Land");
	strcat(buf, url);
	if (!(suffix = strstr(buf, "html"))) {
	  fprintf(stderr, "Bogus url: %s\n", url);
	  exit(1);
	}
	strcpy(suffix, "gif");
	out = fopen(buf, "w");
	if (!out) {
	  fprintf(stderr, "Could not open %s for output\n", buf);
	  exit(1);
	}		

	x = min(pointarray_x) - 100;
	y = min(pointarray_y) - 100;
	x = x < 0 ? 0 : x;
	y = y < 0 ? 0 : y;
	w = max(pointarray_x) + 100;
	h = max(pointarray_y) + 100;
	w = w > im->sx ? im->sx : w;
	h = h > im->sy ? im->sy : h;
	w -= x;
	h -= y;

	printf ("%s %d %d %d %d\n", url, x, y, w, h);
	  
	im2 = gdImageCreate(w, h);
	gdImageCopy(im2, im, 0, 0, x, y, w, h);

	shift_pointarray(pointarray_x, -x);
	shift_pointarray(pointarray_y, -y);
	draw_poly(im2, pointarray_x, pointarray_y);
	shift_pointarray(pointarray_x, x);
	shift_pointarray(pointarray_y, y);

	gdImageGif(im2, out);
	fclose(out);
	gdImageDestroy(im2);
}

int main(int argc, char **argv)
{
  char *mapname, def[MAXLINE];
  int test_x, test_y;
  double *pointarray_x, *pointarray_y;
  int maxverts;
  int i, j, k, all, inset, negative;
  FILE *fp;
  char *t;
  
  char type[MAXLINE];
  char url[MAXLINE];
  char new_url[MAXLINE];
  char num[10];
    
  all = 0;
  inset = 0;

  def[0] = '\0';

  while((argc > 1) && (*(t = argv[1]) == '-')) {
    argc--;
    argv++;
    t++;

    if (*t == 'a')
      all = 1;
    else if (*t == 'i')
      inset = 1;
  }

  if (argc != 3) {
    servererr("Usage: drawmap <mapname> <xsize>,<ysize>|<basegif>");
  }

  mapname = argv[1];
  
  if((!mapname) || (!mapname[0]))
    servererr("No map name given.");
  
  if(t = strchr(argv[2],',')) {
    *t++ = '\0';
    test_x = atoi(argv[2]);
    test_y = atoi(t);
    im = gdImageCreate(test_x, test_y);
  } else {
    FILE *g = fopen(argv[2], "r");
    if (!g)
      servererr("Couldn't open background gif file.");
    im = gdImageCreateFromGif(g);
  }
  if (!im) {
    servererr("Couldn't create background gif.");
  }

  setup_gif();
  
  if(!(fp=fopen(mapname,"r")))
    servererr("Couldn't open map file.");
  
  maxverts = 100;
  pointarray_x = (double*)malloc(sizeof(double)*maxverts);
  pointarray_y = (double*)malloc(sizeof(double)*maxverts);
  pointarray_x[0] = -1;

  while(!feof(fp)) {
    char buf[MAXLINE];
    char *input,*tmp_dbuf,*dbuf_ptr;
    int dbuf_len;
    if (!fgets(buf, MAXLINE, fp))
      break;

    // this mess is to keep from having restrictions on the buffer size
    input=buf;
    dbuf_len=MAXLINE;
    while (!feof(fp) && input[strlen(input)-1]!='\n') {
      tmp_dbuf=(char *) malloc(MAXLINE+dbuf_len);
      memcpy(tmp_dbuf,input,dbuf_len);
      dbuf_len += MAXLINE;

      if (input != buf) {
	free(input);
      }
      input=tmp_dbuf;
      dbuf_ptr=input+strlen(input);
      fgets(dbuf_ptr, MAXLINE, fp);
    }
    // end buffer mashing
    
    if((input[0] == '#') || (!input[0]))
      continue;
    
    for(i=0;isname(input[i]) && (input[i]);i++)
      type[i] = input[i];
    type[i] = '\0';
    
    if(strcmp(type,"poly")) {
      continue;
    }

    while(isspace(input[i])) 
      ++i;

    for(j=0;input[i] && isname(input[i]);++i,++j)
      new_url[j] = input[i];
    new_url[j] = '\0';
    if (strcmp(url, new_url)) {
      if (*url)
	draw_outline(im, pointarray_x, pointarray_y, url);
      strcpy(url, new_url);
      k = 0;
    } else {
      for (k = 0; pointarray_x[k] != -1; k++)
	;
      pointarray_x[k] = -2;
      pointarray_y[k] = -2;
      k++;
    }

    if (!strncmp("INSET=", url, 6) && !all && !inset)
      continue;

    while (input[i]) {
      while (isspace(input[i]) || input[i] == ',')
	i++;
      j = 0;
      negative = 1;
      if (input[i] == '-') {
	negative = -1;
	i++;
      }
      while (isdigit(input[i]))
	num[j++] = input[i++];
      num[j] = '\0';
      if (num[0] != '\0')
	pointarray_x[k] = negative * ((double) atoi(num));
      else
	break;
      while (isspace(input[i]) || input[i] == ',')
	i++;
      j = 0;
      negative = 1;
      if (input[i] == '-') {
        negative = -1;
        i++;
      }
      while (isdigit(input[i]))
	num[j++] = input[i++];
      num[j] = '\0';
      if (num[0] != '\0')
	pointarray_y[k++] = negative * ((double) atoi(num));
      else {
	fclose(fp);
	servererr("Missing y value.");
      }
      /*
	printf("%f,%f\n",pointarray_x[k-1], pointarray_y[k-1]);
	*/
      if (k >= maxverts - 1) {
	double *tmp;
	tmp = (double*)malloc(sizeof(double)*maxverts*2);
	memcpy(tmp, pointarray_x, sizeof(double)*maxverts);
	free(pointarray_x);
	pointarray_x = tmp;
	tmp = (double*)malloc(sizeof(double)*maxverts*2);
	memcpy(tmp, pointarray_y, sizeof(double)*maxverts);
	maxverts *= 2;
	free(pointarray_y);
	pointarray_y = tmp;
      }
    }
    if (input != buf) {
      free(input);
    }
    pointarray_x[k] = -1;
    pointarray_y[k] = -1;



    /*
    if(!strcmp(type,"poly")) {
    }  
    if(!strcmp(type,"circle"))
      if(pointincircle(testpoint,pointarray_x, pointarray_y))
	sendmesg(url, all);
    if(!strcmp(type,"rect"))
      if(pointinrect(testpoint,pointarray_x, pointarray_y))
	sendmesg(url, all);
    if(!strcmp(type,"line"))
      if(pointinline(testpoint,pointarray_x, pointarray_y))
	sendmesg(url, all);
    */
  }
  draw_outline(im, pointarray_x, pointarray_y, url);

}

servererr(char *msg)
{
  /*
    printf("Content-type: text/html%c%c",10,10);
    printf("<title>Mapping Server Error</title>");
    printf("<h1>Mapping Server Error</h1>");
    printf("This server encountered an error:<p>");
    */

  printf("ERROR:%s\n", msg);
  exit(-1);
}
