#!/usr/local/bin/perl

$x = 396;
$y = 762;
$d = 5;
print "$x,$y\n\n";
$input = "139,1367 173,990 185,939 204,905 224,885 794,473 859,437 901,420 946,408 960,408"; 

@points = split(/ /,$input);

for ($i = 0; $i < $#points; $i++) {
  ($x1, $y1) = split(/,/, $points[$i]);
  ($x2, $y2) = split(/,/, $points[$i+1]);
  
  print "$x1,$y1 $x2,$y2\n";

  $lsqrd = (($x2-$x1)**2 + ($y2-$y1)**2);

  if ($lsqrd > 0) {
    $l = sqrt($lsqrd);

    $s = ((($y1-$y) * ($x2-$x1)) - (($x1-$x) * ($y2-$y1))) / $lsqrd;
    if ($s*$l < $d) {
      $r = ((($y1-$y) * ($y1-$y2)) - (($x1-$x) * ($x2-$x1))) / $lsqrd;
      $delta = $d / $l;
      
      if (($r > -$delta) && ($r < 1 + $delta)) {
	print "$r - HIT!\n";
      }
    }
  }
}

exit;



sub old {

  for ($i = 0; $i < $#points; $i++) {
    ($x1, $y1) = split(/,/, $points[$i]);
    ($x2, $y2) = split(/,/, $points[$i+1]);
    
    if ($x1 == $x2) {
      if (&abs($x1 - $x) < $dx) {
	print "HIT!\n";
      }
    } else {
      $m = ($y2 - $y1) / ($x2 - $x1);
      $b = ($y1 - ($m*$x1));
      
      $ix = ($m*$y - $m*$b + $x) / (1 + $m**2);
      $iy = $m*$ix + $b;
      
      $l = sqrt((($x-$ix)**2) + (($y-$iy)**2));
      
      if (((($ix < $x1+$d) && ($ix > $x2-$d)) 
	   || (($ix < $x2+$d) && ($ix > $x1-$d)))
	  && ($l < $d)) {
	print "HIT!\n";
      }
    }
  }
}

sub abs {
  ($i) = @_;
  
  if ($i < 0) {
    return -$i;
  } else {
    return $i;
  }
}
