import java.awt.*;
import java.awt.event.*;

class ButtonBar extends Panel implements ActionListener {
  ImagePanel ip;
  Button reset, train, close, imswitch;

  public ButtonBar(ImagePanel ip) {
    this.ip = ip;
    reset = new Button("Reset");
    reset.addActionListener(this);
    train = new Button("Train");
    train.addActionListener(this);
    close = new Button("Close Contour");
    close.addActionListener(this);
    imswitch = new Button("Switch Image");
    imswitch.addActionListener(this);

    add(new Label("MRI Slice"));
    add(reset);
    add(train);
    add(close);
    add(imswitch);
    add(new Label("Cost Function"));
  }

  public void actionPerformed(ActionEvent e) {
    if(e.getActionCommand() == "Reset") {
      ip.reset();
    }
    else if(e.getActionCommand() == "Train") {
      ip.train();
    }
    else if(e.getActionCommand() == "Close Contour") {
      ip.closeContour();
    }
    else if(e.getActionCommand() == "Switch Image") {
      ip.switchImage();
    }
  }
}
