import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;

class ImagePanel extends Panel implements MouseListener, MouseMotionListener, KeyListener {
  Image brain, offscreen;
  Graphics offgraphics;
  Point points[];
  Paint paint;
  boolean needupdate;
  Point start, end, cursor;
  boolean painting;
  MediaTracker tracker;
  CostPanel cp;
  boolean whichpic;
  boolean closed;
  Applet parent;
  double gausstable[], gausstableb[], mean, meanb, sd, sdb;
  PQ Q;
  int raster[];

  public void keyPressed(KeyEvent k) {
    switch(k.getKeyChar()) {
      case 't':
      case 'T':
        train();
        break;
      case 'r':
      case 'R':
        reset();
        break;
      case 's':
      case 'S':
        switchImage();
        break;
      case 'c':
      case 'C':
        closeContour();
    }
  }

  public void closeContour() {
    if(closed == false && !painting && start != null && start.next != null) {
      addPointAt(start.x, start.y);
      if(start == end) {
        closed = true;
        cursor = null;
      }
    }
  }

  public void keyReleased(KeyEvent k) {
  }

  public void keyTyped(KeyEvent k) {
  }

  public double getCost(int x, int y) {
    return points[y * 256 + x].cost;
  }

  public double gauss(double x) {
    if(gausstable[(int)x] == -1)
      gausstable[(int)x] = Math.exp((-0.5*((x-mean)/sd)*((x-mean)/sd)));
    return gausstable[(int)x];
  }

  public double gaussb(double x) {
    if(gausstableb[(int)x] == -1)
      gausstableb[(int)x] = Math.exp((-0.5*((x-meanb)/sd)*((x-meanb)/sdb)));
    return gausstableb[(int)x];
  }

  public double partialCost(Point from, Point to) {
    int x1 = from.x;
    int y1 = from.y;
    int x2 = to.x;
    int y2 = to.y;

    if(y1 > y2)
      return raster[x1 + (y1 - 1) * 256] & 255;
    else if(y1 < y2)
      return raster[x1 - 1 + (y2 - 1) * 256] & 255;
    else if(x1 < x2)
      return raster[x1 + y1 * 256] & 255;
    else
      return raster[x1 + (y1 - 1) * 256] & 255;
  }

  public double partialCostb(Point from, Point to) {
    int x1 = from.x;
    int y1 = from.y;
    int x2 = to.x;
    int y2 = to.y;

    if(y1 > y2)
      return raster[x1 - 1 + (y1 - 1) * 256] & 255;
    else if(y1 < y2)
      return raster[x1 + (y2 - 1) * 256] & 255;
    else if(x1 < x2)
      return raster[x1 + (y1 - 1) * 256] & 255;
    else
      return raster[x1 + y1 * 256] & 255;
  }

  public double cost(Point from, Point to) {
    return 1-0.5*(gauss(partialCost(from, to)) +
                  gaussb(partialCostb(from, to)));
  }

  public void resetGauss() {
    int i;

    for(i = 0; i < 256; i++)
      gausstable[i] = gausstableb[i] = -1;
  }

  public void reset() {
    int i;

    start = end = cursor = null;
    closed = false;

    for(i = 0; i < 256 * 256; i++)
      points[i] = new Point(i % 256, i / 256);

    needupdate = true;
    repaint();
  }

  public void computeCostImage() {
    int x, y, i, best, current;
    int neighbors[][] = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
    int costi[] = new int[256 * 256];

    try {
      tracker.waitForID(0);
    } catch(InterruptedException e) {}

    for(y = 1; y < 255; y++)
      for(x = 1; x < 255; x++) {
        best = 0;
        for(i = 0; i < 4; i++) {
          current = (int)(255 - cost(points[x + y * 256], points[x +
                          neighbors[i][0] + (y + neighbors[i][1]) * 256])
                          * 255);
          if(current > best)
            best = current;
        }
        costi[x + y * 256] = best;
      }
    byte r[] = new byte[256];
    byte g[] = new byte[256];
    byte b[] = new byte[256];
    for(i = 0; i < 256; i++)
      r[i] = g[i] = b[i] = (byte)i;
    cp.setImage(createImage(new MemoryImageSource(256, 256, new IndexColorModel(8, 256, r, g, b), costi, 0, 256)));
  }

  public void train() {
    double temp, tempb;
    int count = 0;
    double sqsum = 0, sqsumb = 0;
    Point current = start;

    mean = 0;
    meanb = 0;

    if(!painting && start == null) {
      painting = true;
      return;
    }

    if(start.next == null)
      return;

    while(current != null && (count == 0 || current != start)) {
      if(current.next != null) {
        count++;
        temp = partialCost(current, current.next);
        tempb = partialCostb(current, current.next);
        mean += temp;
        meanb += tempb;
        sqsum += temp * temp;
        sqsumb += tempb * tempb;
      }
      current = current.next;
    }

    mean /= (double)count;
    meanb /= (double) count;
    sd = Math.sqrt((sqsum - 2 * mean * mean * (double)count + mean
                      * mean * (double)count)/(double)(count-1));
    sdb = Math.sqrt((sqsumb - 2 * meanb * meanb * (double)count + meanb
                      * meanb * (double)count)/(double)(count-1));
    resetGauss();
    if(!painting)
      shortestPaths(end);
    else
      reset();
    computeCostImage();
    repaint();
  }

  public void switchImage() {
    reset();
    if(whichpic)
      brain = parent.getImage(parent.getDocumentBase(), "brain1.gif");
    else
      brain = parent.getImage(parent.getDocumentBase(), "brain2.gif");
    tracker.addImage(brain, 0);
    whichpic = !whichpic;
    offscreen = null;
    needupdate = true;
    repaint();
  }

  public void initPoints() {
    int i;

    for(i = 0; i < 256 * 256; i++) {
      points[i].accessor = Point.NONE;
      points[i].cost = Point.INFINITY;
      points[i].previous = null;
    }
  }

  public void addPointAt(int x, int y) {
    Point current = points[x + y * 256];

    if(x > 0 && x < 255 && y > 0 && y < 255 && !closed &&
       (current == start || current.next == null) && (start == null ||
       current.previous != null)) {
      while(current != null && current.previous != null && current != end) {
        current.previous.next = current;
        current = current.previous;
      }

      if(start == null)
        start = current;

      end = points[x + y * 256];

      shortestPaths(end);
    }
  }

  public void shortestPaths(Point start) {
    Point current, v;
    int neighbors[][] = {{-1, 0}, {1, 0}, {0, -1}, {0, 1}};
    int newx, newy, i;
    double tempcost;

    initPoints();
    start.cost = 0;
    Q.addPoint(start);

    while(!Q.empty()) {
      current = Q.deleteMin();
      current.accessor = Point.DONE;
      if(current.next == null)
        for(i = 0; i < 4; i++) {
          newx = current.x + neighbors[i][0];
          newy = current.y + neighbors[i][1];
          if(newx > 0 && newx < 255 && newy > 0 && newy < 255) {
            v = points[newx + newy * 256];
            if(v.accessor != Point.DONE) {
              tempcost = current.cost + cost(current, v);
              if(tempcost < v.cost) {
                v.previous = current;
                Q.setCost(v, tempcost);
              }
            }
          }
        }
    }
  }

  public ImagePanel(Image brain, CostPanel cp, Applet parent) {
    int i;

    closed = false;
    this.parent = parent;
    this.brain = brain;
    whichpic = false;
    this.cp = cp;
    tracker = new MediaTracker(this);
    tracker.addImage(brain, 0);
    addMouseMotionListener(this);
    addMouseListener(this);
    addKeyListener(this);
    points = new Point[256 * 256];
    needupdate = false;
    start = end = null;
    painting = false;
    offscreen = null;
    points = new Point[256 * 256];
    gausstable = new double[256];
    gausstableb = new double[256];
    raster = new int[256 * 256];
    resetGauss();
    reset();
    Q = new PQ(256*256);
  }

  public Dimension getPreferredSize() {
    return new Dimension(256, 256);
  }

  public void mouseDragged(MouseEvent e) {
    int ind = e.getY() * 256 + e.getX();

    if(ind >= 256 * 256)
      return;

    if(painting) {
      if(points[ind].previous == null && points[ind].next == null
         && start != points[ind])
        if(end == null)
          start = end = points[ind];
        else {
          end.next = points[ind];
          end.next.previous = end;
          end = end.next;
        }
      needupdate = true;
      repaint();
    }
  }

  public void mouseMoved(MouseEvent e) {
    int ind = e.getY() * 256 + e.getX();

    if(ind >= 256 * 256)
      return;

    if(!painting) {
      if(points[ind].previous != null && points[ind].next == null)
        cursor = points[ind];
      needupdate = true;
      repaint();
    }
  }

  public void mousePressed(MouseEvent e) {
    int ind = e.getY() * 256 + e.getX();

    if(ind >= 256 * 256)
      return;

    if(painting) {
      if(points[ind].previous == null && points[ind].next == null
         && start != points[ind])
        if(end == null)
          start = end = points[ind];
        else {
          end.next = points[ind];
          end.next.previous = end;
          end = end.next;
        }
    }
    else
      addPointAt(e.getX(), e.getY());
    needupdate = true;
    repaint();
  }

  public void mouseReleased(MouseEvent e) {
    if(painting) {
      train();
      painting = false;
      needupdate = true;
      repaint();
    }
  }

  public void mouseEntered(MouseEvent e) {
  }

  public void mouseExited(MouseEvent e) {
  }

  public void mouseClicked(MouseEvent e) {
  }

  public void update(Graphics g) {
    Point current;

    if(offscreen == null) {
      try {
        tracker.waitForID(0);
      } catch(InterruptedException e) {}
      offscreen = createImage(256, 256);
      offgraphics = offscreen.getGraphics();
      offgraphics.drawImage(brain, 0, 0, this);
      try {
        (new PixelGrabber(brain, 0, 0, 256, 256, raster, 0, 256)).grabPixels();
      } catch(InterruptedException e) {}
      computeCostImage();
    }
    if(needupdate) {
      offgraphics.drawImage(brain, 0, 0, this);
      current = start;
      if(painting)
        offgraphics.setColor(Color.magenta);
      else
        offgraphics.setColor(Color.yellow);
      while(current != null && current.next != null && current.next != start) {
        offgraphics.drawLine(current.x, current.y, current.next.x, current.next.y);
        current = current.next;
      }
      current = cursor;
      while(current != null && current.previous != null) {
        offgraphics.drawLine(current.x, current.y, current.previous.x, current.previous.y);
        current = current.previous;
      }
      needupdate = false;
    }
    g.drawImage(offscreen, 0, 0, this);
  }

  public void paint(Graphics g) {
    if(offscreen == null) {
      try {
        tracker.waitForID(0);
      } catch(InterruptedException e) {}
      offscreen = createImage(256, 256);
      offgraphics = offscreen.getGraphics();
      offgraphics.drawImage(brain, 0, 0, this);
      try {
        (new PixelGrabber(brain, 0, 0, 256, 256, raster, 0, 256)).grabPixels();
      } catch(InterruptedException e) {}
      computeCostImage();
    }
    g.drawImage(offscreen, 0, 0, this);
  }
}
