class PQ {
  int INFINITY = 32000;
  int NONE = -1;

  Point queue[];
  int numpoints, numelements;

  PQ(int numpoints) {
    int i;

    this.numpoints = numpoints + 1;

    queue = new Point[numpoints * 2];

    for(i = 0; i < numpoints * 2; i++)
      queue[i] = null;

    numelements = 1;
  }

  boolean empty() {
    if(numelements==1)
      return true;
    else
      return false;
  }

  Point deleteMin() {
    Point answer = queue[1];
    answer.accessor = NONE;

    if(--numelements > 1) {
      queue[1] = queue[numelements];
      queue[numelements] = null;
      percolateDown(1);
    }

    return answer;
  }

  void addPoint(Point newpoint) {
    newpoint.accessor = numelements;
    queue[numelements] = newpoint;
    percolateUp(numelements++);
  }

  void setCost(Point current, double cost) {
    current.cost = cost;
    if(current.accessor == NONE)
      addPoint(current);
    else {
      percolateUp(current.accessor);
      percolateDown(current.accessor);
    }
  }

  void percolateUp(int accessor) {
    Point temp;
    double parentcost;

    parentcost = (queue[accessor / 2] != null)?queue[accessor / 2].cost:-1;

    while(parentcost > queue[accessor].cost) {
      temp = queue[accessor/2];
      queue[accessor/2] = queue[accessor];
      queue[accessor] = temp;
      queue[accessor/2].accessor = accessor/2;
      queue[accessor].accessor = accessor;
      accessor /= 2;
      parentcost = (accessor/2 != 0)?queue[accessor/2].cost:-1;
    }
  }

  void percolateDown(int accessor) {
    Point temp;
    double leftcost, rightcost;

    leftcost = (queue[accessor * 2] != null)?queue[accessor * 2].cost:INFINITY;
    rightcost = (queue[accessor * 2 + 1] != null)?queue[accessor * 2 + 1].cost:INFINITY;

    while(leftcost < queue[accessor].cost ||
          rightcost < queue[accessor].cost) {
      if(leftcost < rightcost) {
        temp = queue[accessor * 2];
        queue[accessor * 2] = queue[accessor];
        queue[accessor] = temp;
        queue[accessor * 2].accessor = accessor * 2;
        queue[accessor].accessor = accessor;
        accessor *= 2;
      }
      else {
        temp = queue[accessor * 2 + 1];
        queue[accessor * 2 + 1] = queue[accessor];
        queue[accessor] = temp;
        queue[accessor * 2 + 1].accessor = accessor * 2 + 1;
        queue[accessor].accessor = accessor;
        accessor = accessor * 2 + 1;
      }
      leftcost = (queue[accessor * 2] != null)?queue[accessor * 2].cost:INFINITY;
      rightcost = (queue[accessor * 2 + 1] != null)?queue[accessor * 2 + 1].cost:INFINITY;
    }
  }
}
