#!/usr/bin/env python3

# 1/30/2020 updated sample output

from __future__ import print_function #in case somebody tries to run this file with Python 2
import sys
import os

DATA_DIR = '/u/cs246/data/adult/' #TODO: change this to wherever you put the data if working on a different machine

def err(msg):
    print('ERROR: {}'.format(msg), file=sys.stderr)
    exit()

def find_filenames():
    return [fn for fn in os.listdir('.') if os.path.isfile(fn) and fn.endswith('_backprop.py')]

def get_output(filename):
    import subprocess
    cmd = './{} --nodev --iterations 1 --weights_files w1.txt w2.txt --lr 0.01 --train_file {} --test_file {} --print_weights'.format(filename, os.path.join(DATA_DIR, 'a7a.train'), os.path.join(DATA_DIR, 'a7a.test'))
    print('Running this command:\n{}'.format(cmd))
    try:
        output = subprocess.check_output(cmd.split()).decode('utf-8')
    except subprocess.CalledProcessError:
        err('Python file did not exit successfully (likely crashed).')
    except OSError as e:
        if e.errno == 13:
            err('Python file is not executable; run this command:\nchmod u+x {}'.format(filename))
        elif e.errno == 8:
            err('Python file does not start with a shebang; put this line at the very top:\n#!/usr/bin/python3\n(Replace python3 with python if using Python 2)')
        elif e.errno == 2:
            err('Unable to execute python file; if you ever edited the file on Windows, it is possible that the line endings are wrong, so try running this command:\ndos2unix {}\nOtherwise, you\'ll have to take a look at it and see what went wrong.'.format(filename))
        else:
            print('Got an OS error not caused by permissions or a shebang problem; you\'ll have to take a look at it and see what the problem is. See below:')
            raise e

    return output

def tokens(s):
    result = []
    for tok in s.split():
        try:
            result.append(float(tok))
        except ValueError as e:
            result.append(tok)
    return result


def round_to_sigfigs(num, sigfigs):
    from math import log10, floor
    if num == 0:
        return num
    else:
        return round(num, -int(floor(log10(abs(num)))) + sigfigs - 1)

def fuzzy_match(line, req):
    line_toks = tokens(line)
    if len(line_toks) != len(req):
        return False
    else:
        for l,r in zip(line_toks, req):
            if type(l) != type(r):
                return False
            elif type(l) == str and l != r:
                return False
            elif type(l) == float and round_to_sigfigs(l,6) != round_to_sigfigs(r,6): #float
                return False
        return True

def verify_output(output):
    acc_req = tokens('Test accuracy: 0.8361895757002719')
    got_acc = False
    hidden_weight_req1 = tokens('Hidden layer weights: 3.864798738854993698e-01 -6.435856509157182603e-02 -3.338413403508442845e-01 -4.670305632191970591e-01 -4.043117151874476844e-01 1.716742747824382131e-01 -1.453841000199760647e-01 2.521443737002511121e-01 7.804378170489575939e-02 -3.383227485961698977e-01 -9.206585013050848365e-02 1.322151483892875790e-01 -3.741207539267847881e-01 4.470225873996220289e-01 9.460107919585486469e-02 2.175286430030862750e-01 3.431355568723011840e-01 -9.279080681187706903e-02 -2.157546655456006601e-01 -3.688524700263032946e-02 3.969472026763502526e-01 2.748351867867500353e-02 -3.171697369002572930e-01 1.198435160643817610e-01 -1.001908026999000362e-01 -2.410022595828225367e-01 3.448739062669667343e-02 -2.562183033304801794e-01 -1.534795749297614975e-01 3.585141269792812002e-01 -1.780443340648494022e-01 3.068397064551610653e-01 5.948012692415738378e-03 1.985025327607613937e-02 6.528326960534927004e-01 -1.445334345359252648e-01 1.105466935546721152e-01 3.430906337230636982e-01 -9.100164522920188848e-01 -1.148250229427347779e+00 4.774777135913348819e-02 7.637171958522840365e-01 -3.881228617314764762e-01 -1.015772212436458349e-01 -4.055188088689113957e-01 2.846231612017193213e-01 -1.997745049287384389e-01 3.306673591939668921e-01 2.863252207077929823e-01 2.143368758169769961e-01 -1.548848196049226189e-01 -1.920971714161890664e-01 2.335259123582915652e-01 6.785807411971255254e-01 -1.696498672079299608e-01 -3.452017652059587438e-01 -3.024401025659949060e-01 4.536047842883256243e-01 4.010374890039821727e-01 -8.433065523960087129e-03 -6.244357781547918984e-01 6.259293327980892663e-01 -7.916652727169092296e-01 3.819701602781246375e-01 2.552160035168020702e-01 -1.273750857198618566e-02 1.441172739380510437e-01 3.787821797230896403e-01 -3.183945732558903230e-01 4.387568287051107352e-01 -3.083591364377761754e-02 3.198718133749162140e-01 -2.163379593679770063e-01 5.789032204966299000e-01 -7.446914895917968735e-01 3.242680555507073681e-01 -2.696724687440039125e-01 3.890619108363070344e-01 3.069687027129113233e-01 2.349280550431498971e-01 1.442267512329689361e-01 -2.390410990095094557e-01 -1.929082292040729396e-01 3.996107260614470968e-01 1.987028421151131319e-01 4.128418238155596165e-01 -9.564298950756719431e-02 -2.592940101782901380e-02 4.059441068602547831e-01 1.405876611736418536e-01 2.286785880912713467e-02 -2.645298209643285325e-01 4.444951018010919741e-01 6.380659706840001444e-02 2.509567183647826161e-01 -2.608887199434208326e-01 -6.835831962831143138e-02 -1.132918007532046079e-01 1.691545757534531139e-02 -3.638264840556743596e-01 1.845367866454253325e-01 -4.648815502078343376e-01 -1.480312903772801614e-01 2.380764051620425925e-01 4.329374009429694525e-01 1.137713744385921155e-01 -8.495846425568480409e-02 3.574117418439419214e-01 4.853087785472404159e-01 -2.058132932405922766e-01 -1.097377035111868487e-01 2.112683219664100165e-01 -1.415210164887464039e-01 -4.566393887190637324e-01 -1.465887260763238942e-01 -1.447414713443698209e-02 -4.508362076401979945e-01 4.099336344909473850e-01 2.313967863904788924e-01 2.728397841439033078e-01 -3.999136805320314125e-01 -4.597682313413500865e-01 -2.401873745593388065e-01 -2.367071621781187962e-01')
    got_hw1 = False
    hidden_weight_req2 = tokens('4.431072015689671018e-01 4.659889419628599483e-01 -1.146921693390339503e-01 -1.150614686646848905e-01 -1.800000356954413461e-01 -2.262156574263862185e-01 -1.149482039495504232e-01 -3.776404372943437671e-01 -2.843454722739187090e-01 -4.105261796881009007e-01 1.238447496298579475e-01 -4.378466135181576235e-01 2.244853440724961791e-01 1.737433516117691257e-01 -2.611099225825992964e-01 1.650556502854581276e-01 -9.232743242981295007e-02 1.414786903698167786e-01 -3.741139140872397628e-01 -4.895742697268916366e-02 -1.766744726403944310e-01 5.760174247559997074e-01 -3.758450526287130944e-01 2.232573990588951340e-01 9.752682040688921347e-03 4.957332719019528211e-01 1.995277489330417875e-01 -4.229372831924161358e-01 -6.077717421097795780e-01 4.880882415056226331e-01 1.115496021731232079e-01 -5.052193173862313813e-01 2.700645161267958838e-01 1.426735141496363879e-01 8.024848834026679922e-01 6.355501101725924418e-01 2.688193690050340590e-01 -3.126463717095773198e-01 -4.784795953058664231e-01 -8.072749220574325646e-01 -9.150567836758938256e-02 1.984958839290551225e-01 -2.199722925864488199e-01 1.465787382352884416e-01 -1.855024837022921369e-01 -6.300463168535504199e-02 -2.284961268287997171e-01 1.327905122969967600e-01 4.658873839295207819e-01 1.426879983769561433e-01 -8.840197722806040215e-01 -3.506816733200383562e-01 3.230365549795641833e-01 -1.718987755454714494e-01 2.207200823953313629e-01 9.902074247985484523e-02 1.565657480666090284e-01 9.356353393407257357e-02 2.364014948902922186e-01 2.018955028447755318e-01 -3.400191242646865009e-01 2.720129983438980895e-02 -7.739003135450084336e-01 1.467213546404459446e-01 3.584880431234424569e-01 4.029807962829264345e-01 -2.928115931930612703e-01 -2.495127780852022525e-01 -2.520187056706832962e-01 -6.023500502179422039e-02 1.817084153525004020e-01 -1.651904097629501300e-01 -2.041514459071051557e-01 9.112731303390321225e-01 -1.974931415373384347e-01 3.957743711024673261e-01 -4.433020075184589820e-02 5.471023826574648030e-01 3.533450643599590490e-01 3.464672208967857214e-01 -5.334198554031620576e-01 -3.059884920705895350e-01 5.953344476057940288e-02 2.107859538156430512e-01 2.743366703549761088e-01 4.500499777449785133e-01 1.426413328631827293e-01 -3.039340573781524890e-01 1.902351702457895644e-01 5.023400587768478420e-01 4.066168404542251924e-01 3.641944980649106656e-01 -4.553024710928050278e-01 -4.851569416423358039e-01 2.424508805266572531e-01 2.350612498932761751e-01 2.102663803831680278e-01 -3.556933545498744964e-01 -3.739642915547247148e-01 -3.263351613186524780e-01 3.241228305148187161e-01 -8.682534849125855825e-02 -1.804624983825512674e-01 1.364905788551507015e-01 -4.614204789763867720e-01 -4.056829548944650421e-01 -3.769204892584459565e-01 1.936241522672201287e-01 1.115822280436448710e-01 7.286045294968454544e-02 3.248043095242392764e-01 2.576998841127695616e-01 -2.720926513596871876e-01 -4.002847392679260707e-01 7.198571960912640219e-03 -1.877936549322946902e-01 -2.300752695092667388e-01 5.499451570770040425e-03 2.088108936643675306e-01 4.081973337619952402e-01 -4.123627553082329783e-02 3.468483335054005356e-02 3.088151916771204597e-01 -3.088117689658896256e-02')
    got_hw2 = False
    output_weight_req = tokens('Output layer weights: -2.557813972786002754e+00 -2.485081223875609258e+00 1.017898608589761000e+00')
    got_ow = False
    for line in output.split('\n'):
        if fuzzy_match(line, acc_req):
            print('Test accuracy is correct!')
            got_acc = True
        elif fuzzy_match(line, hidden_weight_req1):
            print('Hidden weights, first line is correct!')
            got_hw1 = True
        elif fuzzy_match(line, hidden_weight_req2):
            print('Hidden weights, second line is correct!')
            got_hw2 = True
        elif fuzzy_match(line, output_weight_req):
            print('Output weights are correct!')
            got_ow = True
    if not (got_acc and got_hw1 and got_hw2 and got_ow):
        err('Unable to find one or more required output lines. Make sure each is on its own line and formatted correctly; if so, then there is an implementation problem. This should have produced (with all numbers matched to 6 significant figures):\n{}\n{}\n{}\n{}\n\n'.format(' '.join(map(str,acc_req)),' '.join(map(str,hidden_weight_req1)),' '.join(map(str,hidden_weight_req2)),' '.join(map(str,output_weight_req))))

def main():
    filenames = find_filenames()
    if len(filenames) == 0:
        err('No files ending in \'_backprop.py\' found. Make sure your file is named LastName_backprop.py.')
    if len(filenames) > 1:
        err('Only include a single file ending in \'_backprop.py\' in the submission directory.')
    print('Found Python file to run.')
    if not os.path.exists(DATA_DIR):
        err('Could not find the data directory; looked for {}. Change the DATA_DIR variable at the top of this smoke test file to wherever you have downloaded the data (a7a.*).'.format(DATA_DIR))
    print('Found data directory.')
    output = get_output(filenames[0])
    print('Ran Python file.')
    verify_output(output)
    print('Congratulations, you passed this simple test! However, make sure that your code runs on the csug server. Also, don\'t forget your README!')

if __name__ == '__main__':
    main()
