/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.ling;

import edu.berkeley.nlp.ling.HeadFinder;
import edu.berkeley.nlp.ling.Tree;
import edu.berkeley.nlp.ling.TreebankLanguagePack;
import edu.berkeley.nlp.ling.Trees;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollinsHeadFinder
implements HeadFinder,
Serializable {
    private static final boolean DEBUG = false;
    protected final TreebankLanguagePack tlp;
    protected HashMap nonTerminalInfo;
    protected String[] defaultRule = null;
    private static final long serialVersionUID = -6540278059442931087L;

    protected AbstractCollinsHeadFinder(TreebankLanguagePack tlp) {
        this.tlp = tlp;
    }

    protected Tree<String> findMarkedHead(Tree<String> t) {
        return null;
    }

    @Override
    public Tree<String> determineHead(Tree<String> t) {
        if (this.nonTerminalInfo == null) {
            throw new RuntimeException("Classes derived from AbstractCollinsHeadFinder must create and fill HashMap nonTerminalInfo.");
        }
        if (t.isLeaf()) {
            return null;
        }
        List<Tree<String>> kids = t.getChildren();
        Tree<String> theHead = this.findMarkedHead(t);
        if (theHead != null) {
            return theHead;
        }
        if (kids.size() == 1) {
            return kids.get(0);
        }
        return this.determineNonTrivialHead(t);
    }

    protected Tree<String> determineNonTrivialHead(Tree<String> t) {
        Tree<String> theHead = null;
        String motherCat = Trees.FunctionNodeStripper.transformLabel(t);
        String[][] how = (String[][])this.nonTerminalInfo.get(motherCat);
        if (how == null) {
            if (this.defaultRule != null) {
                return this.traverseLocate(t.getChildren(), this.defaultRule, true);
            }
            return null;
        }
        for (int i = 0; i < how.length; ++i) {
            boolean deflt = i == how.length - 1;
            theHead = this.traverseLocate(t.getChildren(), how[i], deflt);
            if (theHead != null) break;
        }
        return theHead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Tree<String> traverseLocate(List<Tree<String>> daughterTrees, String[] how, boolean deflt) {
        int headIdx = 0;
        boolean found = false;
        if (how[0].equals("left")) {
            block0: for (int i = 1; i < how.length; ++i) {
                for (headIdx = 0; headIdx < daughterTrees.size(); ++headIdx) {
                    String childCat = Trees.FunctionNodeStripper.transformLabel(daughterTrees.get(headIdx));
                    if (!how[i].equals(childCat)) continue;
                    found = true;
                    break block0;
                }
            }
            if (!found) {
                if (!deflt) return null;
                headIdx = 0;
            }
        } else if (how[0].equals("leftdis")) {
            block2: for (headIdx = 0; headIdx < daughterTrees.size(); ++headIdx) {
                String childCat = Trees.FunctionNodeStripper.transformLabel(daughterTrees.get(headIdx));
                for (int i = 1; i < how.length; ++i) {
                    if (!how[i].equals(childCat)) continue;
                    found = true;
                    break block2;
                }
            }
            if (!found) {
                if (!deflt) return null;
                headIdx = 0;
            }
        } else if (how[0].equals("right")) {
            block4: for (int i = 1; i < how.length; ++i) {
                for (headIdx = daughterTrees.size() - 1; headIdx >= 0; --headIdx) {
                    String childCat = Trees.FunctionNodeStripper.transformLabel(daughterTrees.get(headIdx));
                    if (!how[i].equals(childCat)) continue;
                    found = true;
                    break block4;
                }
            }
            if (!found) {
                if (!deflt) return null;
                headIdx = daughterTrees.size() - 1;
            }
        } else {
            if (!how[0].equals("rightdis")) throw new RuntimeException("ERROR: invalid direction type to nonTerminalInfo map in AbstractCollinsHeadFinder.");
            block6: for (headIdx = daughterTrees.size() - 1; headIdx >= 0; --headIdx) {
                String childCat = Trees.FunctionNodeStripper.transformLabel(daughterTrees.get(headIdx));
                for (int i = 1; i < how.length; ++i) {
                    if (!how[i].equals(childCat)) continue;
                    found = true;
                    break block6;
                }
            }
            if (!found) {
                if (!deflt) return null;
                headIdx = daughterTrees.size() - 1;
            }
        }
        headIdx = this.postOperationFix(headIdx, daughterTrees);
        return daughterTrees.get(headIdx);
    }

    protected int postOperationFix(int headIdx, List<Tree<String>> daughterTrees) {
        return headIdx;
    }
}

