/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.ling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    L label;
    boolean isIntermediateNode;
    List<Tree<L>> children;

    public boolean isIntermediateNode() {
        return this.isIntermediateNode;
    }

    public void setChildren(List<Tree<L>> c) {
        this.children = c;
    }

    public List<Tree<L>> getChildren() {
        return this.children;
    }

    public L getLabel() {
        return this.label;
    }

    public L getLabelNoSpan() {
        return this.removeSpanLabel(this.label);
    }

    private L removeSpanLabel(L label) {
        String lab;
        int index;
        if (label instanceof String && (index = (lab = (String)label).lastIndexOf("[span")) != -1) {
            return (L)lab.substring(0, index);
        }
        return label;
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public boolean isPreTerminal() {
        return this.getChildren().size() == 1 && this.getChildren().get(0).isLeaf();
    }

    public List<L> getYield() {
        ArrayList yield = new ArrayList();
        Tree.appendYield(this, yield);
        return yield;
    }

    public List<Tree<L>> getTerminals() {
        ArrayList<Tree<L>> yield = new ArrayList<Tree<L>>();
        Tree.appendTerminals(this, yield);
        return yield;
    }

    private static <L> void appendTerminals(Tree<L> tree, List<Tree<L>> yield) {
        if (tree.isLeaf()) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendTerminals(child, yield);
        }
    }

    public Tree<L> shallowClone() {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        for (Tree<L> child : this.children) {
            newChildren.add(child.shallowClone());
        }
        return new Tree<L>(this.label, this.isIntermediateNode, newChildren);
    }

    private static <L> void appendYield(Tree<L> tree, List<L> yield) {
        if (tree.isLeaf()) {
            yield.add(tree.getLabel());
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendYield(child, yield);
        }
    }

    public List<L> getPreTerminalYield() {
        ArrayList yield = new ArrayList();
        Tree.appendPreTerminalYield(this, yield);
        return yield;
    }

    private static <L> void appendPreTerminalYield(Tree<L> tree, List<L> yield) {
        if (tree.isPreTerminal()) {
            yield.add(tree.getLabel());
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendPreTerminalYield(child, yield);
        }
    }

    public int getDepth() {
        int maxDepth = 0;
        for (Tree<L> child : this.children) {
            int depth = child.getDepth();
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth + 1;
    }

    public List<Tree<L>> getAtDepth(int depth) {
        ArrayList<Tree<L>> yield = new ArrayList<Tree<L>>();
        Tree.appendAtDepth(depth, this, yield);
        return yield;
    }

    private static <L> void appendAtDepth(int depth, Tree<L> tree, List<Tree<L>> yield) {
        if (depth < 0) {
            return;
        }
        if (depth == 0) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendAtDepth(depth - 1, child, yield);
        }
    }

    public void setLabel(L label) {
        this.label = label;
    }

    public String toSurfaceString() {
        StringBuilder sb = new StringBuilder();
        for (Tree<L> t : this.getTerminals()) {
            sb.append(t).append(" ");
        }
        return sb.toString().trim();
    }

    public String toSurfaceString(String delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Tree<L> t : this.getTerminals()) {
            sb.append(t).append(delimiter);
        }
        return sb.deleteCharAt(sb.lastIndexOf(delimiter)).toString().trim();
    }

    public String toSurfaceStringLowerCase() {
        StringBuilder sb = new StringBuilder();
        for (Tree<L> t : this.getTerminals()) {
            sb.append(t).append(" ");
        }
        return sb.toString().toLowerCase().trim();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public void toStringBuilder(StringBuilder sb) {
        if (!this.isLeaf()) {
            sb.append('(');
        }
        if (this.getLabel() != null) {
            sb.append(this.getLabel());
        }
        if (!this.isLeaf()) {
            for (Tree<L> child : this.getChildren()) {
                sb.append(' ');
                child.toStringBuilder(sb);
            }
            sb.append(')');
        }
    }

    public Tree(L label, boolean isIntermediateNode, List<Tree<L>> children) {
        this.label = label;
        this.isIntermediateNode = isIntermediateNode;
        this.children = children;
    }

    public Tree(L label, boolean isIntermediateNode) {
        this.label = label;
        this.isIntermediateNode = isIntermediateNode;
        this.children = Collections.emptyList();
    }

    public Set<Tree<L>> subTrees() {
        return (Set)this.subTrees(new HashSet<Tree<L>>());
    }

    public List<Tree<L>> subTreeList() {
        return (List)this.subTrees(new ArrayList<Tree<L>>());
    }

    public Collection<Tree<L>> subTrees(Collection<Tree<L>> n) {
        n.add(this);
        List<Tree<L>> kids = this.getChildren();
        for (Tree<L> kid : kids) {
            kid.subTrees(n);
        }
        return n;
    }

    public Iterator iterator() {
        return new TreeIterator();
    }

    public boolean hasUnaryChain() {
        return this.hasUnaryChainHelper(this, false);
    }

    private boolean hasUnaryChainHelper(Tree<L> tree, boolean unaryAbove) {
        boolean result = false;
        if (tree.getChildren().size() == 1) {
            if (unaryAbove) {
                return true;
            }
            if (tree.getChildren().get(0).isPreTerminal()) {
                return false;
            }
            return this.hasUnaryChainHelper(tree.getChildren().get(0), true);
        }
        for (Tree<L> child : tree.getChildren()) {
            if (child.isPreTerminal()) continue;
            result = result || this.hasUnaryChainHelper(child, false);
        }
        return result;
    }

    private class TreeIterator
    implements Iterator {
        private List<Tree<L>> treeStack = new ArrayList();

        private TreeIterator() {
            this.treeStack.add(Tree.this);
        }

        public boolean hasNext() {
            return !this.treeStack.isEmpty();
        }

        public Object next() {
            int lastIndex = this.treeStack.size() - 1;
            Tree tr = this.treeStack.remove(lastIndex);
            List kids = tr.getChildren();
            for (int i = kids.size() - 1; i >= 0; --i) {
                this.treeStack.add(kids.get(i));
            }
            return tr;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

