/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.ling;

import edu.berkeley.nlp.ling.Tree;
import edu.berkeley.nlp.util.Filter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trees {
    public static void main(String[] args) throws Exception {
        InputStreamReader stdin = new InputStreamReader(System.in, "UTF-8");
        PennTreeReader reader = new PennTreeReader(stdin);
        while (reader.hasNext()) {
            Object tree = reader.next();
            System.out.println(PennTreeRenderer.render(tree));
        }
    }

    public static <L> Tree<L> spliceNodes(Tree<L> tree, Filter<L> filter) {
        List<Tree<L>> rootList = Trees.spliceNodesHelper(tree, filter);
        if (rootList.size() > 1) {
            throw new IllegalArgumentException("spliceNodes: no unique root after splicing");
        }
        if (rootList.size() < 1) {
            return null;
        }
        return rootList.get(0);
    }

    private static <L> List<Tree<L>> spliceNodesHelper(Tree<L> tree, Filter<L> filter) {
        if (tree.isLeaf()) {
            return Collections.singletonList(new Tree<L>(tree.getLabel(), tree.isIntermediateNode()));
        }
        ArrayList<Tree<L>> splicedChildren = new ArrayList<Tree<L>>();
        for (Tree<L> child : tree.getChildren()) {
            List<Tree<L>> splicedChildList = Trees.spliceNodesHelper(child, filter);
            splicedChildren.addAll(splicedChildList);
        }
        if (filter.accept(tree.getLabel())) {
            return splicedChildren;
        }
        return Collections.singletonList(new Tree<L>(tree.getLabel(), tree.isIntermediateNode(), splicedChildren));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PennTreeRenderer {
        public static <L> String render(Tree<L> tree) {
            StringBuilder sb = new StringBuilder();
            PennTreeRenderer.renderTree(tree, 0, false, false, false, true, sb);
            sb.append('\n');
            return sb.toString();
        }

        private static <L> void renderTree(Tree<L> tree, int indent, boolean parentLabelNull, boolean firstSibling, boolean leftSiblingPreTerminal, boolean topLevel, StringBuilder sb) {
            boolean suppressIndent;
            boolean bl = suppressIndent = parentLabelNull || firstSibling && tree.isPreTerminal() || leftSiblingPreTerminal && tree.isPreTerminal() && (tree.getLabel() == null || !tree.getLabel().toString().startsWith("CC"));
            if (suppressIndent) {
                sb.append(' ');
            } else {
                if (!topLevel) {
                    sb.append('\n');
                }
                for (int i = 0; i < indent; ++i) {
                    sb.append("  ");
                }
            }
            if (tree.isLeaf() || tree.isPreTerminal()) {
                PennTreeRenderer.renderFlat(tree, sb);
                return;
            }
            sb.append('(');
            if (tree.isIntermediateNode()) {
                sb.append("[").append(tree.getLabel()).append("]");
            } else {
                sb.append(tree.getLabel());
            }
            PennTreeRenderer.renderChildren(tree.getChildren(), indent + 1, tree.getLabel() == null || tree.getLabel().toString() == null, sb);
            sb.append(')');
        }

        private static <L> void renderFlat(Tree<L> tree, StringBuilder sb) {
            if (tree.isLeaf()) {
                sb.append(tree.getLabel().toString());
                return;
            }
            sb.append('(');
            if (tree.getLabel() == null) {
                sb.append("<null>");
            } else {
                sb.append(tree.getLabel().toString());
            }
            sb.append(' ');
            sb.append(tree.getChildren().get(0).getLabel().toString());
            sb.append(')');
        }

        private static <L> void renderChildren(List<Tree<L>> children, int indent, boolean parentLabelNull, StringBuilder sb) {
            boolean firstSibling = true;
            boolean leftSibIsPreTerm = true;
            for (Tree<L> child : children) {
                PennTreeRenderer.renderTree(child, indent, parentLabelNull, firstSibling, leftSibIsPreTerm, false, sb);
                leftSibIsPreTerm = child.isPreTerminal();
                if (child.getLabel() != null && child.getLabel().toString().startsWith("CC")) {
                    leftSibIsPreTerm = false;
                }
                firstSibling = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PennTreeReader
    implements Iterator<Tree<String>> {
        public static String ROOT_LABEL = "ROOT";
        PushbackReader in;
        Tree<String> nextTree;

        @Override
        public boolean hasNext() {
            return this.nextTree != null;
        }

        @Override
        public Tree<String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tree<String> tree = this.nextTree;
            this.nextTree = this.readRootTree();
            return tree;
        }

        private Tree<String> readRootTree() {
            try {
                this.readWhiteSpace();
                if (!this.isLeftParen(this.peek())) {
                    return null;
                }
                return this.readTree(true);
            }
            catch (IOException e) {
                throw new RuntimeException("Error reading tree.");
            }
        }

        private Tree<String> readTree(boolean isRoot) throws IOException {
            this.readLeftParen();
            String label = this.readLabel();
            if (label.length() == 0 && isRoot) {
                label = ROOT_LABEL;
            }
            List children = this.readChildren();
            this.readRightParen();
            return new Tree<String>(label, false, children);
        }

        private String readLabel() throws IOException {
            this.readWhiteSpace();
            return this.readText();
        }

        private String readText() throws IOException {
            StringBuilder sb = new StringBuilder();
            int ch = this.in.read();
            while (!(this.isWhiteSpace(ch) || this.isLeftParen(ch) || this.isRightParen(ch))) {
                sb.append((char)ch);
                ch = this.in.read();
            }
            this.in.unread(ch);
            return sb.toString().intern();
        }

        private List<Tree<String>> readChildren() throws IOException {
            this.readWhiteSpace();
            if (!this.isLeftParen(this.peek())) {
                return Collections.singletonList(this.readLeaf());
            }
            return this.readChildList();
        }

        private int peek() throws IOException {
            int ch = this.in.read();
            this.in.unread(ch);
            return ch;
        }

        private Tree<String> readLeaf() throws IOException {
            String label = this.readText();
            return new Tree<String>(label, false);
        }

        private List<Tree<String>> readChildList() throws IOException {
            ArrayList<Tree<String>> children = new ArrayList<Tree<String>>();
            this.readWhiteSpace();
            while (!this.isRightParen(this.peek())) {
                children.add(this.readTree(false));
                this.readWhiteSpace();
            }
            return children;
        }

        private void readLeftParen() throws IOException {
            this.readWhiteSpace();
            int ch = this.in.read();
            if (!this.isLeftParen(ch)) {
                throw new RuntimeException("Format error reading tree. (leftParen)");
            }
        }

        private void readRightParen() throws IOException {
            this.readWhiteSpace();
            int ch = this.in.read();
            if (!this.isRightParen(ch)) {
                System.out.println((char)ch);
                throw new RuntimeException("Format error reading tree. (rightParen)");
            }
        }

        private void readWhiteSpace() throws IOException {
            int c;
            while (true) {
                int lastc;
                c = 0;
                do {
                    lastc = c;
                } while (this.isWhiteSpace(c = this.in.read()));
                if (c != 35 || lastc != 10) break;
                while ((c = this.in.read()) != -1 && c != 10) {
                }
            }
            this.in.unread(c);
        }

        private boolean isWhiteSpace(int ch) {
            return ch == 32 || ch == 9 || ch == 12 || ch == 13 || ch == 10;
        }

        private boolean isLeftParen(int ch) {
            return ch == 40;
        }

        private boolean isRightParen(int ch) {
            return ch == 41;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public PennTreeReader(Reader in) {
            this.in = new PushbackReader(in);
            this.nextTree = this.readRootTree();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardTreeNormalizer
    implements TreeTransformer<String> {
        EmptyNodeStripper emptyNodeStripper = new EmptyNodeStripper();
        XOverXRemover<String> xOverXRemover = new XOverXRemover();
        FunctionNodeStripper functionNodeStripper = new FunctionNodeStripper();

        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            tree = this.functionNodeStripper.transformTree(tree);
            tree = this.emptyNodeStripper.transformTree(tree);
            tree = this.xOverXRemover.transformTree(tree);
            return tree;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XOverXRemover<E>
    implements TreeTransformer<E> {
        @Override
        public Tree<E> transformTree(Tree<E> tree) {
            E label = tree.getLabel();
            List<Tree<E>> children = tree.getChildren();
            while (children.size() == 1 && !children.get(0).isLeaf() && label.equals(children.get(0).getLabel())) {
                children = children.get(0).getChildren();
            }
            ArrayList transformedChildren = new ArrayList();
            for (Tree<E> child : children) {
                transformedChildren.add(this.transformTree(child));
            }
            return new Tree<E>(label, tree.isIntermediateNode(), transformedChildren);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmptyNodeStripper
    implements TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            String label = tree.getLabel();
            if (label.equals("-NONE-") || label.equals("-none-")) {
                return null;
            }
            if (tree.isLeaf()) {
                return new Tree<String>(label, tree.isIntermediateNode());
            }
            List<Tree<String>> children = tree.getChildren();
            ArrayList transformedChildren = new ArrayList();
            for (Tree<String> child : children) {
                Tree<String> transformedChild = this.transformTree(child);
                if (transformedChild == null) continue;
                transformedChildren.add(transformedChild);
            }
            if (transformedChildren.isEmpty()) {
                return null;
            }
            return new Tree<String>(label, tree.isIntermediateNode(), transformedChildren);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionNodeStripper
    implements TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            String transformedLabel = FunctionNodeStripper.transformLabel(tree);
            if (tree.isLeaf()) {
                return new Tree<String>(transformedLabel, tree.isIntermediateNode());
            }
            ArrayList transformedChildren = new ArrayList();
            for (Tree<String> child : tree.getChildren()) {
                transformedChildren.add(this.transformTree(child));
            }
            return new Tree<String>(transformedLabel, tree.isIntermediateNode(), transformedChildren);
        }

        public static String transformLabel(Tree<String> tree) {
            String transformedLabel = tree.getLabel();
            int cutIndex = transformedLabel.indexOf(45);
            int cutIndex2 = transformedLabel.indexOf(61);
            int cutIndex3 = transformedLabel.indexOf(94);
            if (cutIndex3 > 0 && (cutIndex3 < cutIndex2 || cutIndex2 == -1)) {
                cutIndex2 = cutIndex3;
            }
            if (cutIndex2 > 0 && (cutIndex2 < cutIndex || cutIndex == -1)) {
                cutIndex = cutIndex2;
            }
            if (cutIndex > 0 && !tree.isLeaf()) {
                transformedLabel = new String(transformedLabel.substring(0, cutIndex));
            }
            return transformedLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TreeTransformer<E> {
        public Tree<E> transformTree(Tree<E> var1);
    }
}

