/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import edu.berkeley.nlp.mt.SentencePair;
import edu.berkeley.nlp.syntax.Tree;
import fig.basic.MapUtils;
import fig.basic.Pair;
import fig.basic.StrUtils;
import fig.basic.String2DoubleMap;
import fig.basic.StringDoubleMap;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment
implements Serializable {
    private static final long serialVersionUID = 1L;
    Set<Pair<Integer, Integer>> sureAlignments;
    Set<Pair<Integer, Integer>> possibleAlignments;
    private List<List<Integer>> foreignAlignments;
    private List<List<Integer>> englishAlignments;
    Map<Pair<Integer, Integer>, Double> strengths;
    private List<String> englishSentence;
    private List<String> foreignSentence;
    private Tree<String> englishTree;
    private Tree<String> foreignTree;
    private List<AlignmentNode> englishNodes;
    private List<AlignmentNode> foreignNodes;
    private IdentityHashMap<Tree<String>, Integer> englishPositions;
    private IdentityHashMap<Tree<String>, Integer> foreignPositions;
    private IdentityHashMap<Tree<String>, Pair<Integer, Integer>> englishBounds;
    private IdentityHashMap<Tree<String>, Pair<Integer, Integer>> foreignBounds;

    public Alignment(List<String> englishSentence, List<String> foreignSentence, Tree<String> englishTree, Tree<String> foreignTree) {
        this.englishSentence = englishSentence;
        this.foreignSentence = foreignSentence;
        this.sureAlignments = new HashSet<Pair<Integer, Integer>>();
        this.possibleAlignments = new HashSet<Pair<Integer, Integer>>();
        this.strengths = new HashMap<Pair<Integer, Integer>, Double>();
        this.setTrees(englishTree, foreignTree);
        this.englishPositions = this.constructPositionMap(englishTree);
        this.foreignPositions = this.constructPositionMap(foreignTree);
        this.englishBounds = this.constructBoundsMap(englishTree, this.englishPositions);
        this.foreignBounds = this.constructBoundsMap(foreignTree, this.foreignPositions);
    }

    private IdentityHashMap<Tree<String>, Integer> constructPositionMap(Tree<String> tree) {
        if (tree == null) {
            return null;
        }
        IdentityHashMap<Tree<String>, Integer> map = new IdentityHashMap<Tree<String>, Integer>();
        int pos = 0;
        for (Tree<String> preTerminal : tree.getPreTerminals()) {
            map.put(preTerminal, pos++);
        }
        for (Tree<String> node : tree.getPreOrderTraversal()) {
            if (node.isPreTerminal() || node.isLeaf()) continue;
            map.put(node, pos++);
        }
        return map;
    }

    private IdentityHashMap<Tree<String>, Pair<Integer, Integer>> constructBoundsMap(Tree<String> tree, IdentityHashMap<Tree<String>, Integer> positionMap) {
        if (tree == null) {
            return null;
        }
        IdentityHashMap<Tree<String>, Pair<Integer, Integer>> map = new IdentityHashMap<Tree<String>, Pair<Integer, Integer>>();
        for (Tree<String> node : tree.getPreOrderTraversal()) {
            if (node.isLeaf()) continue;
            List<Tree<String>> preterminals = node.getPreTerminals();
            int min = positionMap.get(preterminals.get(0));
            int max = positionMap.get(preterminals.get(preterminals.size() - 1));
            map.put(node, Pair.makePair(min, max));
        }
        return map;
    }

    public void setTrees(Tree<String> englishTree, Tree<String> foreignTree) {
        this.englishTree = englishTree;
        this.foreignTree = foreignTree;
        this.englishNodes = this.constructAlignmentNodes(this.englishSentence, englishTree);
        this.foreignNodes = this.constructAlignmentNodes(this.foreignSentence, foreignTree);
    }

    public Alignment(List<String> englishSentence, List<String> foreignSentence) {
        this(englishSentence, foreignSentence, null, null);
    }

    public Alignment(SentencePair pair) {
        this(pair.getEnglishWords(), pair.getForeignWords(), pair.getEnglishTree(), pair.getForeignTree());
    }

    public Alignment(Alignment al) {
        this(al.englishSentence, al.foreignSentence, al.englishTree, al.foreignTree);
    }

    private List<AlignmentNode> constructAlignmentNodes(List<String> sentence, Tree<String> tree) {
        ArrayList<AlignmentNode> nodes = new ArrayList<AlignmentNode>();
        for (String word : sentence) {
            nodes.add(new AlignmentNode(word));
        }
        int preTerminalIndex = 0;
        if (tree != null) {
            for (Tree<String> internalNode : tree.getPreOrderTraversal()) {
                if (!internalNode.isPreTerminal() && !internalNode.isLeaf()) {
                    nodes.add(new AlignmentNode(internalNode));
                }
                if (!internalNode.isPreTerminal()) continue;
                ((AlignmentNode)nodes.get((int)preTerminalIndex++)).internalNode = internalNode;
            }
        }
        return nodes;
    }

    public static List<Tree<String>> getOrderedNodeList(Tree<String> tree) {
        ArrayList<Tree<String>> nodes = new ArrayList<Tree<String>>();
        for (Tree<String> preTerminal : tree.getPreTerminals()) {
            nodes.add(preTerminal);
        }
        for (Tree<String> node : tree.getPreOrderTraversal()) {
            if (node.isPreTerminal() || node.isLeaf()) continue;
            nodes.add(node);
        }
        return nodes;
    }

    public int getEnglishLength() {
        return this.englishNodes.size();
    }

    public List<String> getEnglishSentence() {
        return this.englishSentence;
    }

    public Tree<String> getEnglishTree() {
        return this.englishTree;
    }

    public List<AlignmentNode> getEnglishNodes() {
        return this.englishNodes;
    }

    public int getEnglishPosition(Tree<String> englishTreeNode) {
        return this.englishPositions.get(englishTreeNode);
    }

    public Pair<Integer, Integer> getEnglishBounds(Tree<String> englishTreeNode) {
        return this.englishBounds.get(englishTreeNode);
    }

    public int getEnglishSpanLength(Tree<String> englishTreeNode) {
        Pair<Integer, Integer> bounds = this.englishBounds.get(englishTreeNode);
        return bounds.getSecond() - bounds.getFirst() + 1;
    }

    public int getEnglishSpanLength(int index) {
        return this.getEnglishSpanLength(this.englishNodes.get(index).getTreeNode());
    }

    public int getForeignLength() {
        return this.foreignNodes.size();
    }

    public List<String> getForeignSentence() {
        return this.foreignSentence;
    }

    public Tree<String> getForeignTree() {
        return this.foreignTree;
    }

    public List<AlignmentNode> getForeignNodes() {
        return this.foreignNodes;
    }

    public int getForeignPosition(Tree<String> foreignTreeNode) {
        return this.foreignPositions.get(foreignTreeNode);
    }

    public Pair<Integer, Integer> getForeignBounds(Tree<String> foreignTreeNode) {
        return this.foreignBounds.get(foreignTreeNode);
    }

    public int getForeignSpanLength(Tree<String> foreignTreeNode) {
        Pair<Integer, Integer> bounds = this.foreignBounds.get(foreignTreeNode);
        return bounds.getSecond() - bounds.getFirst() + 1;
    }

    public int getForeignSpanLength(int index) {
        return this.getForeignSpanLength(this.foreignNodes.get(index).getTreeNode());
    }

    public Set<Pair<Integer, Integer>> getPossibleAlignments() {
        return this.possibleAlignments;
    }

    public Set<Pair<Integer, Integer>> getSureAlignments() {
        return this.sureAlignments;
    }

    public Map<Pair<Integer, Integer>, Double> getStrengths() {
        return this.strengths;
    }

    public boolean containsSureAlignment(int englishPosition, int foreignPosition) {
        return this.sureAlignments.contains(new Pair<Integer, Integer>(englishPosition, foreignPosition));
    }

    public boolean containsPossibleAlignment(int englishPosition, int foreignPosition) {
        return this.possibleAlignments.contains(new Pair<Integer, Integer>(englishPosition, foreignPosition));
    }

    public boolean containsEnglishParentAlignment(int englishPosition, int foreignPosition) {
        Tree<String> englishNode = this.englishNodes.get((int)englishPosition).internalNode;
        for (int i = this.englishSentence.size(); i < this.englishNodes.size(); ++i) {
            if (!this.sureAlignments.contains(new Pair<Integer, Integer>(i, foreignPosition))) continue;
            assert (!this.englishNodes.get((int)i).isWord);
            Tree<String> root = this.englishNodes.get((int)i).internalNode;
            for (Tree<String> node : root.getPreOrderTraversal()) {
                if (node != englishNode) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsForeignParentAlignment(int englishPosition, int foreignPosition) {
        Tree<String> foreignNode = this.foreignNodes.get((int)foreignPosition).internalNode;
        for (int j = this.foreignSentence.size(); j < this.foreignNodes.size(); ++j) {
            if (!this.sureAlignments.contains(new Pair<Integer, Integer>(englishPosition, j))) continue;
            assert (!this.foreignNodes.get((int)j).isWord);
            Tree<String> root = this.foreignNodes.get((int)j).internalNode;
            for (Tree<String> node : root.getPreOrderTraversal()) {
                if (node != foreignNode) continue;
                return true;
            }
        }
        return false;
    }

    public double getStrength(int i, int j) {
        return MapUtils.get(this.strengths, new Pair<Integer, Integer>(i, j), 0.0);
    }

    public double[][] getPosteriors(int I, int J) {
        double[][] posteriors = new double[J][I];
        for (int j = 0; j < J; ++j) {
            for (int i = 0; i < I; ++i) {
                posteriors[j][i] = this.getStrength(i, j);
            }
        }
        return posteriors;
    }

    public double[][] getPosteriors() {
        int I = this.getEnglishLength();
        int J = this.getForeignLength();
        double[][] posteriors = new double[J][I];
        for (int j = 0; j < J; ++j) {
            for (int i = 0; i < I; ++i) {
                posteriors[j][i] = this.getStrength(i, j);
            }
        }
        return posteriors;
    }

    public List<Integer> getAlignmentsToEnglish(int englishPos) {
        if (this.englishAlignments == null) {
            this.gatherAlignmentArrays();
        }
        if (englishPos >= 0 && englishPos < this.englishAlignments.size()) {
            return this.englishAlignments.get(englishPos);
        }
        return new ArrayList<Integer>();
    }

    public List<Integer> getAlignmentsToForeign(int sourcepos) {
        if (this.englishAlignments == null) {
            this.gatherAlignmentArrays();
        }
        return this.foreignAlignments.get(sourcepos);
    }

    private void gatherAlignmentArrays() {
        int i;
        this.foreignAlignments = new ArrayList<List<Integer>>(this.foreignNodes.size());
        for (i = 0; i < this.foreignNodes.size(); ++i) {
            this.foreignAlignments.add(new ArrayList());
        }
        this.englishAlignments = new ArrayList<List<Integer>>(this.englishNodes.size());
        for (i = 0; i < this.englishNodes.size(); ++i) {
            this.englishAlignments.add(new ArrayList());
        }
        for (Pair<Integer, Integer> alignment : this.sureAlignments) {
            Integer englishPos = alignment.getFirst();
            Integer foreignPos = alignment.getSecond();
            if (englishPos < 0 || foreignPos < 0) continue;
            this.foreignAlignments.get(foreignPos).add(englishPos);
            this.englishAlignments.get(englishPos).add(foreignPos);
        }
    }

    public void addAlignment(int englishPos, int foreignPos, boolean sure) {
        Pair<Integer, Integer> alignment = new Pair<Integer, Integer>(englishPos, foreignPos);
        if (sure) {
            this.sureAlignments.add(alignment);
        }
        this.possibleAlignments.add(alignment);
        this.englishAlignments = null;
        this.foreignAlignments = null;
    }

    public void addAlignment(int i, int j) {
        this.addAlignment(i, j, true);
    }

    public void removeAlignment(int i, int j) {
        Pair<Integer, Integer> al = Pair.newPair(i, j);
        if (this.sureAlignments.contains(al)) {
            this.sureAlignments.remove(al);
        }
        if (this.possibleAlignments.contains(al)) {
            this.possibleAlignments.remove(al);
        }
    }

    public void setStrength(int i, int j, double strength) {
        this.strengths.put(new Pair<Integer, Integer>(i, j), strength);
    }

    public Alignment thresholdAlignmentByStrength(double threshold) {
        Alignment newAlignment = new Alignment(this.englishSentence, this.foreignSentence, this.englishTree, this.foreignTree);
        for (Pair<Integer, Integer> ij : this.strengths.keySet()) {
            int i = ij.getFirst();
            int j = ij.getSecond();
            double strength = this.strengths.get(ij);
            newAlignment.setStrength(i, j, strength);
            if (!(strength >= threshold)) continue;
            newAlignment.addAlignment(i, j, true);
        }
        return newAlignment;
    }

    public Alignment thresholdPosteriors(double[][] posteriors, double threshold) {
        Alignment newAlignment = new Alignment(this);
        int J = posteriors.length;
        int I = posteriors[0].length;
        assert (J == this.getForeignLength() && I == this.getEnglishLength());
        for (int j = 0; j < J; ++j) {
            for (int i = 0; i < I; ++i) {
                newAlignment.setStrength(i, j, posteriors[j][i]);
                if (!(posteriors[j][i] >= threshold)) continue;
                newAlignment.addAlignment(i, j, true);
            }
        }
        return newAlignment;
    }

    public static Map<Integer, Alignment> thresholdAlignmentsByStrength(Map<Integer, Alignment> alignments, double threshold) {
        HashMap<Integer, Alignment> newAlignments = new HashMap<Integer, Alignment>();
        for (int sid : alignments.keySet()) {
            Alignment alignment = alignments.get(sid);
            alignment = alignment.thresholdAlignmentByStrength(threshold);
            newAlignments.put(sid, alignment);
        }
        return newAlignments;
    }

    public Alignment intersect(Alignment a) {
        Tree<String> englishTree = this.englishTree == null ? a.englishTree : this.englishTree;
        Tree<String> foreignTree = this.foreignTree == null ? a.foreignTree : this.foreignTree;
        Alignment ia = new Alignment(this.englishSentence, this.foreignSentence, englishTree, foreignTree);
        for (Pair<Integer, Integer> p : this.sureAlignments) {
            if (!a.sureAlignments.contains(p) && p.getFirst() < a.getEnglishLength() && p.getSecond() < a.getForeignLength()) continue;
            ia.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : a.sureAlignments) {
            if (p.getFirst() < this.getEnglishLength() && p.getSecond() < this.getForeignLength()) continue;
            ia.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : this.possibleAlignments) {
            if (!a.possibleAlignments.contains(p) && p.getFirst() < a.getEnglishLength() && p.getSecond() < a.getForeignLength()) continue;
            ia.possibleAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : a.possibleAlignments) {
            if (p.getFirst() < this.getEnglishLength() && p.getSecond() < this.getForeignLength()) continue;
            ia.possibleAlignments.add(p);
        }
        return ia;
    }

    public Alignment subtract(Alignment a) {
        Alignment ia = new Alignment(this);
        for (Pair<Integer, Integer> p : this.sureAlignments) {
            if (a.sureAlignments.contains(p)) continue;
            ia.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : this.possibleAlignments) {
            if (a.possibleAlignments.contains(p)) continue;
            ia.possibleAlignments.add(p);
        }
        return ia;
    }

    public Alignment union(Alignment a) {
        Tree<String> englishTree = this.englishTree == null ? a.englishTree : this.englishTree;
        Tree<String> foreignTree = this.foreignTree == null ? a.foreignTree : this.foreignTree;
        Alignment ua = new Alignment(this.englishSentence, this.foreignSentence, englishTree, foreignTree);
        for (Pair<Integer, Integer> p : this.sureAlignments) {
            ua.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : a.sureAlignments) {
            ua.sureAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : this.possibleAlignments) {
            ua.possibleAlignments.add(p);
        }
        for (Pair<Integer, Integer> p : a.possibleAlignments) {
            ua.possibleAlignments.add(p);
        }
        return ua;
    }

    public Alignment reverse() {
        Alignment a2 = new Alignment(this.foreignSentence, this.englishSentence, this.foreignTree, this.englishTree);
        for (Pair<Integer, Integer> p : this.sureAlignments) {
            a2.sureAlignments.add(p.reverse());
        }
        for (Pair<Integer, Integer> p : this.possibleAlignments) {
            a2.possibleAlignments.add(p.reverse());
        }
        if (this.strengths != null) {
            for (Pair<Integer, Integer> p : this.strengths.keySet()) {
                a2.setStrength(p.getFirst(), p.getSecond(), this.strengths.get(p));
            }
        }
        return a2;
    }

    public Alignment chop(int i1, int i2, int j1, int j2) {
        Alignment choppedAlignment = new Alignment(this.englishSentence.subList(i1, i2), this.foreignSentence.subList(j1, j2));
        for (int i = i1; i < i2; ++i) {
            for (int j = j1; j < j2; ++j) {
                boolean isPossible = this.containsPossibleAlignment(i, j);
                boolean isSure = this.containsSureAlignment(i, j);
                if (isPossible) {
                    choppedAlignment.addAlignment(i - i1, j - j1, isSure);
                }
                choppedAlignment.setStrength(i - i1, j - j1, this.getStrength(i, j));
            }
        }
        return choppedAlignment;
    }

    public String toString() {
        return Alignment.render(this, this);
    }

    public static String render(Alignment reference, Alignment proposed) {
        return Alignment.render(reference, proposed, null);
    }

    public static String render(Alignment reference, Alignment proposed, String2DoubleMap glossDictionary) {
        StringBuilder sb = new StringBuilder();
        List<String> englishWords = reference.englishSentence;
        List<String> foreignWords = reference.foreignSentence;
        for (int sourcePosition = 0; sourcePosition < foreignWords.size(); ++sourcePosition) {
            StringDoubleMap eMap;
            for (int targetPosition = 0; targetPosition < englishWords.size(); ++targetPosition) {
                boolean sure = reference.containsSureAlignment(targetPosition, sourcePosition);
                boolean possible = reference.containsPossibleAlignment(targetPosition, sourcePosition);
                char proposedChar = ' ';
                if (proposed.containsSureAlignment(targetPosition, sourcePosition)) {
                    proposedChar = '#';
                } else if (proposed.containsEnglishParentAlignment(targetPosition, sourcePosition)) {
                    proposedChar = '*';
                }
                if (sure) {
                    sb.append('[');
                    sb.append(proposedChar);
                    sb.append(']');
                    continue;
                }
                if (possible) {
                    sb.append('(');
                    sb.append(proposedChar);
                    sb.append(')');
                    continue;
                }
                sb.append(' ');
                sb.append(proposedChar);
                sb.append(' ');
            }
            sb.append("| ");
            String fword = foreignWords.get(sourcePosition);
            sb.append(fword);
            if (glossDictionary != null && (eMap = glossDictionary.getMap(fword, false)) != null) {
                String eWords = eMap.keySet().toString();
                sb.append(" ");
                sb.append(eWords);
            }
            sb.append('\n');
        }
        for (int targetPosition = 0; targetPosition < englishWords.size(); ++targetPosition) {
            sb.append("---");
        }
        sb.append("'\n");
        boolean printed = true;
        int index = 0;
        while (printed) {
            printed = false;
            StringBuilder lineSB = new StringBuilder();
            for (int targetPosition = 0; targetPosition < englishWords.size(); ++targetPosition) {
                String targetWord = englishWords.get(targetPosition);
                if (targetWord.length() > index) {
                    printed = true;
                    lineSB.append(' ');
                    lineSB.append(targetWord.charAt(index));
                    lineSB.append(' ');
                    continue;
                }
                lineSB.append("   ");
            }
            ++index;
            if (!printed) continue;
            sb.append((CharSequence)lineSB);
            sb.append('\n');
        }
        return sb.toString();
    }

    public String output() {
        return this.dumpModifiedPharaoh(this.strengths != null && !this.strengths.isEmpty());
    }

    public String outputHard() {
        return this.dumpModifiedPharaoh(false);
    }

    public String outputSoft() {
        return this.dumpModifiedPharaoh(true);
    }

    public String outputPharaohHard() {
        StringBuffer sbuf = new StringBuffer();
        for (Pair<Integer, Integer> pair : this.sureAlignments) {
            sbuf.append(pair.getSecond() + "-" + pair.getFirst() + " ");
        }
        for (Pair<Integer, Integer> pair : this.possibleAlignments) {
            if (this.sureAlignments.contains(pair)) continue;
            sbuf.append(pair.getSecond() + "-" + pair.getFirst() + "-P ");
        }
        return sbuf.toString();
    }

    private String dumpModifiedPharaoh(boolean soft) {
        StringBuffer sbuf = new StringBuffer();
        if (soft) {
            for (Pair<Integer, Integer> pair : this.strengths.keySet()) {
                double strength = this.strengths.get(pair);
                sbuf.append(pair.getFirst() + 1 + "-" + (pair.getSecond() + 1) + "-" + strength);
                sbuf.append(" ");
            }
        } else {
            for (Pair<Integer, Integer> pair : this.sureAlignments) {
                sbuf.append(pair.getFirst() + 1 + "-" + (pair.getSecond() + 1) + " ");
            }
            for (Pair<Integer, Integer> pair : this.possibleAlignments) {
                if (this.sureAlignments.contains(pair)) continue;
                sbuf.append(pair.getFirst() + 1 + "-" + (pair.getSecond() + 1) + "-P ");
            }
        }
        return sbuf.toString();
    }

    public void parseAlignments(String line) {
        this.parseAlignments(line, false);
    }

    public void parseAlignments(String line, boolean reverse) {
        String noComment = line;
        String[] aligns = StrUtils.split(noComment);
        for (int i = 0; i < aligns.length; ++i) {
            String[] els = StrUtils.split(aligns[i], "-");
            int en = Integer.parseInt(reverse ? els[0] : els[1]);
            int fr = Integer.parseInt(reverse ? els[1] : els[0]);
            if (els.length == 2) {
                this.addAlignment(en, fr, true);
                continue;
            }
            if (els[2].equals("P")) {
                this.addAlignment(en, fr, false);
                continue;
            }
            if (els.length == 4) {
                els[2] = els[2] + "-" + els[3];
            }
            double strength = Double.parseDouble(els[2]);
            this.setStrength(en, fr, strength);
        }
    }

    public List<Integer> getNullAlignedEnglishIndices() {
        ArrayList<Integer> nulls = new ArrayList<Integer>();
        boolean[] hasAlignment = new boolean[this.getEnglishLength()];
        for (Pair<Integer, Integer> al : this.sureAlignments) {
            hasAlignment[al.getFirst().intValue()] = true;
        }
        for (int en = 0; en < this.getEnglishLength(); ++en) {
            if (hasAlignment[en]) continue;
            nulls.add(en);
        }
        return nulls;
    }

    public List<Integer> getNullAlignedForeignIndices() {
        ArrayList<Integer> nulls = new ArrayList<Integer>();
        boolean[] hasAlignment = new boolean[this.getForeignLength()];
        for (Pair<Integer, Integer> al : this.sureAlignments) {
            hasAlignment[al.getSecond().intValue()] = true;
        }
        for (int fr = 0; fr < this.getForeignLength(); ++fr) {
            if (hasAlignment[fr]) continue;
            nulls.add(fr);
        }
        return nulls;
    }

    private List<Integer> addOne(List<Integer> list) {
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (int x : list) {
            newList.add(x + 1);
        }
        return newList;
    }

    public void writeGIZA(PrintWriter out, int idx) {
        out.printf("# sentence pair (%d) source length %d target length %d alignment score : 0\n", idx, this.englishSentence.size(), this.foreignSentence.size());
        out.println(StrUtils.join(this.foreignSentence));
        out.printf("NULL ({ %s })", StrUtils.join(this.addOne(this.getNullAlignedForeignIndices())));
        for (int i = 0; i < this.englishSentence.size(); ++i) {
            List<Integer> alignments = this.addOne(this.getAlignmentsToEnglish(i));
            Collections.sort(alignments);
            out.printf(" %s ({ %s })", this.englishSentence.get(i), StrUtils.join(alignments));
        }
        out.println("");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AlignmentNode
    implements Serializable {
        private static final long serialVersionUID = 1L;
        boolean isWord;
        String word;
        Tree<String> internalNode;

        AlignmentNode(String word) {
            this.isWord = true;
            this.word = word;
            this.internalNode = null;
        }

        AlignmentNode(Tree<String> internalNode) {
            this.isWord = false;
            this.word = internalNode.getLabel();
            this.internalNode = internalNode;
        }

        public boolean isInternalNode() {
            return !this.isWord;
        }

        public Tree<String> getTreeNode() {
            return this.internalNode;
        }
    }
}

