/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import edu.berkeley.nlp.mt.BleuScore;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;

public class AveragedBleuScore {
    private BleuScore baseBleuScore;
    double score = Double.NEGATIVE_INFINITY;
    private static DecimalFormat format = null;

    public AveragedBleuScore(BleuScore score) {
        this.baseBleuScore = score;
    }

    public double getScore() {
        return this.getScore(this.baseBleuScore.getIndividualNGramScorings().size());
    }

    public double getScore(int maxN) {
        List<Double> individualNGramScorings = this.baseBleuScore.getIndividualNGramScorings();
        ArrayList<Double> individualNGramLogs = new ArrayList<Double>();
        for (double currentScore : individualNGramScorings) {
            individualNGramLogs.add(Math.log(currentScore));
        }
        double penalty = this.baseBleuScore.brevityPenalty();
        int i = 1;
        double average = 0.0;
        for (int N = maxN; N > 0; --N) {
            double exponent = 0.0;
            for (int j = 0; j < N; ++j) {
                exponent += (Double)individualNGramLogs.get(j) / (double)N;
            }
            average += penalty * Math.exp(exponent) / Math.pow(2.0, i);
            ++i;
        }
        this.score = average;
        return this.score;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof BleuScore) {
            BleuScore other = (BleuScore)arg0;
            if (this.getScore() < other.getScore()) {
                return -1;
            }
            if (this.getScore() > other.getScore()) {
                return 1;
            }
            return 0;
        }
        throw new ClassCastException();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof BleuScore) {
            BleuScore other = (BleuScore)arg0;
            if (this.getScore() == other.getScore()) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Averaged Bleu scores: ").append(AveragedBleuScore.formatDouble(this.getScore())).append("\n");
        buffer.append("\nIndividual N-gram scoring\n        1-gram   2-gram   3-gram   4-gram   5-gram   6-gram   7-gram   8-gram   9-gram   ...\n        ------   ------   ------   ------   ------   ------   ------   ------   ------ \nBLEU:");
        for (double score : this.baseBleuScore.getIndividualNGramScorings()) {
            buffer.append("  ").append(AveragedBleuScore.formatDouble(score)).append(" ");
        }
        buffer.append("\nCumulative N-gram scoring\n        1-gram   2-gram   3-gram   4-gram   5-gram   6-gram   7-gram   8-gram   9-gram   ...\n        ------   ------   ------   ------   ------   ------   ------   ------   ------ \nBLEU:");
        for (int i = 1; i <= this.baseBleuScore.getIndividualNGramScorings().size(); ++i) {
            buffer.append("  ").append(AveragedBleuScore.formatDouble(this.getScore(i))).append(" ");
        }
        return buffer.toString();
    }

    public static String formatDouble(double number) {
        if (format == null) {
            DecimalFormatSymbols dsymb = new DecimalFormatSymbols();
            dsymb.setDecimalSeparator('.');
            format = new DecimalFormat("0.0000");
            format.setDecimalFormatSymbols(dsymb);
        }
        return format.format(number);
    }
}

