/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import edu.berkeley.nlp.mt.AveragedBleuScore;
import edu.berkeley.nlp.mt.BleuScore;
import edu.berkeley.nlp.util.Counter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchBleuScorer {
    final int N;
    double[] numerators;
    double[] denominators;
    private List<Double> weights;
    private int refLength;
    private int candLength;

    public BatchBleuScorer(int maxN) {
        this.N = maxN;
        this.numerators = new double[maxN];
        this.denominators = new double[maxN];
        this.weights = new ArrayList<Double>();
        for (int i = 0; i < this.N; ++i) {
            this.weights.add(1.0 / (double)this.N);
        }
    }

    public BatchBleuScorer() {
        this(4);
    }

    public double evaluateBleu(String candidate, String reference) {
        List<String> candList = Arrays.asList(candidate.split(" "));
        List<String> refList = Arrays.asList(reference.split(" "));
        return new AveragedBleuScore(this.evaluateBleu(candList, refList)).getScore();
    }

    public double evaluateBleu(String candidate, List<String> references) {
        List<String> candList = Arrays.asList(candidate.split(" "));
        ArrayList<String> refList = new ArrayList<String>();
        for (String reference : references) {
            refList.addAll(Arrays.asList(reference.split(" ")));
        }
        return new AveragedBleuScore(this.evaluateBleu(candList, refList)).getScore();
    }

    public AveragedBleuScore getScore() {
        ArrayList<Double> globalScores = new ArrayList<Double>();
        for (int i = 0; i < this.N; ++i) {
            globalScores.add(this.numerators[i] / this.denominators[i]);
        }
        return new AveragedBleuScore(new BleuScore(globalScores, this.weights, this.refLength, this.candLength));
    }

    private BleuScore evaluateBleu(List<String> candidate, List<String> reference) {
        ArrayList<Double> individualNGramScorings = new ArrayList<Double>();
        for (int i = 0; i < this.N; ++i) {
            individualNGramScorings.add(this.computeIndividualNGramScoring(i + 1, candidate, reference));
        }
        this.refLength += reference.size();
        this.candLength += candidate.size();
        return new BleuScore(individualNGramScorings, this.weights, reference.size(), candidate.size());
    }

    protected double computeIndividualNGramScoring(int n, List<String> candidate, List<String> reference) {
        double denominator = 0.0;
        double numerator = 0.0;
        Counter candidateNGramCounts = this.extractNGramCounts(n, candidate);
        Counter referenceNGramCounts = this.extractNGramCounts(n, reference);
        for (Object currentNGram : candidateNGramCounts.keySet()) {
            double currentCount = candidateNGramCounts.getCount(currentNGram);
            denominator += currentCount;
            double max = referenceNGramCounts.getCount(currentNGram);
            if (max < currentCount) {
                numerator += max;
                continue;
            }
            numerator += currentCount;
        }
        int n2 = n - 1;
        this.numerators[n2] = this.numerators[n2] + numerator;
        int n3 = n - 1;
        this.denominators[n3] = this.denominators[n3] + denominator;
        if (denominator == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }

    protected Counter extractNGramCounts(int n, List<String> sentences) {
        Counter<List<String>> nGrams = new Counter<List<String>>();
        for (int i = 0; i <= sentences.size() - n; ++i) {
            nGrams.incrementCount(sentences.subList(i, i + n), 1.0);
        }
        return nGrams;
    }
}

