/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BleuModifiedNgram
implements Comparable<BleuModifiedNgram> {
    private String pattern = "";
    private List<Integer> numbers;

    public BleuModifiedNgram(List<String> ngram) {
        this.numbers = new ArrayList<Integer>(ngram.size());
        for (String s : ngram) {
            if (s.matches("\\p{Digit}+")) {
                this.numbers.add(Integer.valueOf(s));
                this.pattern = this.pattern + "# ";
                continue;
            }
            this.pattern = this.pattern + s + " ";
        }
        this.pattern = this.pattern.trim();
    }

    public boolean equals(Object obj) {
        assert (obj instanceof BleuModifiedNgram);
        BleuModifiedNgram b = (BleuModifiedNgram)obj;
        if (!this.pattern.equals(b.pattern)) {
            return false;
        }
        for (int i = 0; i < this.numbers.size(); ++i) {
            if (Math.abs(this.numbers.get(i) - b.numbers.get(i)) <= 6) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        String[] ar = this.pattern.split(" ");
        String out = "";
        int i = 0;
        for (String s : ar) {
            out = s.equals("#") ? out + this.numbers.get(i++) + " " : out + s + " ";
        }
        return out.trim();
    }

    @Override
    public int compareTo(BleuModifiedNgram o) {
        if (this.equals(o)) {
            return 0;
        }
        return -1;
    }
}

