/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BleuScore {
    private List<Double> individualNGramScorings;
    private List<Double> weights;
    private double r;
    private double c;
    private double bleu = Double.NEGATIVE_INFINITY;

    public BleuScore(List<Double> individualNGramScorings, List<Double> weights, double r, double c) {
        this.individualNGramScorings = individualNGramScorings;
        this.weights = weights;
        this.r = r;
        this.c = c;
    }

    public List<Double> getIndividualNGramScorings() {
        return this.individualNGramScorings;
    }

    public double getBleuScore() {
        if (this.bleu == Double.NEGATIVE_INFINITY) {
            double exponent = 0.0;
            for (int i = 0; i < this.individualNGramScorings.size(); ++i) {
                exponent += Math.log(this.individualNGramScorings.get(i)) * this.weights.get(i);
            }
            this.bleu = this.brevityPenalty() * Math.exp(exponent);
            return this.bleu;
        }
        return this.bleu;
    }

    public double brevityPenalty() {
        if (this.c > this.r) {
            return 1.0;
        }
        return Math.exp(1.0 - this.r / this.c);
    }

    public String toString() {
        return new Double(this.getBleuScore()).toString();
    }

    public double getScore() {
        return this.getBleuScore();
    }

    public List<Double> getWeights() {
        return this.weights;
    }

    public int compareTo(Object arg0) {
        if (arg0 instanceof BleuScore) {
            BleuScore other = (BleuScore)arg0;
            if (this.getScore() < other.getScore()) {
                return -1;
            }
            if (this.getScore() > other.getScore()) {
                return 1;
            }
            return 0;
        }
        throw new ClassCastException();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof BleuScore) {
            BleuScore other = (BleuScore)arg0;
            if (this.getScore() == other.getScore()) {
                return true;
            }
        }
        return false;
    }
}

