/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import edu.berkeley.nlp.mt.BleuScore;
import edu.berkeley.nlp.mt.TestSentence;
import edu.berkeley.nlp.util.Counter;
import fig.basic.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BleuScorer {
    private int N;
    private List<Double> weights;

    public BleuScorer() {
        this(4);
    }

    public BleuScorer(int N) {
        this.N = N;
        this.weights = new ArrayList<Double>();
        for (int i = 0; i < N; ++i) {
            this.weights.add(1.0 / (double)N);
        }
    }

    public BleuScorer(List<Double> weights) {
        this();
        if (weights != null) {
            this.weights = weights;
            this.N = weights.size();
        }
    }

    private static List<String> normalizeText(List<String> words) {
        String text = StrUtils.join(words);
        text = text.replaceAll("(\\d)\\s+(?=\\d)", "$1");
        text = text.replaceAll("([\\{-\\~\\[-\\` -\\&\\(-\\+\\:-\\@\\/])", " $1 ");
        text = text.replaceAll("([^0-9])([\\.,])", "$1 $2 ");
        text = text.replaceAll("([\\.,])([^0-9])", " $1 $2");
        text = text.replaceAll("([0-9])(-)", "$1 $2 ");
        words = Arrays.asList(StrUtils.split(text.trim(), "\\s+"));
        return words;
    }

    public BleuScore evaluateBleu(List<List<String>> candidates, List<TestSentence> testSentences, boolean normalize) {
        if (normalize) {
            ArrayList<List<String>> newCandidates = new ArrayList<List<String>>();
            for (List<String> candidate : candidates) {
                newCandidates.add(BleuScorer.normalizeText(candidate));
            }
            candidates = newCandidates;
            ArrayList<TestSentence> newTestSentences = new ArrayList<TestSentence>();
            for (TestSentence testSentence : testSentences) {
                ArrayList<List<String>> newReferenceSet = new ArrayList<List<String>>();
                for (List<String> reference : testSentence.getReferences()) {
                    newReferenceSet.add(BleuScorer.normalizeText(reference));
                }
                newTestSentences.add(new TestSentence(testSentence.getForeignSentence(), newReferenceSet));
            }
            testSentences = newTestSentences;
        }
        ArrayList<Double> individualNGramScorings = new ArrayList<Double>();
        for (int i = 0; i < this.N; ++i) {
            individualNGramScorings.add(this.computeIndividualNGramScoring(i + 1, candidates, testSentences));
        }
        return new BleuScore(individualNGramScorings, this.weights, this.computeR(candidates, testSentences), this.computeC(candidates));
    }

    protected double computeC(List<List<String>> candidates) {
        double sum = 0.0;
        for (List<String> currentCandidate : candidates) {
            sum += (double)currentCandidate.size();
        }
        return sum;
    }

    protected double computeR(List<List<String>> candidates, List<TestSentence> testSentences) {
        double sum = 0.0;
        for (int i = 0; i < candidates.size(); ++i) {
            double min = Double.POSITIVE_INFINITY;
            double argmin = 0.0;
            for (List<String> reference : testSentences.get(i).getReferences()) {
                double currentValue = Math.abs(reference.size() - candidates.get(i).size());
                if (!(currentValue < min)) continue;
                min = currentValue;
                argmin = reference.size();
            }
            sum += argmin;
        }
        return sum;
    }

    protected double computeIndividualNGramScoring(int n, List<List<String>> candidates, List<TestSentence> testSentences) {
        double denominator = 0.0;
        double numerator = 0.0;
        for (int i = 0; i < candidates.size(); ++i) {
            List<String> currentCandidate = candidates.get(i);
            Counter<List<String>> candidateNGramCounts = this.extractNGramCounts(n, currentCandidate);
            ArrayList<Counter<List<String>>> referenceSetNGramCounts = new ArrayList<Counter<List<String>>>();
            for (List<String> reference : testSentences.get(i).getReferences()) {
                referenceSetNGramCounts.add(this.extractNGramCounts(n, reference));
            }
            for (List<String> currentNGram : candidateNGramCounts.keySet()) {
                double currentCount = candidateNGramCounts.getCount(currentNGram);
                denominator += currentCount;
                double max = 0.0;
                for (Counter counter : referenceSetNGramCounts) {
                    double tempCount = counter.getCount(currentNGram);
                    if (!(tempCount > max)) continue;
                    max = tempCount;
                }
                if (max < currentCount) {
                    numerator += max;
                    continue;
                }
                numerator += currentCount;
            }
        }
        if (denominator == 0.0) {
            return 0.0;
        }
        return numerator / denominator;
    }

    protected Counter<List<String>> extractNGramCounts(int n, List<String> sentences) {
        Counter<List<String>> nGrams = new Counter<List<String>>();
        for (int i = 0; i <= sentences.size() - n; ++i) {
            nGrams.incrementCount(sentences.subList(i, i + n), 1.0);
        }
        return nGrams;
    }
}

