/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import edu.berkeley.nlp.mt.Alignment;
import edu.berkeley.nlp.mt.AlignmentReader;
import edu.berkeley.nlp.mt.GizaAlignment;
import edu.berkeley.nlp.mt.GizaFormatException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GizaAlignmentReader
implements AlignmentReader {
    protected String fileName;
    protected BufferedReader fileReader;

    public GizaAlignmentReader(String fileName) {
        this.fileName = fileName;
        try {
            this.fileReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public GizaAlignmentReader(BufferedReader reader) {
        this.fileReader = reader;
    }

    @Override
    public GizaAlignment getNextAlignment() throws IOException, GizaFormatException {
        int i;
        String infoline = this.fileReader.readLine();
        String[] infowords = infoline.split("\\s+");
        if (infowords.length != 14) {
            throw new GizaFormatException("Bad alignment file " + this.fileName + ": wrong number of words in input line. Bad line was " + infoline);
        }
        if (!infowords[0].equals("#")) {
            throw new GizaFormatException("Bad alignment file " + this.fileName + ": input line without initial #. Bad line was " + infoline);
        }
        Integer sentenceID = Integer.parseInt(infowords[3].substring(1, infowords[3].length() - 1));
        Double score = Double.parseDouble(infowords[13]);
        String frenchline = this.fileReader.readLine();
        List<String> frenchWords = Arrays.asList(frenchline.split("\\s+"));
        String englishline = this.fileReader.readLine();
        List<String> englishWords = Arrays.asList(englishline.split("\\s+"));
        for (i = 0; i < frenchWords.size(); ++i) {
            frenchWords.set(i, frenchWords.get(i).intern());
        }
        for (i = 0; i < englishWords.size(); ++i) {
            englishWords.set(i, englishWords.get(i).intern());
        }
        return GizaAlignmentReader.parseAlignment(frenchWords, englishWords, sentenceID, score, this.fileName);
    }

    @Override
    public boolean hasNext() {
        try {
            return this.fileReader.ready();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public List<Alignment> getAllAlignments() throws IOException, GizaFormatException {
        ArrayList<Alignment> alignments = new ArrayList<Alignment>();
        while (this.hasNext()) {
            alignments.add(this.getNextAlignment());
        }
        return alignments;
    }

    public static List<GizaAlignment> readAlignments(String fileName) throws IOException, GizaFormatException {
        ArrayList<GizaAlignment> alignments = new ArrayList<GizaAlignment>();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF-8"));
        while (in.ready()) {
            String infoline = in.readLine();
            String[] infowords = infoline.split("\\s+");
            if (infowords.length != 14) {
                throw new GizaFormatException("Bad alignment file " + fileName + ": wrong number of words in input line. Bad line was " + infoline);
            }
            if (!infowords[0].equals("#")) {
                throw new GizaFormatException("Bad alignment file " + fileName + ": input line without initial #. Bad line was " + infoline);
            }
            Integer sentenceID = Integer.parseInt(infowords[3].substring(1, infowords[3].length() - 1));
            Double score = Double.parseDouble(infowords[13]);
            String frenchline = in.readLine();
            List<String> frenchWords = Arrays.asList(frenchline.split("\\s+"));
            String englishline = in.readLine();
            List<String> englishLine = Arrays.asList(englishline.split("\\s+"));
            alignments.add(GizaAlignmentReader.parseAlignment(frenchWords, englishLine, sentenceID, score, fileName));
        }
        return alignments;
    }

    private static GizaAlignment parseAlignment(List<String> frenchWords, List<String> englishInput, Integer sentenceID, Double score, String fileName) throws GizaFormatException {
        ArrayList<String> englishWords = new ArrayList<String>();
        int[] alignmentsFromFrenchToEnglish = new int[frenchWords.size() + 1];
        int englishPosition = 0;
        int inputPosition = 0;
        while (inputPosition < englishInput.size()) {
            if (englishPosition != 0) {
                englishWords.add(englishInput.get(inputPosition));
                if (!"({".equals(englishInput.get(++inputPosition))) {
                    throw new GizaFormatException("Improperly formed english input string at sentence #" + sentenceID);
                }
                ++inputPosition;
                while (!"})".equals(englishInput.get(inputPosition))) {
                    try {
                        int french = Integer.parseInt(englishInput.get(inputPosition));
                        alignmentsFromFrenchToEnglish[french] = englishPosition;
                        ++inputPosition;
                    }
                    catch (NumberFormatException nfe) {
                        throw new GizaFormatException("Improperly formed english input string at sentence #" + sentenceID);
                    }
                }
            } else {
                while (!"})".equals(englishInput.get(inputPosition))) {
                    ++inputPosition;
                }
            }
            ++inputPosition;
            ++englishPosition;
        }
        GizaAlignment alignment = new GizaAlignment(englishWords, frenchWords, score, sentenceID, fileName);
        for (int frenchPosition = 1; frenchPosition <= frenchWords.size(); ++frenchPosition) {
            alignment.addAlignment(alignmentsFromFrenchToEnglish[frenchPosition] - 1, frenchPosition - 1);
        }
        return alignment;
    }

    @Override
    public Iterator<Alignment> iterator() {
        return new GizaAlignmentIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class GizaAlignmentIterator
    implements Iterator<Alignment> {
        @Override
        public boolean hasNext() {
            return GizaAlignmentReader.this.hasNext();
        }

        @Override
        public GizaAlignment next() {
            try {
                return GizaAlignmentReader.this.getNextAlignment();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (GizaFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove alignments from a reader.");
        }
    }
}

