/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import edu.berkeley.nlp.mt.Alignment;
import edu.berkeley.nlp.mt.AlignmentReader;
import edu.berkeley.nlp.mt.GizaFormatException;
import fig.basic.StrUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PharaohReader
implements AlignmentReader {
    BufferedReader outSentences;
    BufferedReader inSentences;
    BufferedReader specsReader;
    boolean swap;

    public PharaohReader(BufferedReader outSentences, BufferedReader inSentences, BufferedReader specsReader, boolean swap) {
        this.outSentences = outSentences;
        this.inSentences = inSentences;
        this.specsReader = specsReader;
        this.swap = swap;
    }

    public PharaohReader(BufferedReader outSentences, BufferedReader inSentences, BufferedReader specsReader) {
        this(outSentences, inSentences, specsReader, false);
    }

    @Override
    public Alignment getNextAlignment() throws IOException, GizaFormatException {
        List<String> out = StrUtils.splitByStr(this.outSentences.readLine().trim(), " ");
        List<String> in = StrUtils.splitByStr(this.inSentences.readLine().trim(), " ");
        Alignment a = new Alignment(out, in);
        String specs = this.specsReader.readLine().trim();
        a = PharaohReader.parseAlignments(out, in, specs);
        return a;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.outSentences.ready() && this.inSentences.ready() && this.specsReader.ready();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public List<Alignment> getAllAlignments() throws IOException, GizaFormatException {
        ArrayList<Alignment> als = new ArrayList<Alignment>();
        while (this.hasNext()) {
            als.add(this.getNextAlignment());
        }
        return als;
    }

    @Override
    public Iterator<Alignment> iterator() {
        return new AlignmentIterator();
    }

    public static Alignment parseAlignments(List<String> outSentence, List<String> inSentence, String specs, boolean swap, Alignment a) {
        Alignment result = a;
        for (String currentAlignmentPtSpec : StrUtils.splitByStr(specs, " ")) {
            if (currentAlignmentPtSpec.equals("")) continue;
            List<String> components = StrUtils.splitByStr(currentAlignmentPtSpec, "-");
            if (components.size() != 2) {
                throw new RuntimeException("Malformed alignment specifications.\nSpecs: " + specs + "\nProblem is: " + currentAlignmentPtSpec);
            }
            try {
                int outPosition;
                int inPosition;
                if (swap) {
                    inPosition = Integer.parseInt(components.get(1));
                    outPosition = Integer.parseInt(components.get(0));
                } else {
                    inPosition = Integer.parseInt(components.get(0));
                    outPosition = Integer.parseInt(components.get(1));
                }
                result.addAlignment(outPosition, inPosition);
            }
            catch (NumberFormatException fne) {
                throw new RuntimeException("Malformed alignment specifications.\nSpecs: " + specs + "\nProblem is: " + currentAlignmentPtSpec);
            }
        }
        return result;
    }

    public static Alignment parseAlignments(List<String> outSentence, List<String> inSentence, String specs, boolean swap) {
        return PharaohReader.parseAlignments(outSentence, inSentence, specs, swap, new Alignment(outSentence, inSentence));
    }

    public static Alignment parseAlignments(List<String> outSentence, List<String> inSentence, String specs) {
        return PharaohReader.parseAlignments(outSentence, inSentence, specs, false);
    }

    public static Alignment parseAlignments(String outSentence, String inSentence, String specs, boolean swap, Alignment a) {
        List<String> outSentenceList = StrUtils.splitByStr(outSentence, " ");
        List<String> inSentenceList = StrUtils.splitByStr(inSentence, " ");
        return PharaohReader.parseAlignments(outSentenceList, inSentenceList, specs, swap, a);
    }

    public static Alignment parseAlignments(String outSentence, String inSentence, String specs, boolean swap) {
        List<String> outSentenceList = StrUtils.splitByStr(outSentence, " ");
        List<String> inSentenceList = StrUtils.splitByStr(inSentence, " ");
        return PharaohReader.parseAlignments(outSentenceList, inSentenceList, specs, swap);
    }

    public static Alignment parseAlignments(String outSentence, String inSentence, String specs) {
        List<String> outSentenceList = StrUtils.splitByStr(outSentence, " ");
        List<String> inSentenceList = StrUtils.splitByStr(inSentence, " ");
        return PharaohReader.parseAlignments(outSentenceList, inSentenceList, specs);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AlignmentIterator
    implements Iterator<Alignment> {
        @Override
        public boolean hasNext() {
            return PharaohReader.this.hasNext();
        }

        @Override
        public Alignment next() {
            try {
                return PharaohReader.this.getNextAlignment();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (GizaFormatException e) {
                e.printStackTrace();
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

