/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mt;

import edu.berkeley.nlp.mt.Alignment;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Lists;
import fig.basic.StrUtils;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentencePair
implements Serializable {
    static final long serialVersionUID = 42L;
    public int ID;
    String sourceFile;
    List<String> englishWords;
    List<String> englishTags;
    List<String> foreignWords;
    List<String> foreignTags;
    Tree<String> englishTree;
    Tree<String> foreignTree;
    Alignment alignment;

    public SentencePair reverse() {
        SentencePair pair = new SentencePair(this.ID, this.sourceFile, this.foreignWords, this.englishWords);
        pair.foreignTags = this.englishTags;
        pair.englishTags = this.foreignTags;
        pair.foreignTree = this.englishTree;
        pair.englishTree = this.foreignTree;
        return pair;
    }

    public SentencePair(int sentenceID, String sourceFile, List<String> englishWords, List<String> frenchWords) {
        this.ID = sentenceID;
        this.sourceFile = sourceFile;
        this.englishWords = englishWords;
        this.foreignWords = frenchWords;
    }

    public int getSentenceID() {
        return this.ID;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public List<String> getEnglishWords() {
        return this.englishWords;
    }

    public List<String> getForeignWords() {
        return this.foreignWords;
    }

    public int I() {
        return this.englishWords.size();
    }

    public int J() {
        return this.foreignWords.size();
    }

    public String en(int i) {
        return this.englishWords.get(i);
    }

    public String fr(int j) {
        return this.foreignWords.get(j);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int englishPosition = 0; englishPosition < this.englishWords.size(); ++englishPosition) {
            String englishWord = this.englishWords.get(englishPosition);
            sb.append(englishPosition);
            sb.append(":");
            sb.append(englishWord);
            sb.append(" ");
        }
        sb.append("\n");
        for (int frenchPosition = 0; frenchPosition < this.foreignWords.size(); ++frenchPosition) {
            String frenchWord = this.foreignWords.get(frenchPosition);
            sb.append(frenchPosition);
            sb.append(":");
            sb.append(frenchWord);
            sb.append(" ");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static Set<String> getWordSet(List<SentencePair> sentencePairs, boolean isForeign) {
        HashSet<String> set = new HashSet<String>();
        for (SentencePair sp : sentencePairs) {
            List<String> words = isForeign ? sp.getForeignWords() : sp.getEnglishWords();
            for (String w : words) {
                set.add(w);
            }
        }
        return set;
    }

    public SentencePair chop(int i1, int i2, int j1, int j2) {
        return new SentencePair(this.ID, this.sourceFile, this.englishWords.subList(i1, i2), this.foreignWords.subList(j1, j2));
    }

    public Tree<String> getEnglishTree() {
        return this.englishTree;
    }

    public void setEnglishTree(Tree<String> englishTree) {
        this.englishTree = englishTree;
    }

    public Tree<String> getForeignTree() {
        return this.foreignTree;
    }

    public void setForeignTree(Tree<String> frenchTree) {
        this.foreignTree = frenchTree;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public void setAlignment(Alignment referenceAlignment) {
        this.alignment = referenceAlignment;
    }

    public List<String> getEnglishTags() {
        return this.englishTags;
    }

    public void setEnglishTags(List<String> englishTags) {
        this.englishTags = englishTags;
    }

    public List<String> getForeignTags() {
        return this.foreignTags;
    }

    public void setForeignTags(List<String> foreignTags) {
        this.foreignTags = foreignTags;
    }

    public String dump() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("ID:\t" + this.ID + "\tSource file:\t" + this.sourceFile + "\n");
        sbuf.append("En:\t" + StrUtils.join(this.englishWords, " ") + "\n");
        sbuf.append("Fr:\t" + StrUtils.join(this.foreignWords, " ") + "\n");
        sbuf.append("EnTags:\t");
        sbuf.append(this.englishTags);
        sbuf.append("\n");
        sbuf.append("FrTags:\t");
        sbuf.append(this.foreignTags);
        sbuf.append("\n");
        sbuf.append("EnTree:\t");
        sbuf.append(this.englishTree);
        sbuf.append("\n");
        sbuf.append("FrTree:\t");
        sbuf.append(this.foreignTree);
        sbuf.append("\n");
        sbuf.append("Alignment:\n");
        sbuf.append(this.alignment);
        return sbuf.toString();
    }

    public static SentencePair getSampleSentencePair() {
        String p = "(S (NP (DT the) (NNS jobs)) (VP (VBP are) (ADJP (NN career) (VBN oriented))) (. .))";
        Trees.PennTreeReader treeReader = new Trees.PennTreeReader(new StringReader(p));
        Object tree = treeReader.next();
        List<String> en = ((Tree)tree).getYield();
        ArrayList<String> fr = Lists.newList("les", "emplois", "sont", "axes", "sur", "la", "carriere", ".");
        SentencePair sp = new SentencePair(0, "", en, fr);
        sp.setEnglishTree((Tree<String>)tree);
        Alignment a = new Alignment(en, fr);
        a.addAlignment(0, 0);
        a.addAlignment(1, 1);
        a.addAlignment(2, 2);
        a.addAlignment(3, 6);
        a.addAlignment(4, 3);
        a.addAlignment(5, 7);
        sp.setAlignment(a);
        return sp;
    }
}

