/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.syntax.Constituent;
import edu.berkeley.nlp.util.Method;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<L>
implements Serializable,
Comparable<Tree<L>>,
Iterable<Tree<L>> {
    private static final long serialVersionUID = 1L;
    L label;
    List<Tree<L>> children;

    public void setChildren(List<Tree<L>> c) {
        this.children = c;
    }

    public List<Tree<L>> getChildren() {
        return this.children;
    }

    public L getLabel() {
        return this.label;
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public boolean isPreTerminal() {
        return this.getChildren().size() == 1 && this.getChildren().get(0).isLeaf();
    }

    public List<L> getYield() {
        ArrayList yield = new ArrayList();
        Tree.appendYield(this, yield);
        return yield;
    }

    public Map<Tree<L>, Constituent<L>> getConstituents() {
        HashMap<Tree<L>, Constituent<L>> constituents = new HashMap<Tree<L>, Constituent<L>>();
        Tree.appendConstituent(this, constituents, 0);
        return constituents;
    }

    public Collection<Constituent<L>> getConstituentCollection() {
        ArrayList<Constituent<L>> constituents = new ArrayList<Constituent<L>>();
        Tree.appendConstituent(this, constituents, 0);
        return constituents;
    }

    private static <L> int appendConstituent(Tree<L> tree, Map<Tree<L>, Constituent<L>> constituents, int index) {
        if (tree.isLeaf()) {
            Constituent<L> c = new Constituent<L>(tree.getLabel(), index, index);
            constituents.put(tree, c);
            return 1;
        }
        int nextIndex = index;
        for (Tree<L> kid : tree.getChildren()) {
            nextIndex += Tree.appendConstituent(kid, constituents, nextIndex);
        }
        Constituent<L> c = new Constituent<L>(tree.getLabel(), index, nextIndex - 1);
        constituents.put(tree, c);
        return nextIndex - index;
    }

    private static <L> int appendConstituent(Tree<L> tree, Collection<Constituent<L>> constituents, int index) {
        if (tree.isLeaf()) {
            Constituent<L> c = new Constituent<L>(tree.getLabel(), index, index);
            constituents.add(c);
            return 1;
        }
        int nextIndex = index;
        for (Tree<L> kid : tree.getChildren()) {
            nextIndex += Tree.appendConstituent(kid, constituents, nextIndex);
        }
        Constituent<L> c = new Constituent<L>(tree.getLabel(), index, nextIndex - 1);
        constituents.add(c);
        return nextIndex - index;
    }

    public List<Tree<L>> getTerminals() {
        ArrayList<Tree<L>> yield = new ArrayList<Tree<L>>();
        Tree.appendTerminals(this, yield);
        return yield;
    }

    private static <L> void appendTerminals(Tree<L> tree, List<Tree<L>> yield) {
        if (tree.isLeaf()) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendTerminals(child, yield);
        }
    }

    public Tree<L> shallowClone() {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        for (Tree<L> child : this.children) {
            newChildren.add(child.shallowClone());
        }
        return new Tree<L>(this.label, newChildren);
    }

    public Tree<L> shallowCloneJustRoot() {
        return new Tree<L>(this.label);
    }

    private static <L> void appendYield(Tree<L> tree, List<L> yield) {
        if (tree.isLeaf()) {
            yield.add(tree.getLabel());
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendYield(child, yield);
        }
    }

    public List<L> getPreTerminalYield() {
        ArrayList yield = new ArrayList();
        Tree.appendPreTerminalYield(this, yield);
        return yield;
    }

    public List<L> getTerminalYield() {
        List<Tree<L>> terms = this.getTerminals();
        ArrayList<L> yield = new ArrayList<L>();
        for (Tree<L> term : terms) {
            yield.add(term.getLabel());
        }
        return yield;
    }

    public List<Tree<L>> getPreTerminals() {
        ArrayList<Tree<L>> preterms = new ArrayList<Tree<L>>();
        Tree.appendPreTerminals(this, preterms);
        return preterms;
    }

    public List<Tree<L>> getTreesOfDepth(int depth) {
        ArrayList<Tree<L>> trees = new ArrayList<Tree<L>>();
        Tree.appendTreesOfDepth(this, trees, depth);
        return trees;
    }

    private static <L> void appendPreTerminalYield(Tree<L> tree, List<L> yield) {
        if (tree.isPreTerminal()) {
            yield.add(tree.getLabel());
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendPreTerminalYield(child, yield);
        }
    }

    private static <L> void appendPreTerminals(Tree<L> tree, List<Tree<L>> yield) {
        if (tree.isPreTerminal()) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendPreTerminals(child, yield);
        }
    }

    private static <L> void appendTreesOfDepth(Tree<L> tree, List<Tree<L>> yield, int depth) {
        if (tree.getDepth() == depth) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendTreesOfDepth(child, yield, depth);
        }
    }

    public List<Tree<L>> getPreOrderTraversal() {
        ArrayList<Tree<L>> traversal = new ArrayList<Tree<L>>();
        Tree.traversalHelper(this, traversal, true);
        return traversal;
    }

    public List<Tree<L>> getPostOrderTraversal() {
        ArrayList<Tree<L>> traversal = new ArrayList<Tree<L>>();
        Tree.traversalHelper(this, traversal, false);
        return traversal;
    }

    private static <L> void traversalHelper(Tree<L> tree, List<Tree<L>> traversal, boolean preOrder) {
        if (preOrder) {
            traversal.add(tree);
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.traversalHelper(child, traversal, preOrder);
        }
        if (!preOrder) {
            traversal.add(tree);
        }
    }

    public int getDepth() {
        int maxDepth = 0;
        for (Tree<L> child : this.children) {
            int depth = child.getDepth();
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth + 1;
    }

    public List<Tree<L>> getAtDepth(int depth) {
        ArrayList<Tree<L>> yield = new ArrayList<Tree<L>>();
        Tree.appendAtDepth(depth, this, yield);
        return yield;
    }

    private static <L> void appendAtDepth(int depth, Tree<L> tree, List<Tree<L>> yield) {
        if (depth < 0) {
            return;
        }
        if (depth == 0) {
            yield.add(tree);
            return;
        }
        for (Tree<L> child : tree.getChildren()) {
            Tree.appendAtDepth(depth - 1, child, yield);
        }
    }

    public void setLabel(L label) {
        this.label = label;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toStringBuilder(sb);
        return sb.toString();
    }

    public void toStringBuilder(StringBuilder sb) {
        if (!this.isLeaf()) {
            sb.append('(');
        }
        if (this.getLabel() != null) {
            sb.append(this.getLabel());
        }
        if (!this.isLeaf()) {
            for (Tree<L> child : this.getChildren()) {
                sb.append(' ');
                child.toStringBuilder(sb);
            }
            sb.append(')');
        }
    }

    public Tree(L label, List<Tree<L>> children) {
        this.label = label;
        this.children = children;
    }

    public Tree(L label) {
        this.label = label;
        this.children = Collections.emptyList();
    }

    public Set<Tree<L>> subTrees() {
        return (Set)this.subTrees(new HashSet<Tree<L>>());
    }

    public List<Tree<L>> subTreeList() {
        return (List)this.subTrees(new ArrayList<Tree<L>>());
    }

    public Collection<Tree<L>> subTrees(Collection<Tree<L>> n) {
        n.add(this);
        List<Tree<L>> kids = this.getChildren();
        for (Tree<L> kid : kids) {
            kid.subTrees(n);
        }
        return n;
    }

    @Override
    public Iterator<Tree<L>> iterator() {
        return new TreeIterator();
    }

    public <O> Tree<O> transformNodes(Method<L, O> trans) {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        for (Tree<L> child : this.children) {
            newChildren.add(child.transformNodes(trans));
        }
        return new Tree<O>(trans.call(this.label), newChildren);
    }

    public <O> Tree<O> transformNodesUsingNode(Method<Tree<L>, O> trans) {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        O newLabel = trans.call(this);
        for (Tree<L> child : this.children) {
            newChildren.add(child.transformNodesUsingNode(trans));
        }
        return new Tree<O>(newLabel, newChildren);
    }

    public <O> Tree<O> transformNodesUsingNodePostOrder(Method<Tree<L>, O> trans) {
        ArrayList<Tree<L>> newChildren = new ArrayList<Tree<L>>(this.children.size());
        for (Tree<L> child : this.children) {
            newChildren.add(child.transformNodesUsingNode(trans));
        }
        O newLabel = trans.call(this);
        return new Tree<O>(newLabel, newChildren);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        for (Tree<L> child : this.children) {
            result = 31 * result + (child == null ? 0 : child.hashCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof Tree)) {
            return false;
        }
        Tree other = (Tree)obj;
        if (!this.label.equals(other.label)) {
            return false;
        }
        if (this.getChildren().size() != other.getChildren().size()) {
            return false;
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            if (this.getChildren().get(i).equals(other.getChildren().get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Tree<L> o) {
        if (!(o.getLabel() instanceof Comparable) || !(this.getLabel() instanceof Comparable)) {
            throw new IllegalArgumentException("Tree labels are not comparable");
        }
        int cmp = ((Comparable)o.getLabel()).compareTo(this.getLabel());
        if (cmp != 0) {
            return cmp;
        }
        int cmp2 = Double.compare(this.getChildren().size(), o.getChildren().size());
        if (cmp2 != 0) {
            return cmp2;
        }
        for (int i = 0; i < this.getChildren().size(); ++i) {
            int cmp3 = this.getChildren().get(i).compareTo(o.getChildren().get(i));
            if (cmp3 == 0) continue;
            return cmp3;
        }
        return 0;
    }

    public boolean isPhrasal() {
        return this.getYield().size() > 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TreeIterator
    implements Iterator<Tree<L>> {
        private List<Tree<L>> treeStack = new ArrayList();

        private TreeIterator() {
            this.treeStack.add(Tree.this);
        }

        @Override
        public boolean hasNext() {
            return !this.treeStack.isEmpty();
        }

        @Override
        public Tree<L> next() {
            int lastIndex = this.treeStack.size() - 1;
            Tree tr = this.treeStack.remove(lastIndex);
            List kids = tr.getChildren();
            for (int i = kids.size() - 1; i >= 0; --i) {
                this.treeStack.add(kids.get(i));
            }
            return tr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

