/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.syntax.NamedTree;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.Filter;
import fig.basic.StrUtils;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trees {
    public static void main(String[] args) {
        String parse = "((S (NP (DT the) (JJ quick) (JJ brown) (NN fox)) (VP (VBD jumped) (PP (IN over) (NP (DT the) (JJ lazy) (NN dog)))) (. .)))";
        if (args.length > 0) {
            parse = StrUtils.join(args);
        }
        PennTreeReader reader = new PennTreeReader(new StringReader(parse));
        Object tree = reader.next();
        System.out.println(PennTreeRenderer.render(tree));
        System.out.println(tree);
        if (args.length == 0) {
            System.out.println("Testing robustness");
            String unbalanced1 = "((S (NP (DT the) (JJ quick) (JJ brown) (NN fox)) (VP (VBD jumped) (PP (IN over) (NP (DT the) (JJ lazy) (NN dog)))) (. .))";
            String unbalanced2 = "((S (NP (DT the) (JJ quick) (JJ brown) (NN fox))) (VP (VBD jumped) (PP (IN over) (NP (DT the) (JJ lazy) (NN dog)))) (. .)))";
            System.out.println("\nMissing a paren:");
            System.out.println(unbalanced1);
            System.out.println(PennTreeReader.parseEasy(unbalanced1, false));
            System.out.println("\nExtra paren:");
            System.out.println(unbalanced2);
            System.out.println(PennTreeReader.parseEasy(unbalanced2, false));
            String parens = "((S (NP (DT the) (SYM () (JJ quick) (JJ brown) (SYM )) (NN fox)) (VP (VBD jumped) (PP (IN over) (NP (DT the) (JJ lazy) (NN dog)))) (. .)))";
            System.out.println("\nParens as characters:");
            System.out.println(parens);
            System.out.println(PennTreeReader.parseEasy(parens, false));
        }
    }

    public static <L> Tree<L> spliceNodes(Tree<L> tree, Filter<L> filter) {
        return Trees.spliceNodes(tree, filter, true);
    }

    private static <L> Tree<L> spliceNodes(Tree<L> tree, Filter<L> filter, boolean splice) {
        List<Tree<L>> rootList = Trees.spliceNodesHelper(tree, filter, splice);
        if (rootList.size() > 1) {
            throw new IllegalArgumentException("spliceNodes: no unique root after splicing");
        }
        if (rootList.size() < 1) {
            return null;
        }
        return rootList.get(0);
    }

    public static <L> Tree<L> deleteNodes(Tree<L> tree, Filter<L> filter) {
        return Trees.spliceNodes(tree, filter, false);
    }

    public static <L> Tree<L> asTree(List<L> leaves, L root) {
        Tree t = new Tree(root);
        ArrayList children = new ArrayList();
        for (L leaf : leaves) {
            children.add(new Tree<L>(leaf));
        }
        t.setChildren(children);
        return t;
    }

    public static <T> Tree<String> stringTree(Tree<T> tree) {
        String root = tree.getLabel().toString();
        ArrayList children = new ArrayList();
        Tree<String> newTree = new Tree<String>(root, children);
        for (Tree<T> child : tree.getChildren()) {
            children.add(Trees.stringTree(child));
        }
        return newTree;
    }

    public static <T> Tree<T> truncateAtDepth(Tree<T> tree, int depth) {
        if (depth == 0) {
            return new Tree<T>(tree.getLabel());
        }
        ArrayList children = new ArrayList();
        Tree<T> newTree = new Tree<T>(tree.getLabel(), children);
        for (Tree<T> child : tree.getChildren()) {
            children.add(Trees.truncateAtDepth(child, depth - 1));
        }
        return newTree;
    }

    private static <L> List<Tree<L>> spliceNodesHelper(Tree<L> tree, Filter<L> filter, boolean splice) {
        ArrayList splicedChildren = new ArrayList();
        for (Tree<L> child : tree.getChildren()) {
            List<Tree<L>> splicedChildList = Trees.spliceNodesHelper(child, filter, splice);
            splicedChildren.addAll(splicedChildList);
        }
        if (filter.accept(tree.getLabel())) {
            return splice ? splicedChildren : new ArrayList();
        }
        Tree newTree = tree.shallowCloneJustRoot();
        newTree.setChildren(splicedChildren);
        return Collections.singletonList(newTree);
    }

    public static Tree<String> stripLeaves(Tree<String> tree) {
        if (tree.isLeaf()) {
            throw new RuntimeException("Can't strip leaves from " + tree.toString());
        }
        if (tree.getChildren().get(0).isLeaf()) {
            return new Tree<String>(tree.getLabel());
        }
        ArrayList children = new ArrayList();
        Tree<String> newTree = new Tree<String>(tree.getLabel());
        for (Tree<String> child : tree.getChildren()) {
            children.add(Trees.stripLeaves(child));
        }
        newTree.setChildren(children);
        return newTree;
    }

    public static <T> int getMaxBranchingFactor(Tree<T> tree) {
        int max = tree.getChildren().size();
        for (Tree<T> child : tree.getChildren()) {
            max = Math.max(max, Trees.getMaxBranchingFactor(child));
        }
        return max;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PennTreeRenderer {
        public static <L> String render(Tree<L> tree) {
            StringBuilder sb = new StringBuilder();
            PennTreeRenderer.renderTree(tree, 0, false, false, false, true, sb);
            sb.append('\n');
            return sb.toString();
        }

        private static <L> void renderTree(Tree<L> tree, int indent, boolean parentLabelNull, boolean firstSibling, boolean leftSiblingPreTerminal, boolean topLevel, StringBuilder sb) {
            boolean suppressIndent;
            boolean bl = suppressIndent = parentLabelNull || firstSibling && tree.isPreTerminal() || leftSiblingPreTerminal && tree.isPreTerminal() && (tree.getLabel() == null || !tree.getLabel().toString().startsWith("CC"));
            if (suppressIndent) {
                sb.append(' ');
            } else {
                if (!topLevel) {
                    sb.append('\n');
                }
                for (int i = 0; i < indent; ++i) {
                    sb.append("  ");
                }
            }
            if (tree.isLeaf() || tree.isPreTerminal()) {
                PennTreeRenderer.renderFlat(tree, sb);
                return;
            }
            sb.append('(');
            sb.append(tree.getLabel());
            PennTreeRenderer.renderChildren(tree.getChildren(), indent + 1, tree.getLabel() == null || tree.getLabel().toString() == null, sb);
            sb.append(')');
        }

        private static <L> void renderFlat(Tree<L> tree, StringBuilder sb) {
            if (tree.isLeaf()) {
                sb.append(tree.getLabel().toString());
                return;
            }
            sb.append('(');
            if (tree.getLabel() == null) {
                sb.append("<null>");
            } else {
                sb.append(tree.getLabel().toString());
            }
            sb.append(' ');
            sb.append(tree.getChildren().get(0).getLabel().toString());
            sb.append(')');
        }

        private static <L> void renderChildren(List<Tree<L>> children, int indent, boolean parentLabelNull, StringBuilder sb) {
            boolean firstSibling = true;
            boolean leftSibIsPreTerm = true;
            for (Tree<L> child : children) {
                PennTreeRenderer.renderTree(child, indent, parentLabelNull, firstSibling, leftSibIsPreTerm, false, sb);
                leftSibIsPreTerm = child.isPreTerminal();
                if (child.getLabel() != null && child.getLabel().toString().startsWith("CC")) {
                    leftSibIsPreTerm = false;
                }
                firstSibling = false;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PennTreeReader
    implements Iterator<Tree<String>> {
        public static String ROOT_LABEL = "ROOT";
        PushbackReader in;
        Tree<String> nextTree;
        int num = 0;
        int treeNum = 0;
        private boolean lowercase = false;
        private String name = "";
        private String currTreeName;

        @Override
        public boolean hasNext() {
            return this.nextTree != null;
        }

        @Override
        public Tree<String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Tree<String> tree = this.nextTree;
            this.nextTree = this.readRootTree();
            return tree;
        }

        private Tree<String> readRootTree() {
            this.currTreeName = this.name + ":" + this.treeNum;
            try {
                this.readWhiteSpace();
                if (!this.isLeftParen(this.peek())) {
                    return null;
                }
                ++this.treeNum;
                return this.readTree(true);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private Tree<String> readTree(boolean isRoot) throws IOException {
            this.readLeftParen();
            String label = this.readLabel();
            if (label.length() == 0 && isRoot) {
                label = ROOT_LABEL;
            }
            if (this.isRightParen(this.peek())) {
                this.readRightParen();
                return new Tree<String>(label);
            }
            List children = this.readChildren();
            this.readRightParen();
            if (!this.lowercase || children.size() > 0) {
                return isRoot ? new NamedTree<String>(label, children, this.currTreeName) : new Tree<String>(label, children);
            }
            return isRoot ? new NamedTree<String>(label.toLowerCase().intern(), children, this.currTreeName) : new Tree<String>(label.toLowerCase().intern(), children);
        }

        private String readLabel() throws IOException {
            this.readWhiteSpace();
            return this.readText(false);
        }

        private String readText(boolean atLeastOne) throws IOException {
            StringBuilder sb = new StringBuilder();
            int ch = this.in.read();
            while (atLeastOne || !this.isWhiteSpace(ch) && !this.isLeftParen(ch) && !this.isRightParen(ch) && ch != -1) {
                sb.append((char)ch);
                ch = this.in.read();
                atLeastOne = false;
            }
            this.in.unread(ch);
            return sb.toString().intern();
        }

        private List<Tree<String>> readChildren() throws IOException {
            this.readWhiteSpace();
            ArrayList<Tree<String>> children = new ArrayList<Tree<String>>();
            while (!this.isRightParen(this.peek()) || children.size() == 0) {
                this.readWhiteSpace();
                if (this.isLeftParen(this.peek())) {
                    if (this.isTextParen()) {
                        children.add(this.readLeaf());
                    } else {
                        children.add(this.readTree(false));
                    }
                } else {
                    if (this.peek() == 65535) {
                        int peek = this.peek();
                        throw new RuntimeException("Unmatched parentheses in tree input.");
                    }
                    children.add(this.readLeaf());
                }
                this.readWhiteSpace();
            }
            return children;
        }

        private boolean isTextParen() throws IOException {
            int next = this.in.read();
            int postnext = this.in.read();
            boolean isText = this.isLeftParen(next) && this.isRightParen(postnext);
            this.in.unread(postnext);
            this.in.unread(next);
            return isText;
        }

        private int peek() throws IOException {
            int ch = this.in.read();
            this.in.unread(ch);
            return ch;
        }

        private Tree<String> readLeaf() throws IOException {
            String label = this.readText(true);
            if (this.lowercase) {
                label = label.toLowerCase();
            }
            return new Tree<String>(label.intern());
        }

        private void readLeftParen() throws IOException {
            this.readWhiteSpace();
            int ch = this.in.read();
            if (!this.isLeftParen(ch)) {
                throw new RuntimeException("Format error reading tree.");
            }
        }

        private void readRightParen() throws IOException {
            this.readWhiteSpace();
            int ch = this.in.read();
            if (!this.isRightParen(ch)) {
                throw new RuntimeException("Format error reading tree.");
            }
        }

        private void readWhiteSpace() throws IOException {
            int ch = this.in.read();
            while (this.isWhiteSpace(ch)) {
                ch = this.in.read();
            }
            this.in.unread(ch);
        }

        private boolean isWhiteSpace(int ch) {
            return ch == 32 || ch == 9 || ch == 12 || ch == 13 || ch == 10;
        }

        private boolean isLeftParen(int ch) {
            return ch == 40;
        }

        private boolean isRightParen(int ch) {
            return ch == 41;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public PennTreeReader(Reader in) {
            this(in, "", false);
        }

        public PennTreeReader(Reader in, String name) {
            this(in, name, false);
        }

        public PennTreeReader(Reader in, String name, boolean lowercase) {
            this.lowercase = lowercase;
            this.name = name;
            this.in = new PushbackReader(in, 2);
            this.nextTree = this.readRootTree();
        }

        public PennTreeReader(Reader in, boolean lowercase) {
            this(in, "", lowercase);
        }

        public static Tree<String> parseEasy(String treeString, boolean lowercase) {
            try {
                return PennTreeReader.parseHard(treeString, lowercase);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public static Tree<String> parseEasy(String treeString) {
            return PennTreeReader.parseEasy(treeString, false);
        }

        private static Tree<String> parseHard(String treeString, boolean lowercase) {
            StringReader sr = new StringReader(treeString);
            PennTreeReader reader = new PennTreeReader((Reader)sr, lowercase);
            return reader.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StandardTreeNormalizer
    implements TreeTransformer<String> {
        EmptyNodeStripper emptyNodeStripper = new EmptyNodeStripper();
        XOverXRemover<String> xOverXRemover = new XOverXRemover();
        FunctionNodeStripper functionNodeStripper = new FunctionNodeStripper();

        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            tree = this.functionNodeStripper.transformTree(tree);
            tree = this.emptyNodeStripper.transformTree(tree);
            tree = this.xOverXRemover.transformTree(tree);
            return tree;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CompoundTreeTransformer<T>
    implements TreeTransformer<T> {
        Collection<TreeTransformer<T>> transformers;

        public CompoundTreeTransformer(Collection<TreeTransformer<T>> transformers) {
            this.transformers = transformers;
        }

        public CompoundTreeTransformer() {
            this(new ArrayList<TreeTransformer<T>>());
        }

        public void addTransformer(TreeTransformer<T> transformer) {
            this.transformers.add(transformer);
        }

        @Override
        public Tree<T> transformTree(Tree<T> tree) {
            for (TreeTransformer<T> trans : this.transformers) {
                tree = trans.transformTree(tree);
            }
            return tree;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class XOverXRemover<E>
    implements TreeTransformer<E> {
        @Override
        public Tree<E> transformTree(Tree<E> tree) {
            E label = tree.getLabel();
            List<Tree<E>> children = tree.getChildren();
            while (children.size() == 1 && !children.get(0).isLeaf() && label.equals(children.get(0).getLabel())) {
                children = children.get(0).getChildren();
            }
            ArrayList transformedChildren = new ArrayList();
            for (Tree<E> child : children) {
                transformedChildren.add(this.transformTree(child));
            }
            return new Tree<E>(label, transformedChildren);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EmptyNodeStripper
    implements TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            String label = tree.getLabel();
            if (label.equals("-NONE-")) {
                return null;
            }
            if (tree.isLeaf()) {
                return new Tree<String>(label);
            }
            List<Tree<String>> children = tree.getChildren();
            ArrayList transformedChildren = new ArrayList();
            for (Tree<String> child : children) {
                Tree<String> transformedChild = this.transformTree(child);
                if (transformedChild == null) continue;
                transformedChildren.add(transformedChild);
            }
            if (transformedChildren.size() == 0) {
                return null;
            }
            return new Tree<String>(label, transformedChildren);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionNodeStripper
    implements TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            String transformedLabel = FunctionNodeStripper.transformLabel(tree);
            if (tree.isLeaf()) {
                return tree.shallowCloneJustRoot();
            }
            ArrayList transformedChildren = new ArrayList();
            for (Tree<String> child : tree.getChildren()) {
                transformedChildren.add(this.transformTree(child));
            }
            return new Tree<String>(transformedLabel, transformedChildren);
        }

        public static String transformLabel(Tree<String> tree) {
            String transformedLabel = tree.getLabel();
            int cutIndex = transformedLabel.indexOf(45);
            int cutIndex2 = transformedLabel.indexOf(61);
            int cutIndex3 = transformedLabel.indexOf(94);
            if (cutIndex3 > 0 && (cutIndex3 < cutIndex2 || cutIndex2 == -1)) {
                cutIndex2 = cutIndex3;
            }
            if (cutIndex2 > 0 && (cutIndex2 < cutIndex || cutIndex <= 0)) {
                cutIndex = cutIndex2;
            }
            if (cutIndex > 0 && !tree.isLeaf()) {
                transformedLabel = new String(transformedLabel.substring(0, cutIndex));
            }
            return transformedLabel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PunctuationStripper
    implements TreeTransformer<String> {
        @Override
        public Tree<String> transformTree(Tree<String> tree) {
            return Trees.spliceNodes(tree, new Filter<String>(){

                @Override
                public boolean accept(String t) {
                    return t.equals(".");
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface TreeTransformer<E> {
        public Tree<E> transformTree(Tree<E> var1);
    }
}

