/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Factory;
import edu.berkeley.nlp.util.Filter;
import edu.berkeley.nlp.util.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iterators {
    public static <T> void fillList(Iterator<T> it, List<T> lst) {
        while (it.hasNext()) {
            lst.add(it.next());
        }
    }

    public static <T> List<T> fillList(Iterator<T> it) {
        ArrayList lst = new ArrayList();
        Iterators.fillList(it, lst);
        return lst;
    }

    private Iterators() {
    }

    public static <T> Iterable<T> newIterable(final Iterator<T> it) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return it;
            }
        };
    }

    public static <T> Iterable<T> able(final Iterator<T> it) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return it;
            }
        };
    }

    public static <T> Iterator<T> thread(final Iterator<T> base) {
        return new Iterator<T>(){
            ArrayBlockingQueue<T> els = new ArrayBlockingQueue(2);
            private boolean finishedLoading = false;
            private boolean running = false;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    while (base.hasNext()) {
                        try {
                            els.put(base.next());
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    finishedLoading = true;
                }
            });

            @Override
            public boolean hasNext() {
                return !this.finishedLoading || !this.els.isEmpty();
            }

            @Override
            public T next() {
                if (!this.running) {
                    this.thread.start();
                }
                this.running = true;
                try {
                    return this.els.take();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> maxLengthIterator(final Iterator<T> base, final int max) {
        return new Iterator<T>(){
            int count = 0;

            @Override
            public boolean hasNext() {
                return base.hasNext() && this.count < max;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more elements");
                }
                ++this.count;
                return base.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <T> Iterator<T> filter(Iterator<T> iterator, Filter<T> filter) {
        return new FilteredIterator<T>(filter, iterator);
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> ... args) {
        Factory factory = new Factory<Iterator<T>>(){

            @Override
            public Iterator<T> newInstance(Object ... args) {
                return (Iterator)args[0];
            }
        };
        return new IteratorIterator(Arrays.asList(args).iterator(), factory);
    }

    public static <U> Iterator<U> oneItemIterator(final U item) {
        return new Iterator<U>(){
            boolean unused = true;

            @Override
            public boolean hasNext() {
                return this.unused;
            }

            @Override
            public U next() {
                this.unused = false;
                return item;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterator emptyIterator() {
        return new Iterator(){

            public boolean hasNext() {
                return false;
            }

            public Object next() {
                return null;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TransformingIterator<I, O>
    implements Iterator<O> {
        private Method<I, O> transformer;
        private Iterator<I> inputIterator;

        public TransformingIterator(Iterator<I> inputIterator, Method<I, O> transformer) {
            this.inputIterator = inputIterator;
            this.transformer = transformer;
        }

        @Override
        public boolean hasNext() {
            return this.inputIterator.hasNext();
        }

        @Override
        public O next() {
            return this.transformer.call(this.inputIterator.next());
        }

        @Override
        public void remove() {
            this.inputIterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FilteredIterator<T>
    implements Iterator<T> {
        Filter<T> filter;
        T next;
        private Iterator<T> base;

        public FilteredIterator(Filter<T> filter, Iterator<T> base) {
            this.filter = filter;
            this.base = base;
            this.loadNext();
        }

        public FilteredIterator(Filter<T> filter, Iterable<T> items) {
            this(filter, items.iterator());
        }

        private void loadNext() {
            this.next = null;
            while (this.next == null && this.base.hasNext()) {
                this.next = this.base.next();
                if (this.filter.accept(this.next)) continue;
                this.next = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            T old = this.next;
            this.loadNext();
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IteratorIterator<T>
    implements Iterator<T> {
        Iterator<T> current = null;
        Iterator keys;
        Factory<Iterator<T>> iterFactory;

        public IteratorIterator(Iterator keys, Factory<Iterator<T>> iterFactory) {
            this.keys = keys;
            this.iterFactory = iterFactory;
            this.current = this.getNextIterator();
        }

        private Iterator<T> getNextIterator() {
            Iterator<T> next = null;
            while (next == null && this.keys.hasNext()) {
                next = this.iterFactory.newInstance(this.keys.next());
                if (next.hasNext()) continue;
                next = null;
            }
            return next;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public T next() {
            T next = this.current.next();
            if (!this.current.hasNext()) {
                this.current = this.getNextIterator();
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Transform<S, T>
    implements Iterator<T> {
        private Iterator<S> base;

        public Transform(Iterator<S> base) {
            this.base = base;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public T next() {
            return this.transform(this.base.next());
        }

        protected abstract T transform(S var1);

        @Override
        public void remove() {
            this.base.remove();
        }
    }
}

