/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Lists {
    public static <T> ArrayList<T> newList(T ... args) {
        ArrayList<T> l = new ArrayList<T>();
        for (T arg : args) {
            l.add(arg);
        }
        return l;
    }

    public static <T> List<T> newListFromIterable(Iterable<T> iter) {
        if (iter instanceof List) {
            return (List)iter;
        }
        ArrayList<T> list = new ArrayList<T>();
        for (T el : iter) {
            list.add(el);
        }
        return list;
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        ArrayList<T> l = new ArrayList<T>(l1);
        l.addAll(l2);
        return l;
    }

    public static <T> void reverse(List<T> list) {
        ArrayList<T> temp = new ArrayList<T>();
        temp.addAll(list);
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            list.set(i, temp.get(len - i - 1));
        }
    }

    public static <T> List<T> subList(List<T> list, Set<Integer> indices) {
        ArrayList<T> l = new ArrayList<T>(indices.size());
        for (int i : indices) {
            l.add(list.get(i));
        }
        return l;
    }

    public static <T> void set(List<T> list, int index, T element) {
        int gap = index - list.size() + 1;
        while (gap-- > 0) {
            list.add(null);
        }
        list.set(index, element);
    }

    public static <T extends Comparable<T>> Comparator<List<T>> comparator(T example) {
        return new Comparator<List<T>>(){

            @Override
            public int compare(List<T> o1, List<T> o2) {
                for (int i = 0; i < o1.size(); ++i) {
                    Comparable c2;
                    if (i == o2.size()) {
                        return 1;
                    }
                    Comparable c1 = (Comparable)o1.get(i);
                    int r = c1.compareTo(c2 = (Comparable)o2.get(i));
                    if (r == 0) continue;
                    return r;
                }
                return o2.size() > o1.size() ? -1 : 0;
            }
        };
    }

    public static int min(List<Integer> list) {
        int min = Integer.MAX_VALUE;
        for (int i : list) {
            if (i >= min) continue;
            min = i;
        }
        return min;
    }

    public static int max(List<Integer> list) {
        int max = Integer.MIN_VALUE;
        for (int i : list) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }
}

