/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Counter;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityQueue<E>
implements Iterator<E>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    int size;
    int capacity;
    List<E> elements;
    double[] priorities;

    protected void grow(int newCapacity) {
        ArrayList<E> newElements = new ArrayList<E>(newCapacity);
        double[] newPriorities = new double[newCapacity];
        if (this.size > 0) {
            newElements.addAll(this.elements);
            System.arraycopy(this.priorities, 0, newPriorities, 0, this.priorities.length);
        }
        this.elements = newElements;
        this.priorities = newPriorities;
        this.capacity = newCapacity;
    }

    protected int parent(int loc) {
        return (loc - 1) / 2;
    }

    protected int leftChild(int loc) {
        return 2 * loc + 1;
    }

    protected int rightChild(int loc) {
        return 2 * loc + 2;
    }

    protected void heapifyUp(int loc) {
        if (loc == 0) {
            return;
        }
        int parent = this.parent(loc);
        if (this.priorities[loc] > this.priorities[parent]) {
            this.swap(loc, parent);
            this.heapifyUp(parent);
        }
    }

    protected void heapifyDown(int loc) {
        int max = loc;
        int leftChild = this.leftChild(loc);
        if (leftChild < this.size()) {
            double rightChildPriority;
            int rightChild;
            double leftChildPriority = this.priorities[leftChild];
            double priority = this.priorities[loc];
            if (leftChildPriority > priority) {
                max = leftChild;
            }
            if ((rightChild = this.rightChild(loc)) < this.size() && (rightChildPriority = this.priorities[this.rightChild(loc)]) > priority && rightChildPriority > leftChildPriority) {
                max = rightChild;
            }
        }
        if (max == loc) {
            return;
        }
        this.swap(loc, max);
        this.heapifyDown(max);
    }

    protected void swap(int loc1, int loc2) {
        double tempPriority = this.priorities[loc1];
        E tempElement = this.elements.get(loc1);
        this.priorities[loc1] = this.priorities[loc2];
        this.elements.set(loc1, this.elements.get(loc2));
        this.priorities[loc2] = tempPriority;
        this.elements.set(loc2, tempElement);
    }

    protected void removeFirst() {
        if (this.size < 1) {
            return;
        }
        this.swap(0, this.size - 1);
        --this.size;
        this.elements.remove(this.size);
        this.heapifyDown(0);
    }

    @Override
    public boolean hasNext() {
        return !this.isEmpty();
    }

    @Override
    public E next() {
        E first = this.peek();
        this.removeFirst();
        return first;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public E peek() {
        if (this.size() > 0) {
            return this.elements.get(0);
        }
        throw new NoSuchElementException();
    }

    public double getPriority() {
        if (this.size() > 0) {
            return this.priorities[0];
        }
        throw new NoSuchElementException();
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean add(E key, double priority) {
        if (this.size == this.capacity) {
            this.grow(2 * this.capacity + 1);
        }
        this.elements.add(key);
        this.priorities[this.size] = priority;
        this.heapifyUp(this.size);
        ++this.size;
        return true;
    }

    public String toString() {
        return this.toString(this.size());
    }

    public String toString(int maxKeysToPrint) {
        int numKeysPrinted;
        Object pq = this.clone();
        StringBuilder sb = new StringBuilder("[");
        NumberFormat f = NumberFormat.getInstance();
        f.setMaximumFractionDigits(5);
        for (numKeysPrinted = 0; numKeysPrinted < maxKeysToPrint && ((PriorityQueue)pq).hasNext(); ++numKeysPrinted) {
            double priority = ((PriorityQueue)pq).getPriority();
            E element = ((PriorityQueue)pq).next();
            sb.append(element.toString());
            sb.append(" : ");
            sb.append(f.format(priority));
            if (numKeysPrinted >= this.size() - 1) continue;
            sb.append(", ");
        }
        if (numKeysPrinted < this.size()) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public Counter<E> asCounter() {
        Object pq = this.clone();
        Counter<E> counter = new Counter<E>();
        while (((PriorityQueue)pq).hasNext()) {
            double priority = ((PriorityQueue)pq).getPriority();
            E element = ((PriorityQueue)pq).next();
            counter.incrementCount(element, priority);
        }
        return counter;
    }

    public PriorityQueue<E> clone() {
        PriorityQueue<E> clonePQ = new PriorityQueue<E>();
        clonePQ.size = this.size;
        clonePQ.capacity = this.capacity;
        clonePQ.elements = new ArrayList(this.capacity);
        clonePQ.priorities = new double[this.capacity];
        if (this.size() > 0) {
            clonePQ.elements.addAll(this.elements);
            System.arraycopy(this.priorities, 0, clonePQ.priorities, 0, this.size());
        }
        return clonePQ;
    }

    public PriorityQueue() {
        this(15);
    }

    public PriorityQueue(int capacity) {
        int legalCapacity = 0;
        while (legalCapacity < capacity) {
            legalCapacity = 2 * legalCapacity + 1;
        }
        this.grow(legalCapacity);
    }

    public static void main(String[] args) {
        PriorityQueue<String> pq = new PriorityQueue<String>();
        System.out.println(pq);
        pq.add("one", 1.0);
        System.out.println(pq);
        pq.add("three", 3.0);
        System.out.println(pq);
        pq.add("one", 1.1);
        System.out.println(pq);
        pq.add("two", 2.0);
        System.out.println(pq);
        System.out.println(pq.toString(2));
        while (pq.hasNext()) {
            System.out.println((String)pq.next());
        }
    }
}

