/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.BigStatFig;
import fig.basic.Fmt;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullStatFig
extends BigStatFig {
    private ArrayList<Double> data = new ArrayList();

    public FullStatFig() {
    }

    public FullStatFig(Iterable<Double> c) {
        for (double x : c) {
            this.add(x);
        }
    }

    @Override
    public void add(double x) {
        super.add(x);
        this.data.add(x);
    }

    public double entropy() {
        double e = 0.0;
        for (double x : this.data) {
            if (!((x /= this.sum) > 0.0)) continue;
            e += -x * Math.log(x);
        }
        return e;
    }

    public double variance() {
        double v = 0.0;
        double m = this.mean();
        for (double x : this.data) {
            v += (x - m) * (x - m);
        }
        return v / (double)this.n;
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }

    public List<Double> getData() {
        return this.data;
    }

    public double[] computeAutocorrelation(int maxLag) {
        double mean = this.mean();
        double stddev = this.stddev();
        double[] normData = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            normData[i] = (this.data.get(i) - mean) / stddev;
        }
        double[] autocorrelations = new double[maxLag + 1];
        for (int lag = 0; lag <= maxLag; ++lag) {
            double sum = 0.0;
            int count = 0;
            int i = 0;
            while (i + lag < this.n) {
                sum += normData[i] * normData[i + lag];
                ++count;
                ++i;
            }
            autocorrelations[lag] = sum / (double)count;
        }
        return autocorrelations;
    }

    @Override
    public String toString() {
        return Fmt.D(this.min) + "/ << " + Fmt.D(this.mean()) + "~" + Fmt.D(this.stddev()) + " >> /" + Fmt.D(this.max) + " (" + this.n + ")";
    }
}

