/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

public class IntVec {
    private int[] data;
    private int n;

    public IntVec() {
        this.data = new int[0];
        this.n = 0;
    }

    public IntVec(int cap) {
        this.data = new int[cap];
        this.n = 0;
    }

    public IntVec(int[] data, int start, int end) {
        this.n = end - start;
        this.data = new int[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.data[i] = data[start + i];
        }
    }

    public IntVec(int[] data) {
        this.data = (int[])data.clone();
        this.n = data.length;
    }

    public int get(int i) {
        if (i >= this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.data[i];
    }

    public int set(int i, int x) {
        if (i >= this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data[i] = x;
        return x;
    }

    public int setGrow(int i, int x) {
        if (i >= this.n) {
            if (i >= this.data.length) {
                this.setCap((i + 1) * 2);
            }
            this.n = i + 1;
        }
        this.data[i] = x;
        return x;
    }

    public void add(int x) {
        this.setGrow(this.n, x);
    }

    public void multAll(int d) {
        int i = 0;
        while (i < this.n) {
            int n = i++;
            this.data[n] = this.data[n] * d;
        }
    }

    public void setCap(int cap) {
        if (cap < this.n) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] newData = new int[cap];
        System.arraycopy(this.data, 0, newData, 0, this.n);
        this.data = newData;
    }

    public void trimToSize() {
        this.setCap(this.n);
    }

    public int size() {
        return this.n;
    }

    public int hashCode() {
        int h = this.n;
        for (int i = 0; i < this.n; ++i) {
            h = h * 29 + this.data[i];
        }
        return h;
    }

    public boolean equals(Object o) {
        IntVec v = (IntVec)o;
        if (this.n != v.n) {
            return false;
        }
        for (int i = 0; i < this.n; ++i) {
            if (this.data[i] == v.data[i]) continue;
            return false;
        }
        return true;
    }

    public int[] getData() {
        return this.data;
    }
}

