/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.LogInfo;
import fig.basic.Pair;
import fig.basic.StrUtils;
import fig.basic.Utils;
import java.io.BufferedReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OptInfo {
    public String group;
    public String name;
    public String gloss;
    public String condReq;
    public boolean required;
    public boolean specified;
    public Object obj;
    public String stringRepn;
    public Field field;
    public Method setMethod;
    public Method getMethod;
    private static String errorValue = "ERROR";

    OptInfo() {
    }

    public String fullName() {
        return this.group + "." + this.name;
    }

    public String getEnumStr() {
        return OptInfo.getEnumStr(this.field != null ? this.field.getType() : this.getMethod.getReturnType());
    }

    public static String getEnumStr(Class c) {
        return StrUtils.join(c.getEnumConstants(), "|");
    }

    public Object getValue() {
        try {
            return this.field != null ? this.field.get(this.obj) : this.getMethod.invoke(this.obj, new Object[0]);
        }
        catch (InvocationTargetException e) {
            LogInfo.stderr.println("Can't access method: " + e);
            return null;
        }
        catch (IllegalAccessException e) {
            LogInfo.stderr.println("Can't access field: " + e);
            return null;
        }
    }

    public String getValueString() {
        if (this.stringRepn != null) {
            return this.stringRepn;
        }
        Object o = this.getValue();
        if (o == null) {
            return "";
        }
        if (o instanceof ArrayList) {
            return StrUtils.join((ArrayList)o);
        }
        if (o instanceof Pair) {
            return ((Pair)o).getFirst() + "," + ((Pair)o).getSecond();
        }
        if (OptInfo.objIsArray(o)) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < Array.getLength(o); ++i) {
                if (i > 0) {
                    buf.append(' ');
                }
                buf.append(Array.get(o, i));
            }
            return buf.toString();
        }
        if (o instanceof Random) {
            return "1";
        }
        return o.toString();
    }

    public String toString() {
        String valueStr = this.getValueString();
        String s = String.format("%-30s <%5s> : %s [%s]", this.fullName(), this.typeStr(), this.gloss, valueStr);
        String t = this.getEnumStr();
        if (!t.equals("")) {
            s = s + " " + t;
        }
        return s;
    }

    public void print() {
        LogInfo.stdout.println("  " + this.toString());
    }

    private Type getGenericType() {
        return this.field != null ? this.field.getGenericType() : this.getMethod.getGenericReturnType();
    }

    private String typeStr() {
        return OptInfo.typeStr(this.getGenericType());
    }

    private static boolean isEnum(Type type) {
        return type instanceof Class && ((Class)type).isEnum();
    }

    static boolean objIsArray(Object o) {
        return OptInfo.typeIsArray(o.getClass());
    }

    static boolean typeIsArray(Type t) {
        return t instanceof Class && ((Class)t).getComponentType() != null;
    }

    static Class arrayTypeOfObj(Object o) {
        return OptInfo.arrayTypeOfType(o.getClass());
    }

    static Class arrayTypeOfType(Type t) {
        return ((Class)t).getComponentType();
    }

    private static boolean isBool(Type type) {
        return type.equals(Boolean.TYPE) || type.equals(Boolean.class);
    }

    private static String typeStr(Type type) {
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            return "bool";
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return "int";
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            return "shrt";
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return "dbl";
        }
        if (type.equals(String.class)) {
            return "str";
        }
        if (type.equals(BufferedReader.class)) {
            return "read";
        }
        if (type.equals(Random.class)) {
            return "rand";
        }
        if (OptInfo.isEnum(type)) {
            return "enum";
        }
        if (OptInfo.typeIsArray(type)) {
            return OptInfo.typeStr(OptInfo.arrayTypeOfType(type)) + "*";
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            type = ptype.getRawType();
            Type[] childTypes = ptype.getActualTypeArguments();
            if (type.equals(ArrayList.class)) {
                return OptInfo.typeStr(childTypes[0]) + "*";
            }
            if (type.equals(Pair.class)) {
                return OptInfo.typeStr(childTypes[0]) + "2";
            }
        }
        return "unk";
    }

    private static boolean checkNumArgs(int want, int have, String fullName) {
        if (have != want) {
            LogInfo.stderr.printf(want + " arguments required for " + fullName + ", but got " + have + "\n", new Object[0]);
            return false;
        }
        return true;
    }

    private static Object interpretValue(Type type, List<String> l, String fullName) {
        String firstArg;
        int n = l.size();
        String string = firstArg = n > 0 ? l.get(0) : null;
        if (type.equals(Boolean.TYPE) || type.equals(Boolean.class)) {
            boolean x = n == 0 ? true : Boolean.parseBoolean(firstArg);
            return x;
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            if (!OptInfo.checkNumArgs(1, n, fullName)) {
                return errorValue;
            }
            int x = firstArg.equals("MAX") ? Integer.MAX_VALUE : (firstArg.equals("MIN") ? Integer.MIN_VALUE : Integer.parseInt(firstArg));
            return x;
        }
        if (type.equals(Short.TYPE) || type.equals(Short.class)) {
            if (!OptInfo.checkNumArgs(1, n, fullName)) {
                return errorValue;
            }
            int x = firstArg.equals("MAX") ? Short.MAX_VALUE : (firstArg.equals("MIN") ? Short.MIN_VALUE : (int)Short.parseShort(firstArg));
            return (short)x;
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            if (!OptInfo.checkNumArgs(1, n, fullName)) {
                return errorValue;
            }
            double x = firstArg.equals("MAX") ? Double.POSITIVE_INFINITY : (firstArg.equals("MIN") ? Double.NEGATIVE_INFINITY : Double.parseDouble(firstArg));
            return x;
        }
        if (type.equals(double[].class)) {
            double[] x = new double[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                x[i] = Double.parseDouble(l.get(i));
            }
            return x;
        }
        if (type.equals(String[].class)) {
            String[] x = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                x[i] = l.get(i);
            }
            return x;
        }
        if (type.equals(String.class)) {
            String x = StrUtils.join(l);
            return x;
        }
        if (type.equals(BufferedReader.class)) {
            if (!OptInfo.checkNumArgs(1, n, fullName)) {
                return errorValue;
            }
            BufferedReader x = "-".equals(firstArg) ? LogInfo.stdin : IOUtils.openInHard(firstArg);
            return x;
        }
        if (type.equals(Random.class)) {
            if (!OptInfo.checkNumArgs(1, n, fullName)) {
                return errorValue;
            }
            int seed = Integer.parseInt(firstArg);
            Random x = seed == 0 ? new Random() : new Random(seed);
            return x;
        }
        if (type instanceof Class && ((Class)type).isEnum()) {
            if (n == 0) {
                return null;
            }
            if (!OptInfo.checkNumArgs(1, n, fullName)) {
                return errorValue;
            }
            Object x = Utils.parseEnum((Class)type, firstArg);
            if (x == null) {
                LogInfo.stderr.println("Invalid enum: '" + firstArg + "'; valid choices: " + OptInfo.getEnumStr((Class)type));
                return errorValue;
            }
            return x;
        }
        if (OptInfo.typeIsArray(type)) {
            Class childType = OptInfo.arrayTypeOfType(type);
            Object x = Array.newInstance(childType, l.size());
            int i = 0;
            for (String a : l) {
                Object o = OptInfo.interpretValue(childType, ListUtils.newList(a), fullName);
                if (o == errorValue) {
                    return errorValue;
                }
                Array.set(x, i++, o);
            }
            return x;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType ptype = (ParameterizedType)type;
            type = ptype.getRawType();
            Type[] childTypes = ptype.getActualTypeArguments();
            if (type.equals(Pair.class)) {
                if (!OptInfo.checkNumArgs(1, n, fullName)) {
                    return errorValue;
                }
                String[] tokens = firstArg.split(",", 2);
                if (tokens.length != 2) {
                    LogInfo.stderr.println("Invalid pair: '" + firstArg + "'");
                    return errorValue;
                }
                Object o1 = OptInfo.interpretValue(childTypes[0], ListUtils.newList(tokens[0]), fullName);
                if (o1 == errorValue) {
                    return errorValue;
                }
                Object o2 = OptInfo.interpretValue(childTypes[1], ListUtils.newList(tokens[1]), fullName);
                if (o2 == errorValue) {
                    return errorValue;
                }
                return new Pair<Object, Object>(o1, o2);
            }
            if (type.equals(List.class) || type.equals(ArrayList.class)) {
                ArrayList<Object> x = new ArrayList<Object>();
                for (String a : l) {
                    Object o = OptInfo.interpretValue(childTypes[0], ListUtils.newList(a), fullName);
                    if (o == errorValue) {
                        return errorValue;
                    }
                    x.add(o);
                }
                return x;
            }
        }
        if (type instanceof Class) {
            try {
                Constructor con = ((Class)type).getConstructor(String.class);
                return con.newInstance(StrUtils.join(l));
            }
            catch (Exception e) {
                LogInfo.stderr.println("Failed to construct " + type + ": " + e);
                e.printStackTrace();
                return errorValue;
            }
        }
        LogInfo.stderr.println("Can't handle weird field type: " + type);
        return errorValue;
    }

    private void setField(Object v) throws IllegalAccessException, InvocationTargetException {
        if (!this.tryToUseSetters(v)) {
            if (this.field != null) {
                this.field.set(this.obj, v);
            } else {
                this.setMethod.invoke(this.obj, v);
            }
        }
    }

    private boolean tryToUseSetters(Object v) {
        Method[] methods;
        if (this.field == null) {
            return false;
        }
        String targetMethodName = "set" + this.field.getName();
        for (Method m : methods = this.obj.getClass().getMethods()) {
            String methodName = m.getName().toLowerCase();
            if (!methodName.equalsIgnoreCase(targetMethodName)) continue;
            try {
                m.invoke(this.obj, v);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean set(List<String> l, boolean append) {
        try {
            Object v = OptInfo.interpretValue(this.getGenericType(), l, this.fullName());
            if (v == errorValue) {
                return false;
            }
            if (!append) {
                this.stringRepn = OptInfo.isBool(this.getGenericType()) ? v.toString() : StrUtils.join(l);
                this.setField(v);
            } else {
                Object oldv = this.field.get(this.obj);
                this.stringRepn = (this.stringRepn == null ? "" : this.stringRepn + " ") + StrUtils.join(l);
                if (oldv instanceof ArrayList) {
                    ((ArrayList)oldv).addAll((ArrayList)v);
                } else if (oldv instanceof String) {
                    this.setField((oldv == null ? "" : (String)oldv + " ") + v);
                }
            }
        }
        catch (InvocationTargetException e) {
            LogInfo.stderr.println("Can't set method: " + e);
            return false;
        }
        catch (IllegalAccessException e) {
            LogInfo.stderr.println("Can't set field: " + e);
            return false;
        }
        this.specified = true;
        return true;
    }
}

