/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.Exceptions;
import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.LogInfo;
import fig.basic.OptInfo;
import fig.basic.Option;
import fig.basic.OptionSet;
import fig.basic.OrderedStringMap;
import fig.basic.StrUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsParser {
    private HashMap<String, Object> objects = new HashMap();
    private ArrayList<OptInfo> options;
    private String defaultDirFileName;
    private String ignoreOptsFileName;
    private List<String> ignoreFileNameOpts;
    private boolean relaxRequired;
    private boolean ignoreUnknownOpts;
    private boolean mustMatchFullName;
    @Deprecated
    public static final OptionsParser theParser = new OptionsParser();

    public OptionsParser() {
    }

    public OptionsParser(Object ... objects) {
        this.doRegisterAll(objects);
    }

    public OptionsParser doRegister(String group, Object o) {
        OptionSet ann;
        if (this.objects.containsKey(group)) {
            throw Exceptions.bad("Group name already exists: " + group);
        }
        this.objects.put(group, o);
        for (Field field : OptionsParser.classOf(o).getFields()) {
            ann = field.getAnnotation(OptionSet.class);
            if (ann == null) continue;
            try {
                this.doRegister(group + "." + ann.name(), field.get(o));
            }
            catch (IllegalAccessException e) {
                throw Exceptions.bad("Can't access field: " + e);
            }
        }
        for (AccessibleObject accessibleObject : OptionsParser.classOf(o).getMethods()) {
            ann = ((Method)accessibleObject).getAnnotation(OptionSet.class);
            if (ann == null) continue;
            try {
                this.doRegister(group + "." + ann.name(), ((Method)accessibleObject).invoke(o, new Object[0]));
            }
            catch (InvocationTargetException e) {
                throw Exceptions.bad("Can't access method: " + e);
            }
            catch (IllegalAccessException e) {
                throw Exceptions.bad("Can't access method: " + e);
            }
        }
        return this;
    }

    public OptionsParser doRegisterAll(Object[] objects) {
        String name = null;
        for (Object o : objects) {
            if (o == null) continue;
            if (o instanceof String) {
                name = (String)o;
                continue;
            }
            if (name == null) {
                name = o instanceof Class ? ((Class)o).getSimpleName() : o.getClass().getSimpleName();
            }
            this.doRegister(name, o);
            name = null;
        }
        return this;
    }

    @Deprecated
    public static void register(String group, Object o) {
        theParser.doRegister(group, o);
    }

    @Deprecated
    public static void registerAll(Object[] objects) {
        theParser.doRegisterAll(objects);
    }

    private static Class classOf(Object o) {
        return o instanceof Class ? (Class<?>)o : o.getClass();
    }

    private List<OptInfo> matchOpt(ArrayList<OptInfo> options, String s, boolean allowMultipleMatches) {
        s = s.toLowerCase();
        ArrayList<OptInfo> completeMatches = new ArrayList<OptInfo>();
        ArrayList<OptInfo> partialMatches = new ArrayList<OptInfo>();
        for (OptInfo opt : options) {
            String t = opt.fullName().toLowerCase();
            if (t.equals(s)) {
                completeMatches.add(opt);
            }
            if (t.startsWith(s)) {
                partialMatches.add(opt);
            }
            if (this.mustMatchFullName) continue;
            t = opt.name.toLowerCase();
            if (t.equals(s)) {
                completeMatches.add(opt);
            }
            if (!t.startsWith(s)) continue;
            partialMatches.add(opt);
        }
        if (completeMatches.size() + partialMatches.size() == 0) {
            if (!this.ignoreUnknownOpts) {
                LogInfo.stderr.println("Unknown option: '" + s + "'; -help for usage");
            }
            return ListUtils.newList(new OptInfo[0]);
        }
        if (allowMultipleMatches) {
            return partialMatches;
        }
        if (completeMatches.size() == 1) {
            return ListUtils.newList((OptInfo)completeMatches.get(0));
        }
        if (completeMatches.size() == 0 && partialMatches.size() == 1) {
            return ListUtils.newList(partialMatches.get(0));
        }
        LogInfo.stderr.println("Ambiguous option: '" + s + "'; possible matches:");
        for (OptInfo opt : partialMatches) {
            opt.print();
        }
        return ListUtils.newList(new OptInfo[0]);
    }

    private static void printHelp(List<OptInfo> options) {
        LogInfo.stdout.println("Usage:");
        for (OptInfo opt : options) {
            opt.print();
        }
    }

    public void printHelp() {
        OptionsParser.printHelp(this.options);
    }

    private ArrayList<OptInfo> getOptInfos() {
        ArrayList<OptInfo> options = new ArrayList<OptInfo>();
        for (String group : this.objects.keySet()) {
            Object obj = this.objects.get(group);
            for (Field field : OptionsParser.classOf(obj).getFields()) {
                Option ann = field.getAnnotation(Option.class);
                if (ann == null) continue;
                OptInfo opt = new OptInfo();
                opt.group = group;
                opt.name = ann.name().equals("") ? field.getName() : ann.name();
                opt.gloss = ann.gloss();
                opt.condReq = ann.condReq();
                opt.required = ann.required();
                opt.obj = obj;
                opt.field = field;
                options.add(opt);
            }
            HashMap<String, OptInfo> optMap = new HashMap<String, OptInfo>();
            for (Method method : OptionsParser.classOf(obj).getMethods()) {
                Option ann = method.getAnnotation(Option.class);
                if (ann == null) continue;
                String getterName = method.getName().replace("_$eq", "");
                OptInfo opt = (OptInfo)optMap.get(getterName);
                if (opt == null) {
                    opt = new OptInfo();
                    opt.group = group;
                    opt.name = ann.name().equals("") ? method.getName() : ann.name();
                    opt.gloss = ann.gloss();
                    opt.condReq = ann.condReq();
                    opt.required = ann.required();
                    opt.obj = obj;
                    options.add(opt);
                    optMap.put(getterName, opt);
                }
                if (method.getName().endsWith("_$eq")) {
                    opt.setMethod = method;
                    continue;
                }
                opt.getMethod = method;
            }
        }
        for (OptInfo opt : options) {
            if (opt.field != null || opt.getMethod != null && opt.setMethod != null) continue;
            System.err.printf("%s must have either field or a getter/setter pair (probably missing setter; use var instead of val in Scala)\n", opt.fullName());
        }
        return options;
    }

    private boolean readOptionsFile(ArrayList<OptInfo> options, String file) {
        if (new File(file).isDirectory()) {
            file = new File(file, this.defaultDirFileName).toString();
        }
        boolean ignoreOpts = new File(file).getName().equals(this.ignoreOptsFileName);
        try {
            String line;
            BufferedReader in = IOUtils.openIn(file);
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String[] tokens = line.split("\\s+", 2);
                String key = tokens[0];
                String val = tokens.length > 1 ? tokens[1] : "";
                boolean append = false;
                if (key.startsWith("+")) {
                    append = true;
                    key = key.substring(1);
                }
                if (key.equals("!include")) {
                    if (this.readOptionsFile(options, val)) continue;
                    return false;
                }
                for (OptInfo opt : this.matchOpt(options, key, false)) {
                    if (ignoreOpts && this.ignoreFileNameOpts.contains(opt.fullName()) || opt.set(Arrays.asList(StrUtils.split(val)), append)) continue;
                    return false;
                }
            }
        }
        catch (IOException e) {
            LogInfo.stderr.println(e);
            return false;
        }
        return true;
    }

    public boolean parseOptionsFile(String path) {
        ArrayList<OptInfo> options = this.getOptInfos();
        return this.readOptionsFile(options, path);
    }

    private static boolean isStrictPrefixOf(String x, String ... ys) {
        for (String y : ys) {
            if (!x.startsWith(y) || x.length() <= y.length()) continue;
            return true;
        }
        return false;
    }

    private static String stripDashes(String s) {
        int i;
        for (i = 0; i < s.length() && (s.charAt(i) == '-' || s.charAt(i) == '+'); ++i) {
        }
        return s.substring(i);
    }

    @Deprecated
    public static boolean parse(String[] args) {
        return theParser.doParse(args);
    }

    public void doParseHard(String[] args) {
        if (!this.doParse(args)) {
            throw new RuntimeException("Parsing '" + StrUtils.join(args) + "' failed");
        }
    }

    public boolean doParse(String[] args) {
        if (this.options == null) {
            this.options = this.getOptInfos();
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                OptionsParser.printHelp(this.options);
                ++i;
                return false;
            }
            if (OptionsParser.isStrictPrefixOf(args[i], "++")) {
                if (this.readOptionsFile(this.options, args[i++].substring(2)) || this.ignoreUnknownOpts) continue;
                return false;
            }
            if (OptionsParser.isStrictPrefixOf(args[i], "-", "+", "--")) {
                boolean append = args[i].startsWith("+");
                boolean allowMultipleMatches = args[i].startsWith("--");
                List<OptInfo> opts = this.matchOpt(this.options, OptionsParser.stripDashes(args[i++]), allowMultipleMatches);
                ArrayList<String> l = new ArrayList<String>();
                boolean nextIsVerbatim = false;
                boolean allIsVerbatim = false;
                while (i < args.length) {
                    if (args[i].equals("--")) {
                        nextIsVerbatim = true;
                    } else if (args[i].equals("---")) {
                        allIsVerbatim = !allIsVerbatim;
                    } else {
                        if (!allIsVerbatim && !nextIsVerbatim && OptionsParser.isStrictPrefixOf(args[i], "+", "-", "++")) break;
                        l.add(args[i]);
                        nextIsVerbatim = false;
                    }
                    ++i;
                }
                if (opts.size() == 0 && !this.ignoreUnknownOpts) {
                    return false;
                }
                for (OptInfo opt : opts) {
                    if (opt.set(l, append) || this.ignoreUnknownOpts) continue;
                    return false;
                }
                continue;
            }
            LogInfo.stderr.println("Argument not part of an option: " + args[i]);
            if (this.ignoreUnknownOpts) continue;
            return false;
        }
        if (!this.relaxRequired) {
            ArrayList<String> missingOptMsgs = new ArrayList<String>();
            for (OptInfo o : this.options) {
                String msg = this.isMissing(o, this.options);
                if (msg == null) continue;
                missingOptMsgs.add(msg);
            }
            if (missingOptMsgs.size() > 0) {
                LogInfo.stderr.println("Missing required option(s):");
                for (String msg : missingOptMsgs) {
                    LogInfo.stderr.println(msg);
                }
                return false;
            }
        }
        return true;
    }

    private OptInfo findOptInfo(List<OptInfo> optInfos, String name, String group) {
        for (OptInfo info : optInfos) {
            if (!info.fullName().equals(name)) continue;
            return info;
        }
        name = group + "." + name;
        for (OptInfo info : optInfos) {
            if (!info.fullName().equals(name)) continue;
            return info;
        }
        return null;
    }

    private String isMissing(OptInfo o, List<OptInfo> optInfos) {
        if (o.specified) {
            return null;
        }
        if (o.required) {
            return o.toString();
        }
        if (!StrUtils.isEmpty(o.condReq)) {
            String[] tokens = o.condReq.split("=", 2);
            String name = tokens[0];
            String value = tokens.length == 2 ? tokens[1] : null;
            OptInfo info = this.findOptInfo(optInfos, name, o.group);
            if (info == null) {
                return o.toString() + ", " + name + " not found";
            }
            if (value == null) {
                if (info.specified) {
                    return o.toString() + ", " + name + " specified";
                }
            } else if (info.getValue() instanceof ArrayList) {
                for (Object x : (ArrayList)info.getValue()) {
                    if (!x.toString().matches(value)) continue;
                    return o.toString() + ", " + o.condReq + " holds";
                }
            } else if (info.getValueString().matches(value)) {
                return o.toString() + ", " + o.condReq + " holds";
            }
        }
        return null;
    }

    @Deprecated
    public static OrderedStringMap getOptionStrings() {
        return theParser.doGetOptionStrings();
    }

    public OrderedStringMap doGetOptionStrings() {
        if (this.options == null) {
            this.options = this.getOptInfos();
        }
        OrderedStringMap map = new OrderedStringMap();
        for (OptInfo opt : this.options) {
            map.put(opt.toString());
        }
        return map;
    }

    @Deprecated
    public static OrderedStringMap getOptionPairs() {
        return theParser.doGetOptionPairs();
    }

    public OrderedStringMap doGetOptionPairs() {
        if (this.options == null) {
            this.options = this.getOptInfos();
        }
        OrderedStringMap map = new OrderedStringMap();
        for (OptInfo opt : this.options) {
            map.put(opt.fullName(), opt.getValueString());
        }
        return map;
    }

    public boolean writeEasy(String path) {
        return this.doGetOptionPairs().printEasy(path);
    }

    public OptionsParser setDefaultDirFileName(String defaultDirFileName) {
        this.defaultDirFileName = defaultDirFileName;
        return this;
    }

    public OptionsParser setIgnoreOptsFromFileName(String ignoreOptsFileName, List<String> ignoreFileNameOpts) {
        this.ignoreOptsFileName = ignoreOptsFileName;
        this.ignoreFileNameOpts = ignoreFileNameOpts;
        return this;
    }

    public OptionsParser relaxRequired() {
        this.relaxRequired = true;
        return this;
    }

    public OptionsParser ignoreUnknownOpts() {
        this.ignoreUnknownOpts = true;
        return this;
    }

    public OptionsParser mustMatchFullName() {
        this.mustMatchFullName = true;
        return this;
    }
}

