/*
 * Decompiled with CFR 0.152.
 */
package fig.exec;

import fig.basic.CharEncUtils;
import fig.basic.ClassInitializer;
import fig.basic.Exceptions;
import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OptionsParser;
import fig.basic.OrderedStringMap;
import fig.basic.StopWatchSet;
import fig.basic.StrUtils;
import fig.basic.SysInfoUtils;
import fig.basic.Utils;
import fig.exec.MonitorThread;
import fig.record.Record;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;

public class Execution {
    @Option(gloss="Whether to create a directory for this run; if not, don't generate output files")
    public static boolean create = false;
    @Option(gloss="Whether to create a thread to monitor the status.")
    public static boolean monitor = false;
    @Option(gloss="Directory to put all output files; if blank, use execPoolDir.")
    public static String execDir;
    @Option(gloss="Directory which contains all the executions (or symlinks).")
    public static String execPoolDir;
    @Option(gloss="Directory which actually holds the executions.")
    public static String actualExecPoolDir;
    @Option(gloss="Overwrite the contents of the execDir if it doesn't exist (e.g., when running a thunk).")
    public static boolean overwriteExecDir;
    @Option(gloss="Assume in the run directory, automatically set execPoolDir and actualExecPoolDir")
    public static boolean useStandardExecPoolDirStrategy;
    @Option(gloss="Simply print options and exit.")
    public static boolean printOptionsAndExit;
    @Option(gloss="Miscellaneous options (written to options.map and output.map, displayed in servlet); example: a=3 b=4")
    public static ArrayList<String> miscOptions;
    @Option(gloss="Name of the view to add this execution to in the servlet")
    public static ArrayList<String> addToView;
    @Option(gloss="Record file to write to")
    public static String recordPath;
    @Option(gloss="Character encoding")
    public static String charEncoding;
    @Option(gloss="Name of jar files to load prior to execution")
    public static ArrayList<String> jarFiles;
    @Option(gloss="Skip initialization of jars")
    public static boolean dontInitializeJars;
    @Option(gloss="Initialize from jars after copying them to a newly created execDir")
    public static boolean initializeJarsAfterDirCreation;
    @Option(gloss="Make a thunk (a delayed computation).")
    public static boolean makeThunk;
    @Option(gloss="A note to the servlet to automatically run the thunk when it sees it")
    public static boolean thunkAutoQueue;
    @Option(gloss="Priority of the thunk.")
    public static int thunkPriority;
    @Option(gloss="Launch this class")
    public static String thunkMainClassName;
    @Option(gloss="Java options to pass to Java when later running the thunk")
    public static String thunkJavaOpts;
    @Option(gloss="Use Scala to run rather than Java")
    public static boolean thunkUseScala;
    @Option(gloss="Use Scala to run rather than Java (in MB)")
    public static int thunkReqMemory;
    @Option(gloss="Whether to catch exceptions (ignored when making a thunk)")
    public static boolean dontCatchExceptions;
    public static boolean startMainTrack;
    private static String virtualExecDir;
    public static boolean ignoreUnknownOpts;
    static OrderedStringMap inputMap;
    private static OrderedStringMap outputMap;
    private static OptionsParser parser;
    private static MonitorThread monitorThread;
    static int exitCode;
    static boolean shouldBail;

    public static boolean shouldBail() {
        return shouldBail;
    }

    private static void mkdirHard(File f) {
        if (!f.mkdir()) {
            LogInfo.stderr.println("Cannot create directory: " + f);
            System.exit(1);
        }
    }

    public static String getVirtualExecDir() {
        return virtualExecDir;
    }

    public static String createVirtualExecDir() {
        if (useStandardExecPoolDirStrategy) {
            execPoolDir = new File(SysInfoUtils.getcwd(), "state/execs").toString();
            actualExecPoolDir = new File(SysInfoUtils.getcwd(), "state/hosts/" + SysInfoUtils.getShortHostName()).toString();
            if (!new File(actualExecPoolDir).isDirectory()) {
                actualExecPoolDir = null;
            }
        }
        if (!StrUtils.isEmpty(execPoolDir) && !new File(execPoolDir).isDirectory()) {
            throw Exceptions.bad("Execution pool directory '" + execPoolDir + "' doesn't exist");
        }
        if (!StrUtils.isEmpty(actualExecPoolDir) && !new File(actualExecPoolDir).isDirectory()) {
            throw Exceptions.bad("Actual execution pool directory '" + actualExecPoolDir + "' doesn't exist");
        }
        if (!StrUtils.isEmpty(execDir)) {
            boolean exists = new File(execDir).isDirectory();
            if (exists && !overwriteExecDir) {
                throw Exceptions.bad("Directory already exists and overwrite flag is false");
            }
            if (!exists) {
                Execution.mkdirHard(new File(execDir));
            } else {
                String oldActualExecDir = Utils.systemGetStringOutputEasy("readlink " + execDir);
                if (oldActualExecDir == null) {
                    if (!StrUtils.isEmpty(actualExecPoolDir)) {
                        throw Exceptions.bad("The old execution directory was not created with actualExecPoolDir but now we want an actualExecPoolDir");
                    }
                } else {
                    oldActualExecDir = oldActualExecDir.trim();
                    if (StrUtils.isEmpty(actualExecPoolDir)) {
                        throw Exceptions.bad("The old execution directory was created with actualExecPoolDir but now we don't want an actualExecPoolDir");
                    }
                    File newActualExecDir = null;
                    int i = 0;
                    while ((newActualExecDir = new File(actualExecPoolDir, i + "a.exec")).exists()) {
                        ++i;
                    }
                    Utils.systemHard(String.format("mv %s %s", oldActualExecDir, newActualExecDir));
                    Utils.systemHard(String.format("ln -sf %s %s", newActualExecDir.getAbsolutePath(), execDir));
                }
            }
            virtualExecDir = execDir;
            return virtualExecDir;
        }
        HashSet<String> files = new HashSet<String>();
        for (String f : new File(execPoolDir).list()) {
            files.add(f);
        }
        int numFailures = 0;
        int i = 0;
        while (numFailures < 3) {
            File g;
            File f = new File(execPoolDir, i + ".exec");
            File file = g = StrUtils.isEmpty(actualExecPoolDir) ? null : new File(actualExecPoolDir, i + ".exec");
            if (!(files.contains(i + ".exec") || g != null && g.exists())) {
                if (g == null || g.equals(f)) {
                    Execution.mkdirHard(f);
                    virtualExecDir = f.toString();
                    return virtualExecDir;
                }
                if (Utils.createSymLink(g.getAbsolutePath(), f.getAbsolutePath())) {
                    Execution.mkdirHard(g);
                    virtualExecDir = f.toString();
                    return virtualExecDir;
                }
                LogInfo.stderr.println("Cannot create symlink from " + f + " to " + g);
                ++numFailures;
            }
            ++i;
        }
        throw Exceptions.bad("Failed many times to create execution directory");
    }

    public static String getFile(String file) {
        if (StrUtils.isEmpty(virtualExecDir)) {
            return null;
        }
        if (StrUtils.isEmpty(file)) {
            return null;
        }
        return new File(virtualExecDir, file).toString();
    }

    public static void linkFileToExec(String realFileName, String file) {
        if (StrUtils.isEmpty(realFileName) || StrUtils.isEmpty(file)) {
            return;
        }
        File f = new File(realFileName);
        Utils.createSymLink(f.getAbsolutePath(), Execution.getFile(file));
    }

    public static void linkFileFromExec(String file, String realFileName) {
        if (StrUtils.isEmpty(realFileName) || StrUtils.isEmpty(file)) {
            return;
        }
        File f = new File(realFileName);
        Utils.createSymLink(Execution.getFile(file), f.getAbsolutePath());
    }

    public static boolean getBooleanInput(String s) {
        String t = inputMap.get(s, "0");
        return t.equals("true") || t.equals("1");
    }

    public static String getInput(String s) {
        return (String)inputMap.get(s);
    }

    public static synchronized void putOutput(String s, Object t) {
        outputMap.put(s, StrUtils.toString(t));
    }

    public static synchronized void printOutputMapToStderr() {
        outputMap.print(LogInfo.stderr);
    }

    public static synchronized void printOutputMap(String path) {
        if (StrUtils.isEmpty(path)) {
            return;
        }
        String tmpPath = path + ".tmp";
        if (outputMap.printEasy(tmpPath)) {
            new File(tmpPath).renameTo(new File(path));
        }
    }

    public static void setExecStatus(String newStatus, boolean override) {
        String oldStatus = (String)outputMap.get("exec.status");
        if (oldStatus == null || oldStatus.equals("running")) {
            override = true;
        }
        if (override) {
            Execution.putOutput("exec.status", newStatus);
        }
    }

    public static void putLogRec(String key, Object value) {
        LogInfo.logss("%s = %s", key, value);
        Record.add(key, value);
        Execution.putOutput(key, value);
    }

    static OrderedStringMap getInfo() {
        OrderedStringMap map = new OrderedStringMap();
        map.put("Date", SysInfoUtils.getCurrentDateStr());
        map.put("Host", SysInfoUtils.getHostName());
        map.put("CPU speed", SysInfoUtils.getCPUSpeedStr());
        map.put("Max memory", SysInfoUtils.getMaxMemoryStr());
        map.put("Num CPUs", (Object)SysInfoUtils.getNumCPUs());
        return map;
    }

    public static void init(String[] args, Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof OptionsParser)) continue;
            parser = (OptionsParser)objects[i];
            objects[i] = null;
        }
        if (parser == null) {
            parser = new OptionsParser();
        }
        parser.doRegister("log", LogInfo.class);
        parser.doRegister("exec", Execution.class);
        parser.doRegisterAll(objects);
        parser.setDefaultDirFileName("options.map");
        parser.setIgnoreOptsFromFileName("options.map", ListUtils.newList("log.file", "exec.execDir", "exec.execPoolDir", "exec.actualPoolDir", "exec.makeThunk"));
        if (ignoreUnknownOpts) {
            parser.ignoreUnknownOpts();
        }
        if (!parser.doParse(args)) {
            System.exit(1);
        }
        if (!dontInitializeJars && !initializeJarsAfterDirCreation) {
            Execution.initializeJars(false);
        }
        if (charEncoding != null) {
            CharEncUtils.setCharEncoding(charEncoding);
        }
        if (printOptionsAndExit) {
            parser.doGetOptionPairs().print(LogInfo.stdout);
            System.exit(0);
        }
        if (create) {
            Execution.createVirtualExecDir();
            if (!makeThunk) {
                LogInfo.file = Execution.getFile("log");
            }
            if (!makeThunk) {
                for (String jarFile : jarFiles) {
                    Utils.systemHard(String.format("cp %s %s", jarFile, virtualExecDir));
                }
                if (initializeJarsAfterDirCreation) {
                    Execution.initializeJars(true);
                }
            }
        } else {
            LogInfo.file = "";
        }
        for (String opt : miscOptions) {
            String[] tokens = opt.split("=");
            if (tokens.length != 2) continue;
            Execution.putOutput(tokens[0], tokens[1]);
        }
        if (!makeThunk) {
            LogInfo.init();
            if (startMainTrack) {
                LogInfo.track((Object)"main()", true);
            }
        }
        if (!makeThunk && virtualExecDir != null) {
            LogInfo.logs("Execution directory: " + virtualExecDir);
        }
        if (!makeThunk) {
            Execution.getInfo().printEasy(Execution.getFile("info.map"));
        }
        Execution.printOptions();
        if (create && addToView.size() > 0) {
            IOUtils.printLinesHard(Execution.getFile("addToView"), addToView);
        }
        if (!makeThunk && monitor) {
            monitorThread = new MonitorThread();
            monitorThread.start();
        }
        if (!makeThunk) {
            Record.init(!StrUtils.isEmpty(recordPath) ? recordPath : Execution.getFile("record"));
        }
    }

    private static void initializeJars(boolean inVirtualExecDir) {
        if (jarFiles.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            for (String jarFile : jarFiles) {
                names.add(new File(jarFile).getName());
            }
            LogInfo.stderr.println("Loading JAR files: " + StrUtils.join(names));
            for (String jarFile : jarFiles) {
                String jarPath = inVirtualExecDir ? new File(virtualExecDir, new File(jarFile).getName()).getPath() : jarFile;
                ClassInitializer.initializeJar(jarPath);
            }
        }
    }

    public static void printOptions() {
        boolean saveMakeThunk = makeThunk;
        makeThunk = false;
        parser.doGetOptionPairs().printEasy(Execution.getFile("options.map"));
        makeThunk = saveMakeThunk;
    }

    public static void raiseException(Throwable t) {
        LogInfo.error(t + ":\n" + StrUtils.join(t.getStackTrace(), "\n"));
        t = t.getCause();
        if (t != null) {
            LogInfo.error("Caused by " + t + ":\n" + StrUtils.join(t.getStackTrace(), "\n"));
        }
        Execution.putOutput("exec.status", "exception");
        exitCode = 1;
    }

    public static void finish() {
        if (!makeThunk) {
            Record.finish();
            if (monitor) {
                monitorThread.finish();
            }
            Execution.setExecStatus(shouldBail ? "bailed" : "done", false);
            StopWatchSet.getStats().printEasy(Execution.getFile("time.map"));
            if (!makeThunk && virtualExecDir != null) {
                LogInfo.logs("Execution directory: " + virtualExecDir);
            }
            if (makeThunk && virtualExecDir != null) {
                LogInfo.stderr.println(virtualExecDir);
            }
            if (LogInfo.getNumErrors() > 0 || LogInfo.getNumWarnings() > 0) {
                LogInfo.stderr.printf("%d errors, %d warnings\n", LogInfo.getNumErrors(), LogInfo.getNumWarnings());
            }
            if (startMainTrack) {
                LogInfo.end_track();
            }
        }
        System.exit(exitCode);
    }

    public static void run(String[] args, Object ... objects) {
        Execution.runWithObjArray(args, objects);
    }

    public static void runWithObjArray(String[] args, Object[] objects) {
        Execution.init(args, objects);
        Object mainObj = objects[0] instanceof String ? objects[1] : objects[0];
        if (makeThunk) {
            Execution.setExecStatus("thunk", true);
            Execution.printOutputMap(Execution.getFile("output.map"));
            ArrayList<String> cmd = new ArrayList<String>();
            if (thunkUseScala) {
                cmd.add("env");
                if (thunkJavaOpts != null) {
                    cmd.add("'JAVA_OPTS=" + thunkJavaOpts + "'");
                }
                cmd.add("scala");
            } else {
                cmd.add("java");
                if (thunkJavaOpts != null) {
                    cmd.add(thunkJavaOpts);
                }
            }
            cmd.add("-cp " + StrUtils.join(jarFiles, ":") + ":" + System.getenv("CLASSPATH"));
            cmd.addAll(ListUtils.newList(thunkMainClassName == null ? mainObj.getClass().getName() : thunkMainClassName, "++" + virtualExecDir + "/options.map", "-execDir", virtualExecDir, "-overwriteExecDir"));
            IOUtils.printLinesHard(Execution.getFile("job.map"), ListUtils.newList("workingDir\t" + SysInfoUtils.getcwd(), "command\t" + StrUtils.join(cmd, "\t"), "reqMemory\t" + thunkReqMemory, "priority\t" + thunkPriority));
            System.out.println(virtualExecDir);
        } else if (dontCatchExceptions) {
            ((Runnable)mainObj).run();
        } else {
            try {
                ((Runnable)mainObj).run();
            }
            catch (Throwable t) {
                Execution.raiseException(t);
            }
        }
        Execution.finish();
    }

    static {
        useStandardExecPoolDirStrategy = false;
        printOptionsAndExit = false;
        miscOptions = new ArrayList();
        addToView = new ArrayList();
        jarFiles = new ArrayList();
        dontInitializeJars = false;
        initializeJarsAfterDirCreation = false;
        thunkUseScala = false;
        thunkReqMemory = 1024;
        startMainTrack = true;
        ignoreUnknownOpts = false;
        inputMap = new OrderedStringMap();
        outputMap = new OrderedStringMap();
        exitCode = 0;
        shouldBail = false;
    }
}

