/*
 * Decompiled with CFR 0.152.
 */
package fig.exec;

import fig.basic.LogInfo;
import fig.basic.StopWatch;
import fig.basic.StopWatchSet;
import fig.basic.SysInfoUtils;
import fig.basic.Utils;
import fig.exec.Execution;
import java.io.File;
import java.io.IOException;

class MonitorThread
implements Runnable {
    private static final int timeInterval = 300;
    private boolean stop = false;
    private Thread thread = new Thread(this);

    void processCommand(String cmd) {
        if ((cmd = cmd.trim()).equals("")) {
            Execution.getInfo().print(LogInfo.stderr);
            Execution.printOutputMapToStderr();
            StopWatchSet.getStats().print(LogInfo.stderr);
            LogInfo.stderr.println(Execution.getVirtualExecDir());
        } else {
            if (cmd.equals("kill")) {
                LogInfo.stderr.println("MonitorThread: KILLING");
                Execution.setExecStatus("killed", true);
                Execution.printOutputMap(Execution.getFile("output.map"));
                throw new RuntimeException("Killed by input command");
            }
            if (cmd.equals("bail")) {
                LogInfo.stderr.println("MonitorThread: BAILING OUT");
                Execution.shouldBail = true;
            } else {
                LogInfo.stderr.println("Invalid command: '" + cmd + "'");
            }
        }
    }

    void readAndProcessCommand() {
        try {
            int nBytes = System.in.available();
            if (nBytes > 0) {
                byte[] bytes = new byte[nBytes];
                System.in.read(bytes);
                String line = new String(bytes);
                this.processCommand(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void run() {
        try {
            while (!this.stop) {
                boolean killed;
                if (LogInfo.writeToStdout) {
                    this.readAndProcessCommand();
                }
                Execution.inputMap.readEasy(Execution.getFile("input.map"));
                boolean bl = killed = Execution.create && new File(Execution.getFile("kill")).exists();
                if (killed) {
                    Execution.setExecStatus("killed", true);
                }
                Execution.putOutput("log.note", LogInfo.note);
                Execution.putOutput("exec.memory", SysInfoUtils.getUsedMemoryStr());
                Execution.putOutput("exec.time", new StopWatch(LogInfo.getWatch().getCurrTimeLong()).toString());
                Execution.putOutput("exec.errors", "" + LogInfo.getNumErrors());
                Execution.putOutput("exec.warnings", "" + LogInfo.getNumWarnings());
                Execution.setExecStatus("running", false);
                Execution.printOutputMap(Execution.getFile("output.map"));
                if (killed) {
                    throw new RuntimeException("Killed by 'kill' file");
                }
                Utils.sleep(300);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void start() {
        this.thread.start();
    }

    public void finish() {
        this.stop = true;
        this.thread.interrupt();
    }
}

