/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.NumUtils;
import fig.prob.BetaInterface;
import fig.prob.DegenerateBeta;
import fig.prob.DirichletUtils;
import fig.prob.Distrib;
import fig.prob.Gamma;
import fig.prob.SuffStats;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Beta
implements BetaInterface {
    private double alpha;
    private double beta;

    public Beta(double alpha, double beta) {
        this.alpha = alpha;
        this.beta = beta;
    }

    public double logProb(double x) {
        return Beta.logProb(this.alpha, this.beta, x);
    }

    public static double logProb(double alpha, double beta, double x) {
        return NumUtils.logGamma(alpha + beta) - NumUtils.logGamma(alpha) - NumUtils.logGamma(beta) + (alpha - 1.0) * Math.log(x) + (beta - 1.0) * Math.log(1.0 - x);
    }

    @Override
    public double logProb(SuffStats stats) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double logProbObject(Double x) {
        return this.logProb(x);
    }

    public double sample(Random random) {
        return Beta.sample(random, this.alpha, this.beta);
    }

    public static double sample(Random random, double alpha, double beta) {
        double a = Gamma.sample(random, alpha, 1.0);
        double b = Gamma.sample(random, beta, 1.0);
        return a / (a + b);
    }

    @Override
    public Double sampleObject(Random random) {
        return this.sample(random);
    }

    @Override
    public double expectedLog(boolean b) {
        if (b) {
            return DirichletUtils.expectedLog(this.alpha, this.totalCount());
        }
        return DirichletUtils.expectedLog(this.beta, this.totalCount());
    }

    @Override
    public double crossEntropy(Distrib<Double> _that) {
        Beta that = (Beta)_that;
        double sum = 0.0;
        sum += DirichletUtils.thatTotalCountContrib(that.totalCount());
        sum += DirichletUtils.elementContrib(this.alpha, that.alpha, this.totalCount());
        return sum += DirichletUtils.elementContrib(this.beta, that.beta, this.totalCount());
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    @Override
    public double getBeta() {
        return this.beta;
    }

    @Override
    public double getMean() {
        return this.alpha / (this.alpha + this.beta);
    }

    @Override
    public double getMode() {
        if (this.alpha <= 1.0 || this.beta <= 1.0) {
            return this.alpha > this.beta ? 0.99999999 : 1.0E-8;
        }
        return (this.alpha - 1.0) / (this.alpha + this.beta - 2.0);
    }

    @Override
    public double totalCount() {
        return this.alpha + this.beta;
    }

    @Override
    public BetaInterface modeSpike() {
        return new DegenerateBeta(this.getMode());
    }

    public BetaInterface perturb(Random random) {
        double x = NumUtils.bound(this.sample(random), 1.0E-8, 0.99999999);
        return new Beta(this.totalCount() * x, this.totalCount() * (1.0 - x));
    }

    public BetaInterface degeneratePerturb(Random random) {
        return new DegenerateBeta(this.sample(random));
    }

    public String toString() {
        return String.format("Beta(%.3f,%.3f)", this.alpha, this.beta);
    }
}

