/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.NumUtils;
import fig.prob.DegenerateGamma;
import fig.prob.Distrib;
import fig.prob.GammaInterface;
import fig.prob.SampleUtils;
import fig.prob.SuffStats;
import java.io.Serializable;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gamma
implements GammaInterface,
Serializable {
    private static final long serialVersionUID = 42L;
    private double shape;
    private double rate;

    public Gamma(double shape, double rate) {
        this.shape = shape;
        this.rate = rate;
    }

    public double logProb(double x) {
        return this.shape * Math.log(this.rate) - NumUtils.logGamma(this.shape) + (NumUtils.equals(this.shape, 1.0) ? 0.0 : (this.shape - 1.0) * Math.log(x)) - this.rate * x;
    }

    @Override
    public double logProb(SuffStats stats) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public double logProbObject(Double x) {
        return this.logProb(x);
    }

    @Override
    public double getShape() {
        return this.shape;
    }

    @Override
    public double getRate() {
        return this.rate;
    }

    @Override
    public double getMean() {
        return this.shape / this.rate;
    }

    @Override
    public double getMode() {
        return Math.max((this.shape - 1.0) / this.rate, 1.0E-8);
    }

    public double getVar() {
        return this.shape / (this.rate * this.rate);
    }

    public double sample(Random random) {
        return Gamma.sample(random, this.shape, this.rate);
    }

    public static double sample(Random random, double shape, double rate) {
        return SampleUtils.sampleGamma(random, shape, rate);
    }

    @Override
    public Double sampleObject(Random random) {
        return this.sample(random);
    }

    @Override
    public double crossEntropy(Distrib<Double> _that) {
        Gamma that = (Gamma)_that;
        double sum = 0.0;
        sum += that.shape * Math.log(that.rate) - NumUtils.logGamma(that.shape);
        return sum += (NumUtils.equals(that.shape, 1.0) ? 0.0 : (that.shape - 1.0) * this.expectedLog()) - that.rate * this.getMean();
    }

    @Override
    public double expectedLog() {
        return NumUtils.digamma(this.shape) - Math.log(this.rate);
    }

    @Override
    public GammaInterface modeSpike() {
        return new DegenerateGamma(this.getMode());
    }

    public String toString() {
        return String.format("Gamma(%.3f,%.3f)", this.shape, this.rate);
    }
}

