/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.prob.Distrib;
import fig.prob.GaussianSuffStats;
import fig.prob.SampleUtils;
import fig.prob.SuffStats;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gaussian
implements Distrib<Double> {
    private double mean;
    private double var;
    public static final double LOG_INV_SQRT_2_PI = -Math.log(Math.sqrt(Math.PI * 2));

    public Gaussian(double mean, double var) {
        this.mean = mean;
        this.var = var;
    }

    public double logProb(double x) {
        return Gaussian.logProb(this.mean, this.var, x);
    }

    public static double logProb(double mean, double var, double x) {
        return -0.5 * (x - mean) * (x - mean) / var + LOG_INV_SQRT_2_PI - 0.5 * Math.log(var);
    }

    public static double logProb(double mean, double var, double sum, double sumSq, double n) {
        return -0.5 * (sumSq - 2.0 * mean * sum + mean * mean) / var + n * (LOG_INV_SQRT_2_PI - 0.5 * Math.log(var));
    }

    public static double logProb(double mean, double var, GaussianSuffStats stats) {
        return -0.5 * (stats.getSumSq() - 2.0 * mean * stats.getSum() + mean * mean) / var + stats.numPoints() * (LOG_INV_SQRT_2_PI - 0.5 * Math.log(var));
    }

    @Override
    public double logProb(SuffStats stats) {
        return Gaussian.logProb(this.mean, this.var, (GaussianSuffStats)stats);
    }

    @Override
    public double logProbObject(Double x) {
        return this.logProb(x);
    }

    public double sample(Random random) {
        return Gaussian.sample(random, this.mean, this.var);
    }

    public static double sample(Random random, double mean, double var) {
        return SampleUtils.sampleGaussian(random) * Math.sqrt(var) + mean;
    }

    @Override
    public Double sampleObject(Random random) {
        return this.sample(random);
    }

    @Override
    public double crossEntropy(Distrib<Double> _that) {
        Gaussian that = (Gaussian)_that;
        double sum = 0.0;
        sum += LOG_INV_SQRT_2_PI - 0.5 * Math.log(that.var);
        return sum += -1.0 / (2.0 * that.var) * (this.getSecondMoment() - 2.0 * this.getMean() * that.getMean() + that.getMean() * that.getMean());
    }

    public double getMean() {
        return this.mean;
    }

    public double getSecondMoment() {
        return this.var + this.mean * this.mean;
    }

    public double getVar() {
        return this.var;
    }

    public String toString() {
        return String.format("Gaussian(%.3f,%.3f^2)", this.mean, Math.sqrt(this.var));
    }
}

