/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.prob.Distrib;
import fig.prob.Gaussian;
import fig.prob.GaussianSuffStats;
import fig.prob.MargDistrib;
import fig.prob.SuffStats;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MargMeanGaussian
implements MargDistrib<Gaussian> {
    private Gaussian meanDistrib;
    private double varSpike;

    public MargMeanGaussian(Gaussian meanDistrib, double varSpike) {
        this.meanDistrib = meanDistrib;
        this.varSpike = varSpike;
    }

    private Gaussian getMeanPosterior(GaussianSuffStats stats) {
        double postVar;
        double postMean;
        double px = this.meanDistrib.getMean();
        double pv = this.meanDistrib.getVar();
        if (stats.numPoints() < 1.0E-200) {
            postMean = (pv * stats.getSum() + this.varSpike * px) / this.varSpike;
            postVar = pv;
        } else {
            double lx = stats.getSum() / stats.numPoints();
            double lv = this.varSpike / stats.numPoints();
            postMean = (pv * lx + lv * px) / (pv + lv);
            postVar = pv * lv / (pv + lv);
        }
        return new Gaussian(postMean, postVar);
    }

    @Override
    public MargMeanGaussian getPosterior(SuffStats stats) {
        return new MargMeanGaussian(this.getMeanPosterior((GaussianSuffStats)stats), this.varSpike);
    }

    @Override
    public double margLogLikelihood(SuffStats stats) {
        double sum = 0.0;
        sum += Gaussian.logProb(this.meanDistrib.getMean(), this.meanDistrib.getVar(), 0.0);
        sum += Gaussian.logProb(0.0, this.varSpike, (GaussianSuffStats)stats);
        return sum -= this.getMeanPosterior((GaussianSuffStats)stats).logProb(0.0);
    }

    @Override
    public double logProb(SuffStats stats) {
        return this.meanDistrib.logProb(stats);
    }

    @Override
    public double logProbObject(Gaussian distrib) {
        return this.meanDistrib.logProbObject(distrib.getMean());
    }

    @Override
    public double crossEntropy(Distrib<Gaussian> _that) {
        MargMeanGaussian that = (MargMeanGaussian)_that;
        return this.meanDistrib.crossEntropy(that.meanDistrib);
    }

    @Override
    public double predLogLikelihood(SuffStats condStats, SuffStats predStats) {
        return this.getPosterior((GaussianSuffStats)condStats).margLogLikelihood(predStats);
    }

    @Override
    public Gaussian sampleObject(Random random) {
        return new Gaussian(this.meanDistrib.sample(random), this.varSpike);
    }

    @Override
    public double expectedLogLikelihood(SuffStats _stats) {
        GaussianSuffStats stats = (GaussianSuffStats)_stats;
        double sum = 0.0;
        sum += stats.numPoints() * (Gaussian.LOG_INV_SQRT_2_PI - 0.5 * Math.log(this.varSpike));
        return sum += -1.0 / (2.0 * this.varSpike) * (stats.getSumSq() - 2.0 * stats.getSum() * this.meanDistrib.getMean() + this.meanDistrib.getSecondMoment());
    }

    public Gaussian getMeanDistrib() {
        return this.meanDistrib;
    }

    public double getVarSpike() {
        return this.varSpike;
    }

    public String toString() {
        return String.format("mean(%s),var(%.3f)", this.meanDistrib, this.varSpike);
    }
}

