/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.ListUtils;
import fig.basic.NumUtils;
import fig.prob.DegenerateDirichlet;
import fig.prob.Dirichlet;
import fig.prob.DirichletInterface;
import fig.prob.DirichletUtils;
import fig.prob.Distrib;
import fig.prob.MargDistrib;
import fig.prob.Multinomial;
import fig.prob.MultinomialSuffStats;
import fig.prob.SuffStats;
import java.io.Serializable;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MargMultinomial
implements MargDistrib<Multinomial>,
Serializable {
    private static long serialVersionUID = 42L;
    private DirichletInterface prior;

    public MargMultinomial(DirichletInterface prior) {
        this.prior = prior;
    }

    @Override
    public double margLogLikelihood(SuffStats _stats) {
        if (this.prior instanceof DegenerateDirichlet) {
            return this.expectedLogLikelihood(_stats);
        }
        return this.predLogLikelihood(null, _stats);
    }

    @Override
    public double predLogLikelihood(SuffStats _condStats, SuffStats _predStats) {
        MultinomialSuffStats condStats = (MultinomialSuffStats)_condStats;
        MultinomialSuffStats predStats = (MultinomialSuffStats)_predStats;
        Dirichlet dprior = (Dirichlet)this.prior;
        double sum = 0.0;
        for (int i = 0; i < dprior.dim(); ++i) {
            sum += DirichletUtils.logGammaRatio(dprior.getAlpha(i) + (condStats == null ? 0.0 : condStats.getCount(i)), predStats.getCount(i));
        }
        return sum -= DirichletUtils.logGammaRatio(dprior.totalCount() + (condStats == null ? 0.0 : condStats.totalCount()), predStats.totalCount());
    }

    @Override
    public double logProb(SuffStats stats) {
        return this.prior.logProb(stats);
    }

    @Override
    public double logProbObject(Multinomial mult) {
        return this.prior.logProbObject(mult.getProbs());
    }

    @Override
    public double crossEntropy(Distrib<Multinomial> _that) {
        MargMultinomial that = (MargMultinomial)_that;
        return this.prior.crossEntropy(that.prior);
    }

    public double expectedLog(int i) {
        return this.prior.expectedLog(i);
    }

    public double[] expectedLog() {
        return this.prior.expectedLog();
    }

    public int dim() {
        return this.prior.dim();
    }

    @Override
    public double expectedLogLikelihood(SuffStats _stats) {
        MultinomialSuffStats stats = (MultinomialSuffStats)_stats;
        double[] counts = stats.getCounts();
        double sum = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            sum += counts[i] * this.prior.expectedLog(i);
        }
        NumUtils.assertIsFinite(sum);
        return sum;
    }

    public DirichletInterface getPrior() {
        return this.prior;
    }

    @Override
    public MargMultinomial getPosterior(SuffStats stats) {
        Dirichlet dprior = (Dirichlet)this.prior;
        return new MargMultinomial(new Dirichlet(ListUtils.add(dprior.getAlpha(), ((MultinomialSuffStats)stats).getCounts())));
    }

    public MargMultinomial modeSpike() {
        return new MargMultinomial(this.prior.modeSpike());
    }

    public MargMultinomial perturb(Random random) {
        Dirichlet dprior = (Dirichlet)this.prior;
        return new MargMultinomial(dprior.perturb(random));
    }

    public MargMultinomial degeneratePerturb(Random random) {
        Dirichlet dprior = (Dirichlet)this.prior;
        return new MargMultinomial(new DegenerateDirichlet(dprior.sample(random)));
    }

    @Override
    public Multinomial sampleObject(Random random) {
        return new Multinomial((double[])this.prior.sampleObject(random));
    }

    public String toString() {
        return String.format("MargMultinomial(%s)", this.prior);
    }
}

