/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.Exceptions;
import fig.basic.StrUtils;
import fig.prob.Distrib;
import fig.prob.MargDistrib;
import fig.prob.ProductDistrib;
import fig.prob.ProductSuffStats;
import fig.prob.SuffStats;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MargProductDistrib
implements MargDistrib<ProductDistrib> {
    public MargDistrib[] distribs;

    public MargProductDistrib(MargDistrib[] distribs) {
        this.distribs = distribs;
    }

    @Override
    public double margLogLikelihood(SuffStats _stats) {
        ProductSuffStats stats = (ProductSuffStats)_stats;
        double logLikelihood = 0.0;
        for (int i = 0; i < this.dim(); ++i) {
            MargDistrib currentMarg = this.distribs[i];
            SuffStats currentStats = stats.getComponent(i);
            logLikelihood += currentMarg.margLogLikelihood(currentStats);
        }
        return logLikelihood;
    }

    @Override
    public double predLogLikelihood(SuffStats _condStats, SuffStats _predStats) {
        ProductSuffStats condStats = (ProductSuffStats)_condStats;
        ProductSuffStats predStats = (ProductSuffStats)_predStats;
        double logLikelihood = 0.0;
        for (int i = 0; i < this.dim(); ++i) {
            MargDistrib currentMarg = this.distribs[i];
            logLikelihood += currentMarg.predLogLikelihood(condStats.getComponent(i), predStats.getComponent(i));
        }
        return logLikelihood;
    }

    @Override
    public double logProb(SuffStats stats) {
        throw Exceptions.unimplemented;
    }

    @Override
    public double logProbObject(ProductDistrib pd) {
        throw Exceptions.unimplemented;
    }

    @Override
    public double crossEntropy(Distrib<ProductDistrib> _that) {
        throw Exceptions.unimplemented;
    }

    @Override
    public double expectedLogLikelihood(SuffStats stats) {
        throw Exceptions.unimplemented;
    }

    @Override
    public ProductDistrib sampleObject(Random random) {
        Distrib[] distribs = new Distrib[this.dim()];
        for (int i = 0; i < this.dim(); ++i) {
            distribs[i] = (Distrib)distribs[i].sampleObject(random);
        }
        return new ProductDistrib(distribs);
    }

    @Override
    public MargProductDistrib getPosterior(SuffStats stats) {
        MargDistrib[] postDistribs = new MargDistrib[this.dim()];
        for (int i = 0; i < this.dim(); ++i) {
            postDistribs[i] = this.distribs[i].getPosterior(stats);
        }
        return new MargProductDistrib(postDistribs);
    }

    public int dim() {
        return this.distribs.length;
    }

    public String toString() {
        return StrUtils.join(this.distribs, " x ");
    }
}

