/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.MapUtils;
import fig.basic.NumUtils;
import fig.basic.TDoubleMap;
import fig.prob.DegenerateSparseDirichlet;
import fig.prob.DirichletUtils;
import fig.prob.Distrib;
import fig.prob.Gamma;
import fig.prob.SparseDirichletInterface;
import fig.prob.SuffStats;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseDirichlet
implements SparseDirichletInterface {
    protected int numDim;
    protected double pseudoCount;
    protected TDoubleMap counts;
    protected double totalCount;

    public SparseDirichlet(int numDim, double pseudoCount) {
        this(numDim, pseudoCount, new TDoubleMap());
    }

    public SparseDirichlet(int numDim, double pseudoCount, TDoubleMap counts) {
        this.numDim = numDim;
        this.counts = counts;
        this.pseudoCount = pseudoCount;
        this.totalCount = (double)numDim * pseudoCount + counts.sum();
    }

    @Override
    public int dim() {
        return this.numDim;
    }

    @Override
    public double getConcentration(Object key) {
        return this.pseudoCount + this.counts.get(key, 0.0);
    }

    @Override
    public double getMean(Object key) {
        return this.getConcentration(key) / this.totalCount;
    }

    @Override
    public double getMode(Object key) {
        return SparseDirichlet.getMode(this.getConcentration(key), this.pseudoCount, this.totalCount, this.numDim);
    }

    @Override
    public double totalCount() {
        return this.totalCount;
    }

    @Override
    public double logProb(SuffStats stats) {
        throw new RuntimeException("Haven't implemented the sufficient statistics");
    }

    @Override
    public double logProbObject(TDoubleMap probs) {
        double sum = NumUtils.logGamma(this.totalCount);
        if (probs.size() != this.numDim) {
            throw new RuntimeException("the probability must have support everywhere");
        }
        for (TDoubleMap.Entry e : probs) {
            double count = this.getConcentration(e.getKey());
            sum -= NumUtils.logGamma(count);
            sum += (count - 1.0) * Math.log(e.getValue());
        }
        NumUtils.assertIsFinite(sum);
        return sum;
    }

    @Override
    public TDoubleMap sampleObject(Random random) {
        TDoubleMap probs = new TDoubleMap();
        for (TDoubleMap.Entry e : this.counts) {
            probs.put(e.getKey(), Gamma.sample(random, this.pseudoCount + e.getValue(), 1.0));
        }
        if (this.counts.size() > this.numDim) {
            throw new RuntimeException("numDim is too small");
        }
        for (int i = this.counts.size(); i < this.numDim; ++i) {
            String key = "UNOBSERVED" + i;
            if (this.counts.containsKey(key)) {
                throw new RuntimeException("Our hacky plan was foiled");
            }
            probs.put(key, Gamma.sample(random, this.pseudoCount, 1.0));
        }
        probs.multAll(1.0 / probs.sum());
        return probs;
    }

    public SparseDirichlet withExtraCounts(TDoubleMap extraCounts) {
        SparseDirichlet newDistrib = new SparseDirichlet(this.numDim, this.pseudoCount);
        newDistrib.counts.incrMap(this.counts, 1.0);
        newDistrib.counts.incrMap(extraCounts, 1.0);
        newDistrib.totalCount += this.counts.sum() + extraCounts.sum();
        return newDistrib;
    }

    @Override
    public double expectedLog(Object key) {
        return DirichletUtils.expectedLog(this.getConcentration(key), this.totalCount);
    }

    @Override
    public double crossEntropy(Distrib<TDoubleMap> _that) {
        double thatCon;
        double thisCon;
        SparseDirichlet that = (SparseDirichlet)_that;
        double sum = DirichletUtils.thatTotalCountContrib(that.totalCount());
        int numDimHandled = 0;
        for (TDoubleMap.Entry e : this.counts) {
            thisCon = this.pseudoCount + e.getValue();
            thatCon = that.pseudoCount + that.counts.get(e.getKey(), 0.0);
            sum += DirichletUtils.elementContrib(thisCon, thatCon, this.totalCount());
            ++numDimHandled;
        }
        for (TDoubleMap.Entry e : that.counts) {
            if (this.counts.containsKey(e.getKey())) continue;
            thisCon = this.pseudoCount + this.counts.get(e.getKey(), 0.0);
            thatCon = that.pseudoCount + e.getValue();
            sum += DirichletUtils.elementContrib(thisCon, thatCon, this.totalCount());
            ++numDimHandled;
        }
        if (numDimHandled > this.numDim) {
            throw new RuntimeException("numDim is too small");
        }
        double thisCon2 = this.pseudoCount;
        double thatCon2 = that.pseudoCount;
        return sum += (double)(this.numDim - numDimHandled) * DirichletUtils.elementContrib(thisCon2, thatCon2, this.totalCount());
    }

    @Override
    public SparseDirichletInterface modeSpike() {
        return new DegenerateSparseDirichlet(this);
    }

    public String toString() {
        return String.format("Dir(numDim=%d,pseudoCount=%.2f,counts=%s)", this.numDim, this.pseudoCount, MapUtils.topNToString(this.counts, 20));
    }

    public static double getMode(double concentration, double pseudoCount, double totalCount, int numDim) {
        assert (concentration >= pseudoCount) : String.format("%f < %f", concentration, pseudoCount);
        assert (totalCount >= pseudoCount * (double)numDim);
        double t = Math.min(pseudoCount, 1.0);
        if (totalCount <= t * (double)numDim) {
            return 0.12345;
        }
        double x = (concentration - t) / (totalCount - t * (double)numDim);
        return NumUtils.bound(x, 1.0E-8, 0.99999999);
    }
}

