/*
 * Decompiled with CFR 0.152.
 */
package uk.co.flamingpenguin.jewel.cli;

import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedClass;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectedMethod;
import com.lexicalscope.jewelcli.internal.fluentreflection.$ReflectionMatchers;
import java.util.LinkedHashMap;
import java.util.List;
import uk.co.flamingpenguin.jewel.cli.Argument;
import uk.co.flamingpenguin.jewel.cli.ArgumentCollection;
import uk.co.flamingpenguin.jewel.cli.ArgumentPresentingStrategy;
import uk.co.flamingpenguin.jewel.cli.ArgumentValidationException;
import uk.co.flamingpenguin.jewel.cli.ConvertTypeOfObject;
import uk.co.flamingpenguin.jewel.cli.Option;
import uk.co.flamingpenguin.jewel.cli.OptionSpecification;
import uk.co.flamingpenguin.jewel.cli.OptionsSpecification;
import uk.co.flamingpenguin.jewel.cli.ParsedOptionSpecification;
import uk.co.flamingpenguin.jewel.cli.Unparsed;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilder;
import uk.co.flamingpenguin.jewel.cli.ValidationErrorBuilderImpl;

class ArgumentPresenterImpl<O> {
    private final OptionsSpecification<O> specification;
    private final $ReflectedClass<O> klass;
    private final ArgumentPresentingStrategy<O> argumentPresentingStrategy;

    public ArgumentPresenterImpl($ReflectedClass<O> klass, OptionsSpecification<O> specification, ArgumentPresentingStrategy<O> argumentPresentingStrategy) {
        this.specification = specification;
        this.klass = klass;
        this.argumentPresentingStrategy = argumentPresentingStrategy;
    }

    @Option
    public O presentArguments(ArgumentCollection validatedArguments) throws ArgumentValidationException {
        ConvertTypeOfObject convertTypeOfObject;
        LinkedHashMap<String, Object> argumentMap = new LinkedHashMap<String, Object>();
        ValidationErrorBuilderImpl validationErrorBuilder = new ValidationErrorBuilderImpl();
        List<$ReflectedMethod> optionMethods = this.klass.methods($ReflectionMatchers.annotatedWith(Option.class));
        for ($ReflectedMethod reflectedMethod : optionMethods) {
            Argument argument;
            ParsedOptionSpecification optionSpecification = this.specification.getSpecification(reflectedMethod);
            convertTypeOfObject = ConvertTypeOfObject.converterTo((ValidationErrorBuilder)validationErrorBuilder, (OptionSpecification)optionSpecification, reflectedMethod);
            if (optionSpecification.isMultiValued() && optionSpecification.hasDefaultValue()) {
                argumentMap.put(reflectedMethod.propertyName(), convertTypeOfObject.convert(optionSpecification.getDefaultValue()));
            } else if (optionSpecification.hasDefaultValue() && optionSpecification.getDefaultValue().size() > 0) {
                argumentMap.put(reflectedMethod.propertyName(), convertTypeOfObject.convert(optionSpecification.getDefaultValue().get(0)));
            }
            if ((argument = validatedArguments.getArgument(optionSpecification.getNames())) == null) continue;
            if (optionSpecification.isMultiValued()) {
                argumentMap.put(optionSpecification.getCanonicalIdentifier(), convertTypeOfObject.convert(argument.getValues()));
                continue;
            }
            if (!argument.getValues().isEmpty()) {
                argumentMap.put(optionSpecification.getCanonicalIdentifier(), convertTypeOfObject.convert(argument.getValues().get(0)));
                continue;
            }
            if (!argument.getValues().isEmpty()) continue;
            argumentMap.put(optionSpecification.getCanonicalIdentifier(), null);
        }
        if (this.specification.hasUnparsedSpecification()) {
            List<$ReflectedMethod> unparsedMethods = this.klass.methods($ReflectionMatchers.annotatedWith(Unparsed.class));
            for ($ReflectedMethod reflectedMethod : unparsedMethods) {
                convertTypeOfObject = ConvertTypeOfObject.converterTo((ValidationErrorBuilder)validationErrorBuilder, (OptionSpecification)this.specification.getUnparsedSpecification(), reflectedMethod);
                if (validatedArguments.getUnparsed().isEmpty()) continue;
                if (this.specification.getUnparsedSpecification().isMultiValued()) {
                    argumentMap.put(reflectedMethod.propertyName(), convertTypeOfObject.convert(validatedArguments.getUnparsed()));
                    continue;
                }
                if (validatedArguments.getUnparsed().isEmpty()) continue;
                argumentMap.put(reflectedMethod.propertyName(), convertTypeOfObject.convert(validatedArguments.getUnparsed().get(0)));
            }
        }
        validationErrorBuilder.validate();
        return this.argumentPresentingStrategy.presentArguments(argumentMap);
    }
}

