/*
 * Decompiled with CFR 0.152.
 */
package util.corpus;

import fig.basic.Fmt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IntSummaryStatistics;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import util.corpus.AbstractCorpus;
import util.corpus.wrappers.Dictionaries;
import util.corpus.wrappers.GigawordWrapper;
import util.corpus.wrappers.NerSentence;
import util.utils.Database;
import util.utils.HistMap;
import util.utils.Settings;

public class GigawordCorpus
extends AbstractCorpus {
    final String outputFilename;
    final String inputPath;
    final String annotationType;
    private final Dictionaries dictionaries;
    final String infix;
    final boolean annotationUseNeClusters;
    final boolean filterVocabulary;
    private final Map<String, Integer> amrNlVocabulary;
    private final HistMap<String> nlAnonHist;
    private final HistMap<String> nlHist;
    private final List<Integer> sentSizes;
    private int steps = 0;

    public GigawordCorpus(Settings settings, Database db, String corpus) {
        super(settings, db, corpus);
        this.inputPath = settings.getProperty(corpus + ".down.input");
        this.outputFilename = settings.getProperty(corpus + ".down.output");
        this.infix = settings.getProperty(corpus + ".down.infix");
        this.annotationType = settings.getProperty(corpus + ".annotation");
        this.annotationUseNeClusters = settings.getProperty(corpus + ".annotation.useNeClusters").equals("true");
        this.filterVocabulary = settings.getProperty(corpus + ".annotation.filterVocabulary").equals("true");
        this.nlAnonHist = new HistMap();
        this.nlHist = new HistMap();
        this.sentSizes = new ArrayList<Integer>();
        this.dictionaries = new Dictionaries(settings, true, "gigaword", this.annotationUseNeClusters);
        this.amrNlVocabulary = this.dictionaries.getAmrNlVocabulary();
    }

    @Override
    public void preprocess() {
        GigawordWrapper annotatorFile = new GigawordWrapper(this.inputPath, this.annotationType, this.dictionaries.getAmrAnonymizationAlignments(), this.amrNlVocabulary, this.dictionaries.getNeNlAmrAlignments(), this);
        this.writeVocabularies();
        if (this.infix.equals("giga")) {
            this.printStats(this.sentSizes, this.nlHist, this.nlAnonHist);
        }
    }

    public void writeLinearize(List<NerSentence> sentences, boolean append, boolean force) {
        int step = 1000000;
        if (!append || force || sentences.size() > step) {
            this.steps += step;
            System.out.println("Processed (after filtering) " + this.steps + " sentences...");
            try (PrintWriter nlWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-dfs-linear_targ.txt", this.outputFilename, this.infix), append));){
                sentences.stream().forEach(sentence -> {
                    Arrays.asList(sentence.toStringNlAnonOnly().split(" ")).stream().forEach(this.nlAnonHist::add);
                    Arrays.asList(sentence.toStringNlOnly().split(" ")).stream().forEach(this.nlHist::add);
                    nlWriter.println(sentence.toStringNlAnonOnly());
                    this.sentSizes.add(sentence.getTokens().size());
                });
                if (append) {
                    sentences.clear();
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private void writeVocabularies() {
        try (PrintWriter nlAnonVocabWriter = new PrintWriter(new FileOutputStream(String.format("%s%s-nl-vocab-anon.txt", this.outputFilename, this.infix)));){
            this.nlAnonHist.getEntriesSorted().stream().map(e -> String.format("%s\t%s", e.getFirst(), e.getSecond())).forEach(nlAnonVocabWriter::println);
        }
        catch (IOException e2) {
            e2.printStackTrace(System.err);
        }
    }

    private String[] listTxtFiles(String path) {
        return this.listFilesExt(path, ".txt");
    }

    private String[] listFilesExt(String path, String ext) {
        File f = new File(path);
        if (f.exists() && f.isDirectory()) {
            return f.list((dir, name) -> name.endsWith(ext));
        }
        return new String[0];
    }

    public Map<String, Integer> getAmrNlVocabulary() {
        return this.amrNlVocabulary;
    }

    public boolean isAnnotationUseNeClusters() {
        return this.annotationUseNeClusters;
    }

    public boolean isFilterVocabulary() {
        return this.filterVocabulary;
    }

    public String getInfix() {
        return this.infix;
    }

    private void printStats(List<Integer> sentSizes, HistMap<String> gigaHist, HistMap<String> gigaAnonHist) {
        System.out.print("Collected dataset statistics after filtering: ");
        IntSummaryStatistics stats = sentSizes.stream().collect(Collectors.summarizingInt(Integer::intValue));
        System.out.println(stats);
        System.out.println("---------");
        System.out.println("Original NL vocabulary from AMR size: " + this.amrNlVocabulary.size());
        System.out.println("Original NL vocabulary from AMR OOV rate (threshold = 1): " + Fmt.D((double)this.computeOovRate(this.amrNlVocabulary, 1)));
        System.out.println("Original NL vocabulary from AMR OOV rate (threshold = 2): " + Fmt.D((double)this.computeOovRate(this.amrNlVocabulary, 2)));
        System.out.println("Original NL vocabulary from AMR OOV rate (threshold = 5): " + Fmt.D((double)this.computeOovRate(this.amrNlVocabulary, 5)));
        System.out.println("Original NL vocabulary of which NE tokens are : " + this.dictionaries.getNumOfNlNeTokens()[0]);
        HistMap<String> neTokens = this.dictionaries.getNeTokens();
        System.out.println("Original NL vocabulary of which the NE portion of the vocabulary is : " + Fmt.D((double)((double)neTokens.size() / (double)this.amrNlVocabulary.size())));
        System.out.println("Original NL vocabulary of which the NE OOV rate (threshold = 1): " + Fmt.D((double)this.computeOovRate(neTokens, 1)));
        System.out.println("Original NL vocabulary of which the NE OOV rate (threshold = 2): " + Fmt.D((double)this.computeOovRate(neTokens, 2)));
        System.out.println("Original NL vocabulary of which the NE OOV rate (threshold = 5): " + Fmt.D((double)this.computeOovRate(neTokens, 5)));
        System.out.println("---------");
        System.out.println("Giga vocabulary size: " + gigaHist.size());
        System.out.println("Giga anonymized vocabulary size: " + gigaAnonHist.size());
        System.out.println("Giga anonymized vocabulary OOV rate (threshold = 1): " + Fmt.D((double)this.computeOovRate(gigaAnonHist, 1)));
        System.out.println("Giga anonymized vocabulary OOV rate (threshold = 2): " + Fmt.D((double)this.computeOovRate(gigaAnonHist, 2)));
        System.out.println("Giga anonymized vocabulary OOV rate (threshold = 5): " + Fmt.D((double)this.computeOovRate(gigaAnonHist, 5)));
        HashMap<String, Integer> combinedAnonVocabulary = new HashMap<String, Integer>();
        combinedAnonVocabulary.putAll(this.amrNlVocabulary);
        gigaAnonHist.getEntriesFreqs().stream().forEach(gigaEntry -> {
            Integer prevValue = (Integer)combinedAnonVocabulary.get(gigaEntry.getKey());
            combinedAnonVocabulary.put((String)gigaEntry.getKey(), prevValue + (Integer)gigaEntry.getValue());
        });
        System.out.println("---------");
        System.out.println("Combined Original AMR NL + Giga vocabulary size: " + combinedAnonVocabulary.size());
        System.out.println("Combined Original AMR NL + Giga vocabulary OOV rate (threshold = 1): " + Fmt.D((double)this.computeOovRate(combinedAnonVocabulary, 1)));
        System.out.println("Combined Original AMR NL + Giga OOV rate (threshold = 2): " + Fmt.D((double)this.computeOovRate(combinedAnonVocabulary, 2)));
        System.out.println("Combined Original AMR NL + Giga OOV rate (threshold = 5): " + Fmt.D((double)this.computeOovRate(combinedAnonVocabulary, 5)));
    }

    private double computeOovRate(Map<String, Integer> vocab, int threshold) {
        int total = vocab.size();
        int count = 0;
        for (Map.Entry<String, Integer> e : vocab.entrySet()) {
            count += e.getValue() <= threshold ? 1 : 0;
        }
        return (double)count / (double)total;
    }

    private double computeOovRate(HistMap<String> vocab, int threshold) {
        int total = vocab.size();
        int count = 0;
        for (Map.Entry<String, Integer> e : vocab.getEntriesFreqs()) {
            count += e.getValue() <= threshold ? 1 : 0;
        }
        return (double)count / (double)total;
    }
}

