/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import javax.swing.tree.TreeNode;
import util.corpus.wrappers.AmrAlignment;
import util.corpus.wrappers.AmrConcept;
import util.corpus.wrappers.AmrNode;
import util.corpus.wrappers.Dictionaries;

public class Amr {
    protected final String id;
    protected final String raw;
    protected final Dictionaries dictionaries;
    protected final AmrNode graph;
    private final Map<String, String> varStrMap;
    protected boolean failedToParse = false;

    public Amr(String id, String raw, Dictionaries dictionaries) {
        this.id = id;
        this.raw = raw;
        this.dictionaries = dictionaries;
        this.varStrMap = new HashMap<String, String>();
        this.populateVarMap(raw, this.varStrMap);
        this.graph = this.parse(raw);
    }

    public Amr(String id, AmrNode amr, Dictionaries dictionaries) {
        this.id = id;
        this.raw = null;
        this.graph = amr;
        this.dictionaries = dictionaries;
        this.varStrMap = new HashMap<String, String>();
    }

    protected void convert() {
    }

    public boolean isEmpty() {
        return false;
    }

    private void populateVarMap(String rawStr, Map<String, String> varStrMap) {
        rawStr = rawStr.replaceAll("\n", " ").replaceAll(" +", " ");
        rawStr = rawStr.replaceAll("\\(", "( ").replaceAll("\\)", " )");
        rawStr = ":TOP " + rawStr;
        String[] parts = rawStr.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            String cur = parts[i];
            if (!cur.equals("/")) continue;
            varStrMap.put(parts[i - 1], this.stripAlignment(parts[i + 1]));
        }
    }

    private AmrNode parse(String rawStr) {
        rawStr = rawStr.replaceAll("\n", " ").replaceAll(" +", " ");
        rawStr = this.treatParsInConstants(rawStr);
        Stack<AmrNode> children = new Stack<AmrNode>();
        Stack<String> cStack = new Stack<String>();
        rawStr = rawStr.replaceAll("\\(", "( ").replaceAll("\\)", " )").replaceAll(" +", " ");
        rawStr = ":TOP " + rawStr;
        String[] parts = rawStr.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            String cur = parts[i];
            if (cur.equals("/")) {
                this.varStrMap.put(parts[i - 1], this.stripAlignment(parts[i + 1]));
                cStack.add(cur);
                continue;
            }
            if (cur.charAt(0) == ':') {
                AmrAlignment argAlignment = new AmrAlignment(AmrAlignment.TokenType.ROLE, cur);
                if (!parts[i + 1].equals("(")) {
                    AmrAlignment conceptAlignment = new AmrAlignment(AmrAlignment.TokenType.CONCEPT, parts[i + 1]);
                    String wrd = conceptAlignment.getToken();
                    String var = this.varStrMap.get(wrd);
                    if (var != null) {
                        wrd = var;
                        children.add(new AmrNode(var != null ? this.stripAlignment(parts[i + 1]) : "", wrd, "", argAlignment.getToken(), true, new AmrAlignment(AmrAlignment.TokenType.CONCEPT, parts[i + 1]), argAlignment));
                    } else {
                        children.add(new AmrNode(var != null ? this.stripAlignment(parts[i + 1]) : "", conceptAlignment.getToken(), "", argAlignment.getToken(), conceptAlignment, argAlignment));
                    }
                    ++i;
                    continue;
                }
                cStack.add(cur);
                continue;
            }
            if (cur.charAt(0) == '(') {
                cStack.add(cur);
                children.push(new AmrNode("(", "(", "(", "("));
                continue;
            }
            if (cur.charAt(0) == ')') {
                try {
                    ArrayList<String> argList = new ArrayList<String>();
                    String cPop = (String)cStack.pop();
                    while (cPop.charAt(0) != '(') {
                        argList.add(0, cPop);
                        cPop = (String)cStack.pop();
                    }
                    AmrAlignment argAlignment = new AmrAlignment(AmrAlignment.TokenType.ROLE, (String)cStack.pop());
                    String arg = argAlignment.getToken();
                    if (argList.size() == 3) {
                        AmrAlignment conceptAlignment = new AmrAlignment(AmrAlignment.TokenType.CONCEPT, (String)argList.get(2));
                        String sense = "";
                        String wrd = conceptAlignment.getToken();
                        int sind = wrd.lastIndexOf(45);
                        if (sind != -1) {
                            sense = wrd.substring(sind + 1);
                            try {
                                Integer.parseInt(sense);
                                wrd = wrd.substring(0, sind);
                            }
                            catch (NumberFormatException e) {
                                sense = "";
                            }
                        }
                        try {
                            AmrNode argNode = new AmrNode(this.stripAlignment((String)argList.get(0)), wrd, sense, arg, conceptAlignment, argAlignment);
                            AmrNode child = (AmrNode)children.pop();
                            while (!child.getWord().equals("(")) {
                                argNode.addArg(child);
                                child = (AmrNode)children.pop();
                            }
                            children.push(argNode);
                        }
                        catch (Exception e) {
                            System.out.println(conceptAlignment + " " + argAlignment);
                        }
                        continue;
                    }
                    this.failedToParse = true;
                    System.err.println("Program should never enter here !\n" + this.id + "\n" + this.raw);
                    continue;
                }
                catch (EmptyStackException e) {
                    System.err.println("Stack empty while reading raw input (empty or multiple graphs in one example):\n" + this.id + "\n" + this.raw);
                    return (AmrNode)children.get(0);
                }
            }
            cStack.add(cur);
        }
        return (AmrNode)children.get(0);
    }

    protected String stripAlignment(String str) {
        int index = str.indexOf("~");
        if (index >= 0) {
            return str.substring(0, index);
        }
        return str;
    }

    private String treatParsInConstants(String rawStr) {
        if (rawStr.contains("\"")) {
            String[] ar = rawStr.split("\"");
            StringBuilder str = new StringBuilder(ar[0]);
            for (int i = 1; i < ar.length - 1; ++i) {
                str.append("\"").append(ar[i].replaceAll("\\(", "[").replaceAll("\\)", "]")).append("\"").append(ar[++i]);
            }
            return str.toString();
        }
        return rawStr;
    }

    private void appendNewAmrNode(AmrNode root, AmrNode candChild, String relation) {
        AmrNode newChild = new AmrNode(candChild.getVar(), candChild.getWord(), candChild.getSense(), relation);
        root.addArg(newChild);
    }

    private String canonicaliseRole(String role) {
        int index = role.indexOf("-of");
        return index > 0 ? role.substring(0, index) : role;
    }

    protected boolean isNameConcept(AmrNode node) {
        return node.getWord().equals("name") && node.getRole().equals("name");
    }

    protected boolean isQuantConceptWithNum(AmrNode node) {
        return node.getRole().equals("quant") && this.isNumber(node.getWord());
    }

    protected boolean isValueConceptWithNum(AmrNode node) {
        return node.getRole().equals("value") && this.isNumber(node.getWord());
    }

    protected boolean isDateEntityConcept(AmrNode node) {
        return node.getWord().equals("date-entity");
    }

    protected boolean hasDateEntityRole(AmrNode node) {
        return this.dictionaries.getAmrDateRoles().contains(node.getRole());
    }

    protected boolean hasTimeRole(AmrNode node) {
        return node.getRole().equals("time");
    }

    protected AmrConcept.Type determineConceptType(AmrNode node) {
        if (node.hasSense()) {
            return AmrConcept.Type.OTHER;
        }
        if (this.dictionaries.getAmrNeConcepts().contains(node.getWord())) {
            return AmrConcept.Type.NAME;
        }
        if (this.dictionaries.getAmrQuantityConcepts().contains(node.getWord())) {
            return AmrConcept.Type.QUANTITY;
        }
        if (this.dictionaries.getAmrValueConcepts().contains(node.getWord())) {
            return AmrConcept.Type.VALUE;
        }
        if (this.isDateEntityConcept(node)) {
            return AmrConcept.Type.DATE;
        }
        if (this.isNumber(node.getWord())) {
            return AmrConcept.Type.NUMBER;
        }
        return AmrConcept.Type.OTHER;
    }

    protected boolean isNumber(String s) {
        return s.matches("-\\p{Digit}+|-?\\p{Digit}+[\\.,]\\p{Digit}+") || s.matches("\\p{Digit}+");
    }

    private String aggregateNameConcept(AmrNode node) {
        Enumeration<TreeNode> children = node.children();
        TreeMap<Integer, String> opsOrdered = new TreeMap<Integer, String>();
        while (children.hasMoreElements()) {
            AmrNode child = (AmrNode)children.nextElement();
            String role = child.getRole();
            if (!role.startsWith("op")) continue;
            opsOrdered.put(Integer.valueOf(role.substring(2)), child.getWord());
        }
        StringBuilder str = new StringBuilder();
        opsOrdered.values().stream().forEach(value -> str.append(value.replaceAll("\"", "")).append(" "));
        return str.toString().trim();
    }

    public boolean isFailedToParse() {
        return this.failedToParse;
    }

    public AmrNode getGraph() {
        return this.graph;
    }

    public String toString() {
        return this.raw.replaceAll("\n", " ").replaceAll(" +", " ").replaceAll("-[0-9]+", "");
    }
}

