/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import util.corpus.wrappers.AnonymizationAlignment;

public class AmrAnonymizationAlignment
implements AnonymizationAlignment {
    String anonymizedToken;
    String amrToken;
    List<String> nlTokens;
    List<Integer> nlIds;
    int anonymizedNlId;

    public AmrAnonymizationAlignment() {
    }

    public AmrAnonymizationAlignment(String raw) {
        String[] tokens = raw.split("\\|\\|\\|");
        assert (tokens.length == 5) : "Wrong anonymization alignment format: should contain exactly 5 tokens.";
        this.anonymizedToken = tokens[0];
        this.amrToken = tokens[1];
        this.nlTokens = Arrays.asList(tokens[2].split(" "));
        this.nlIds = this.readIntegerList(tokens[3]);
        this.anonymizedNlId = Integer.valueOf(tokens[4]);
    }

    public AmrAnonymizationAlignment(String anonymizedToken, String amrTokens) {
        this(anonymizedToken, amrTokens, new ArrayList<String>(), new ArrayList<Integer>(), -1);
    }

    public AmrAnonymizationAlignment(String anonymizedToken, String amrTokens, List<String> nlTokens, List<Integer> nlIds, int anonymizedNlId) {
        this.anonymizedToken = anonymizedToken;
        this.amrToken = amrTokens.replaceAll("\"", "");
        this.nlTokens = nlTokens;
        this.nlIds = nlIds;
        this.anonymizedNlId = anonymizedNlId;
    }

    @Override
    public boolean isEmpty() {
        return this.anonymizedNlId == -1;
    }

    @Override
    public String getAnonymizedToken() {
        return this.anonymizedToken;
    }

    public String getRawAmrToken() {
        return this.amrToken;
    }

    @Override
    public List<String> getCanonicalizedInputTokens() {
        return Arrays.asList(this.amrToken.substring(this.amrToken.indexOf("_") + 1).split("_"));
    }

    @Override
    public List<String> getNlTokens() {
        return this.nlTokens;
    }

    @Override
    public List<Integer> getNlIds() {
        return this.nlIds;
    }

    @Override
    public int getAnonymizedNlId() {
        return this.anonymizedNlId;
    }

    @Override
    public boolean containsNode(int nodeWordId) {
        return this.nlIds.contains(nodeWordId);
    }

    public void adjust(int wordToBeAdjustedIndex, boolean anonymizedId, boolean negative) {
        if (anonymizedId) {
            if (wordToBeAdjustedIndex < this.anonymizedNlId) {
                this.anonymizedNlId = negative ? --this.anonymizedNlId : ++this.anonymizedNlId;
            }
        } else {
            for (int i = 0; i < this.nlIds.size(); ++i) {
                if (wordToBeAdjustedIndex >= this.nlIds.get(i)) continue;
                if (negative) {
                    this.nlIds.set(i, this.nlIds.get(i) - 1);
                    continue;
                }
                this.nlIds.set(i, this.nlIds.get(i) + 1);
            }
        }
    }

    public int relativePosOfHyphenInNl(int index) {
        if (this.nlIds.isEmpty() || this.nlIds.size() == 1) {
            return -1;
        }
        if (index > this.nlIds.get(0) && index < this.nlIds.get(this.nlIds.size() - 1)) {
            for (int i = 1; i < this.nlIds.size(); ++i) {
                if (index >= this.nlIds.get(i)) continue;
                return i - 1;
            }
        }
        return -1;
    }

    @Deprecated
    protected String tokensToString(List<String> tokens) {
        if (tokens.size() > 0) {
            StringBuilder str = new StringBuilder();
            tokens.stream().forEach(token -> str.append((String)token).append(" "));
            return str.toString().trim();
        }
        return " ";
    }

    @Override
    public String nlToString() {
        return String.join((CharSequence)" ", this.nlTokens);
    }

    protected String idsToString() {
        if (this.nlIds.size() > 0) {
            StringBuilder str = new StringBuilder();
            this.nlIds.stream().forEach(id -> str.append(id).append(","));
            return str.deleteCharAt(str.length() - 1).toString();
        }
        return " ";
    }

    private List<Integer> readIntegerList(String raw) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (!raw.equals(" ")) {
            for (String token : raw.split(",")) {
                list.add(Integer.valueOf(token));
            }
        }
        return list;
    }

    public String amrNlToString() {
        return this.amrToken + "|||" + this.nlTokens.get(0);
    }

    public boolean equalsAmr(AmrAnonymizationAlignment alignIn) {
        return alignIn.amrToken.equals(this.amrToken);
    }

    public boolean equals(Object obj) {
        assert (obj instanceof AmrAnonymizationAlignment);
        AmrAnonymizationAlignment o = (AmrAnonymizationAlignment)obj;
        return this.anonymizedToken.equals(o.anonymizedToken) && this.amrToken.equals(o.amrToken) && this.nlIds.equals(o.nlIds) && this.anonymizedNlId == o.anonymizedNlId;
    }

    public int hashCode() {
        int hash = 3;
        hash = 89 * hash + Objects.hashCode(this.anonymizedToken);
        hash = 89 * hash + Objects.hashCode(this.amrToken);
        hash = 89 * hash + Objects.hashCode(this.nlIds);
        hash = 89 * hash + this.anonymizedNlId;
        return hash;
    }

    public String toString() {
        return String.format("%s|||%s|||%s|||%s|||%s", this.anonymizedToken, this.amrToken, this.tokensToString(this.nlTokens), this.idsToString(), this.anonymizedNlId);
    }
}

