/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.tree.TreeNode;
import org.apache.commons.collections4.map.MultiValueMap;
import util.corpus.wrappers.Amr;
import util.corpus.wrappers.AmrComponent;
import util.corpus.wrappers.AmrConcept;
import util.corpus.wrappers.AmrNode;
import util.corpus.wrappers.AmrProposition;
import util.corpus.wrappers.AmrRole;
import util.corpus.wrappers.Dictionaries;

public class AmrLinearize
extends Amr {
    protected List<AmrComponent> linearizedGraph;
    private List<AmrProposition> propositions;
    private final Set<String> filteredSet;
    protected MultiValueMap<String, AmrConcept> varToConceptObj;
    protected final String linearizeType;
    private final boolean ALLOW_WIKI = true;
    private final boolean ALLOW_DATE = true;
    protected final boolean ALLOW_NEs = true;
    protected final boolean ALLOW_NUMS = true;

    public AmrLinearize(String id, String raw, Dictionaries dictionaries, String linearizeType) {
        super(id, raw, dictionaries);
        this.linearizeType = linearizeType;
        this.filteredSet = dictionaries == null ? Collections.EMPTY_SET : dictionaries.getLinearizedFilter();
    }

    public AmrLinearize(String id, AmrNode amr, Dictionaries dictionaries, String linearizeType) {
        super(id, amr, dictionaries);
        this.linearizeType = linearizeType;
        this.filteredSet = dictionaries == null ? Collections.EMPTY_SET : dictionaries.getLinearizedFilter();
    }

    @Override
    protected void convert() {
        this.linearizedGraph = new LinkedList<AmrComponent>();
        this.propositions = new LinkedList<AmrProposition>();
        this.varToConceptObj = new MultiValueMap();
        switch (this.linearizeType) {
            case "dfs": {
                this.dfs(this.graph, null, "0");
                break;
            }
            case "majority": {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            case "classifier": {
                throw new UnsupportedOperationException("Not supported yet.");
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        }
    }

    private void dfs(AmrNode root, AmrProposition proposition, String nodeId) {
        AmrConcept.Type conceptType = this.determineConceptType(root);
        AmrConcept concept = new AmrConcept(root.getWord(), root.getSense(), root.getVar(), root.isCyclicReference(), conceptType, root.getConceptAlignment(), nodeId);
        this.linearizedGraph.add(concept);
        this.varToConceptObj.put((Object)root.getVar(), (Object)concept);
        if (proposition != null) {
            proposition.setArgument(concept);
            concept.setParent(proposition.getPredicate());
        }
        if (root.isLeaf()) {
            return;
        }
        Enumeration<TreeNode> children = root.children();
        int childId = 0;
        while (children.hasMoreElements()) {
            AmrNode child = (AmrNode)children.nextElement();
            AmrRole role = new AmrRole(":" + child.getRole(), child.getRoleAlignment());
            role.setOrderId(this.dictionaries.getAmrRoleOrderId(role));
            this.linearizedGraph.add(role);
            AmrProposition newProposition = new AmrProposition(concept, role);
            this.propositions.add(newProposition);
            concept.addChild(newProposition);
            this.dfs(child, newProposition, String.format("%s.%s", nodeId, childId++));
        }
    }

    private void updateGraph(AmrConcept predicate, AmrConcept argument) {
        this.linearizedGraph.add(argument);
        AmrProposition newProposition = new AmrProposition(predicate, argument, new AmrRole(":unk"));
        predicate.addChild(newProposition);
        argument.setParent(predicate);
        this.propositions.add(newProposition);
    }

    protected List<AmrComponent> filterGraph() {
        boolean removedFilteredToken = false;
        ListIterator<AmrComponent> it = this.linearizedGraph.listIterator();
        while (it.hasNext()) {
            AmrComponent next = it.next();
            if (next.getName().contains("\"")) {
                next.setName(next.getName().replaceAll("\"", ""));
            }
            if (removedFilteredToken && it.hasNext() && next instanceof AmrRole && !next.getName().equals(":polarity")) {
                it.remove();
                removedFilteredToken = false;
                continue;
            }
            if (this.filteredSet.contains(next.getName())) {
                if (next instanceof AmrConcept && ((AmrConcept)next).hasSense()) continue;
                it.remove();
                removedFilteredToken = true;
                continue;
            }
            if (next.getName().equals(":polarity")) {
                next.setName(":polarity-neg");
                it.next();
                it.remove();
                continue;
            }
            if (next instanceof AmrConcept && ((AmrConcept)next).getType() == AmrConcept.Type.NUMBER && ((AmrConcept)next).getType() != AmrConcept.Type.DATE || !it.hasNext() || !(next instanceof AmrConcept) || !((AmrConcept)next).isCyclicReference()) continue;
            it.remove();
            it.previous();
            it.remove();
        }
        return this.linearizedGraph;
    }

    protected List<AmrComponent> simplifyGraph(boolean deAnonymize, boolean includeReentrances, boolean reentrancesRoles) {
        ListIterator<AmrComponent> it = this.linearizedGraph.listIterator();
        while (it.hasNext()) {
            AmrComponent next = it.next();
            if (next.getName().contains("\"")) {
                next.setName(next.getName().replaceAll("\"", ""));
            }
            if (!(next instanceof AmrConcept)) continue;
            AmrConcept concept = (AmrConcept)next;
            switch (concept.type) {
                case NAME: {
                    if (!concept.getName().contains("_name_")) break;
                    if (deAnonymize) {
                        String[] toks = concept.getAlignment().getToken().split("_");
                        concept.setName(Arrays.stream(toks, 1, toks.length).collect(Collectors.joining(" ")));
                    }
                    if (!it.hasPrevious()) break;
                    it.previous();
                    AmrComponent prev = it.previous();
                    if (this.filteredSet.contains(prev.getName())) {
                        if (prev instanceof AmrConcept && ((AmrConcept)prev).hasSense()) {
                            it.next();
                            if (!it.hasNext()) break;
                            it.next();
                            break;
                        }
                        AmrConcept parent = ((AmrConcept)prev).getParent();
                        ((AmrConcept)next).setParent(parent);
                        if (parent != null) {
                            parent.getChildren().stream().forEach(p -> {
                                if (p.getArgument().equals(prev)) {
                                    p.setArgument((AmrConcept)next);
                                }
                            });
                        }
                        ((AmrConcept)prev).getChildren().stream().forEach(p -> {
                            String role = p.getRole().getName();
                            if (!role.equals(":unk") && !role.equals(":wiki")) {
                                concept.addChild((AmrProposition)p);
                            }
                        });
                        it.remove();
                        it.next();
                        break;
                    }
                    it.next();
                    if (!it.hasNext()) break;
                    it.next();
                    break;
                }
                case DATE: {
                    if (!concept.getName().contains("_date-entity_") || !deAnonymize) break;
                    concept.setName(concept.getAlignment().getToken());
                    break;
                }
                case QUANTITY: 
                case VALUE: 
                case NUMBER: {
                    if (!concept.getName().contains("num_") || !deAnonymize) break;
                    concept.setName(concept.getAlignment().getToken());
                }
            }
            if (!concept.isCyclicReference()) continue;
            AmrConcept parent = concept.getParent();
            if (parent != null) {
                parent.getChildren().stream().forEach(p -> {
                    if (p.getArgument().equals(concept)) {
                        if (!includeReentrances) {
                            p.getArgument().setName("");
                        } else if (reentrancesRoles) {
                            p.getRole().setName(p.getRole().getName() + "-r");
                        }
                    }
                });
            }
            if (includeReentrances) continue;
            it.remove();
        }
        return this.linearizedGraph;
    }

    protected List<AmrProposition> filterPropositions() {
        AmrProposition next;
        ListIterator<AmrProposition> it = this.propositions.listIterator();
        if (this.propositions.size() > 1) {
            this.swapAnonymizedEntityAtFirstPositionHeuristic(this.propositions);
            while (it.hasNext()) {
                next = it.next();
                if (next.getRole() != null || next.getPredicate().getType() == AmrConcept.Type.DATE) continue;
                AmrConcept anonymizedArgumentConcept = next.getArgument();
                AmrProposition grandParent = this.visitBackwards(it, next, next.getPredicate().getVar());
                grandParent.setArgument(anonymizedArgumentConcept);
                String predicateConceptVar = next.getPredicate().getVar();
                this.varToConceptObj.getCollection((Object)predicateConceptVar).stream().forEach(reEntrance -> {
                    if (reEntrance != grandParent.getPredicate()) {
                        reEntrance.setName(anonymizedArgumentConcept.getName());
                    }
                });
            }
        }
        it = this.propositions.listIterator();
        while (it.hasNext()) {
            next = it.next();
            if (it.previousIndex() > 0) {
                AmrProposition prev = this.propositions.get(it.previousIndex() - 1);
                if (next.getPredicate().getName().equals("person") && prev.getArgument().getName().startsWith("person_name")) {
                    next.setPredicate(prev.getArgument());
                }
            }
            if (!next.getPredicate().getName().equals("person") || !next.getArgument().getName().contains("_name") || next.getRole() == null || !next.getRole().getName().equals(":domain")) continue;
            String predicateConceptVar = next.getPredicate().getVar();
            this.varToConceptObj.getCollection((Object)predicateConceptVar).stream().forEach(reEntrance -> reEntrance.setName(next.getArgument().getName()));
            it.remove();
        }
        return this.propositions;
    }

    private AmrProposition visitBackwards(ListIterator<AmrProposition> it, AmrProposition current, String childVar) {
        if (!this.filteredSet.contains(current.getPredicate().getName()) || !childVar.equals(current.getPredicate().getVar()) || it.previousIndex() < 0) {
            return current;
        }
        it.remove();
        return this.visitBackwards(it, it.previous(), current.getPredicate().getVar());
    }

    private void swapAnonymizedEntityAtFirstPositionHeuristic(List<AmrProposition> propositions) {
        AmrProposition first = propositions.get(0);
        if (first.getRole() == null && first.getPredicate().getType() != AmrConcept.Type.DATE) {
            String parentVar = first.getPredicate().getVar();
            int i = 1;
            String nextParentVar = propositions.get(i).getPredicate().getVar();
            while (parentVar.equals(nextParentVar)) {
                Collections.swap(propositions, i - 1, i);
                nextParentVar = ++i < propositions.size() ? propositions.get(i).getPredicate().getVar() : "";
            }
        }
    }

    public List<AmrComponent> getLinearizedGraph() {
        return this.linearizedGraph;
    }

    public String propositionsToString() {
        StringBuilder str = new StringBuilder();
        this.propositions.stream().forEach(prop -> str.append(prop).append(" "));
        return str.toString().trim();
    }

    @Override
    public boolean isEmpty() {
        return this.linearizedGraph.isEmpty();
    }

    public int size() {
        return this.linearizedGraph.size();
    }

    public int propositionsSize() {
        return this.propositions.size();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        AmrConcept root = (AmrConcept)this.linearizedGraph.get(0);
        String out = AmrConcept.print(root, "", str, false, false, false, false, false).toString().toLowerCase().trim();
        return out;
    }

    public String toStringBrackets(boolean reshuffleChildren, boolean markLeaves, boolean outputSense, boolean concatBracketsWithRoles) {
        StringBuilder str = new StringBuilder();
        AmrConcept root = (AmrConcept)this.linearizedGraph.get(0);
        String out = AmrConcept.print(root, "", str, true, reshuffleChildren, markLeaves, outputSense, concatBracketsWithRoles).toString().toLowerCase().trim();
        return (out.split(" ").length > 1 && out.length() > 2 ? out.substring(2, out.length() - 2) : out).trim();
    }
}

