/*
 * Decompiled with CFR 0.152.
 */
package util.corpus.wrappers;

import fig.basic.Indexer;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import util.corpus.wrappers.AmrAlignment;
import util.corpus.wrappers.AmrAnonymizationAlignment;
import util.corpus.wrappers.AmrComponent;
import util.corpus.wrappers.AmrConcept;
import util.corpus.wrappers.AmrLinearize;
import util.corpus.wrappers.AmrNode;
import util.corpus.wrappers.AmrSentence;
import util.corpus.wrappers.Dictionaries;
import util.corpus.wrappers.JamrAlignment;
import util.utils.HistMap;
import util.utils.StemmerPosTagger;

public class AmrLinearizedSentence
extends AmrSentence {
    private final String SOS = "<s>";
    private final String EOS = "</s>";
    private final String UNK = "<unk>";
    private final String NUM = "<num>";
    private final String DATE = "<date>";
    protected final String linearizeType;
    protected Set<AmrAnonymizationAlignment> anonymizationAlignments;
    private Set<AmrAnonymizationAlignment> contentAlignments;
    private final Map<String, JamrAlignment> jamrAlignments;
    private final String FORMAT = "[0-9]{2,4}[-]?[0-9]{2}[-]?[0-9]{2}";

    public AmrLinearizedSentence(String id, String sentence, Map<String, JamrAlignment> jamrAlignments, String linearizeType) {
        super(id, sentence);
        this.linearizeType = linearizeType;
        this.jamrAlignments = jamrAlignments;
    }

    public AmrLinearizedSentence(String id, String sentence, AmrNode root, Dictionaries dictionaries, Map<String, JamrAlignment> jamrAlignments, String linearizeType) {
        super(id, sentence);
        this.linearizeType = linearizeType;
        this.jamrAlignments = jamrAlignments;
        this.amr = new AmrLinearize(id, root, dictionaries, linearizeType);
        this.anonymizationAlignments = new LinkedHashSet<AmrAnonymizationAlignment>();
        this.contentAlignments = new LinkedHashSet<AmrAnonymizationAlignment>();
        this.amr.convert();
    }

    @Override
    public void parseAmr(String id, String rawAmr, Dictionaries dictionaries) {
        this.amr = new AmrLinearize(id, rawAmr, dictionaries, this.linearizeType);
        this.anonymizationAlignments = new LinkedHashSet<AmrAnonymizationAlignment>();
        this.contentAlignments = new LinkedHashSet<AmrAnonymizationAlignment>();
        this.amr.convert();
    }

    public void applyAlignmentHeuristics(Map<String, HistMap<String>> amrNlAlignmentsMap, boolean deAnonymizeGraph, boolean includeReentrances, boolean reentrancesRoles) {
        try {
            int nameCounter = 0;
            int quantityCounter = 0;
            boolean numberCounter = false;
            int dateCounter = 0;
            int dayCounter = 0;
            int monthCounter = 0;
            int yearCounter = 0;
            boolean timeCounter = false;
            int dateOffset = 0;
            int offset = 0;
            HashMap<String, Pair> varToPlaceHolder = new HashMap<String, Pair>();
            String[] anonymizedSent = this.sentence.split(" ");
            String[] sent = this.sentence.split(" ");
            ListIterator<AmrComponent> it = ((AmrLinearize)this.amr).getLinearizedGraph().listIterator();
            block18: while (it.hasNext()) {
                AmrComponent token = (AmrComponent)it.next();
                if (!(token instanceof AmrConcept)) continue;
                AmrConcept concept = (AmrConcept)token;
                offset = anonymizedSent.length - sent.length;
                switch (concept.type) {
                    case NAME: {
                        if (concept.getName().endsWith("_name")) {
                            String placeholder = concept.getName() + "_" + nameCounter;
                            this.anonymizeSentenceTokens(anonymizedSent, concept, placeholder, false, offset);
                            varToPlaceHolder.put(concept.getVar(), new Pair((Object)placeholder, (Object)concept.getAlignment().getToken()));
                            concept.setName(concept.getName() + "_" + nameCounter++);
                            continue block18;
                        }
                        if (concept.isCyclicReference() && varToPlaceHolder.containsKey(concept.getVar())) {
                            Pair placeholderToken = (Pair)varToPlaceHolder.get(concept.getVar());
                            concept.getAlignment().setToken((String)placeholderToken.getSecond());
                            this.anonymizeSentenceTokens(anonymizedSent, concept, (String)placeholderToken.getFirst(), false, offset);
                            continue block18;
                        }
                        this.createContentAlignment(anonymizedSent, concept, amrNlAlignmentsMap);
                        continue block18;
                    }
                    case QUANTITY: 
                    case VALUE: {
                        if (!concept.getName().endsWith("_num")) continue block18;
                        this.anonymizeSentenceTokens(anonymizedSent, concept, concept.getName() + "_" + quantityCounter, false, offset);
                        concept.setName(concept.getName() + "_" + quantityCounter++);
                        continue block18;
                    }
                    case NUMBER: {
                        this.anonymizeSentenceTokens(anonymizedSent, concept, concept.getName(), false, offset);
                        concept.setName(concept.getName());
                        continue block18;
                    }
                    case DATE: {
                        String[] anonymizedSentIn;
                        if (!concept.getName().endsWith("_date-entity")) continue block18;
                        switch (concept.getName().substring(0, concept.getName().indexOf("_"))) {
                            case "day": {
                                anonymizedSentIn = this.anonymizeDateSentenceTokens(sent, anonymizedSent, concept, dayCounter, dateOffset, "day", offset);
                                concept.setName(concept.getName() + "_" + dayCounter++);
                                break;
                            }
                            case "month": {
                                anonymizedSentIn = this.anonymizeDateSentenceTokens(sent, anonymizedSent, concept, monthCounter, dateOffset, "month", offset);
                                concept.setName(concept.getName() + "_" + monthCounter++);
                                break;
                            }
                            case "year": {
                                anonymizedSentIn = this.anonymizeDateSentenceTokens(sent, anonymizedSent, concept, yearCounter, dateOffset, "year", offset);
                                concept.setName(concept.getName() + "_" + yearCounter++);
                                break;
                            }
                            default: {
                                anonymizedSentIn = this.anonymizeDateSentenceTokens(sent, anonymizedSent, concept, dateCounter, dateOffset, "", offset);
                                concept.setName(concept.getName() + "_" + dateCounter++);
                            }
                        }
                        dateOffset += anonymizedSentIn[0].equals("n") ? 0 : 1;
                        anonymizedSent = Arrays.copyOfRange(anonymizedSentIn, 1, anonymizedSentIn.length);
                        continue block18;
                    }
                }
                this.createContentAlignment(anonymizedSent, concept, amrNlAlignmentsMap);
            }
            this.setAnonymizedSentence(this.cleanupAnonymizedSentence(this.rejoinHyphenatedWords(this.repack(anonymizedSent, null, false), true)));
            this.setSentence(this.rejoinHyphenatedWords(this.sentence, false));
            ((AmrLinearize)this.amr).simplifyGraph(deAnonymizeGraph, includeReentrances, reentrancesRoles);
        }
        catch (Exception e) {
            System.err.println(this.amr.id);
            e.printStackTrace(System.err);
        }
    }

    private void anonymizeSentenceTokens(String[] sentence, AmrConcept concept, String placeholder, boolean replaceInNl, int offset) {
        ArrayList<Integer> nlIds = new ArrayList<Integer>();
        ArrayList<String> nlTokens = new ArrayList<String>();
        AmrAlignment alignment = concept.getAlignment();
        if (alignment.isEmpty() && !concept.isCyclicReference() && this.jamrAlignments.containsKey(concept.nodeId)) {
            JamrAlignment jamr = this.jamrAlignments.get(concept.nodeId);
            concept.getAlignment().copyFromJamrAlignment(jamr);
        }
        for (int wordId : alignment.getWordIds()) {
            if (wordId < 0 || wordId >= sentence.length) continue;
            int offsetWordId = wordId + offset;
            nlTokens.add(sentence[wordId]);
            if (replaceInNl) {
                sentence[offsetWordId] = placeholder;
            }
            nlIds.add(wordId);
        }
        if (!nlIds.isEmpty()) {
            this.anonymizationAlignments.add(new AmrAnonymizationAlignment(placeholder, alignment.getToken(), nlTokens, nlIds, (Integer)nlIds.get(0) + offset));
        } else {
            this.anonymizationAlignments.add(new AmrAnonymizationAlignment(placeholder, alignment.getToken()));
        }
    }

    private String[] anonymizeDateSentenceTokens(String[] sentence, String[] anonSentenceIn, AmrConcept concept, int counter, int dateOffset, String dateType, int offset) {
        LinkedList<String> anonSentence = new LinkedList<String>(Arrays.asList(anonSentenceIn));
        AmrAlignment alignment = concept.getAlignment();
        boolean replacedWithJamr = false;
        if (concept.getAlignment().isEmpty() && this.jamrAlignments.get(concept.nodeId) != null) {
            JamrAlignment jamr = this.jamrAlignments.get(concept.nodeId);
            int jamrIdToUse = -1;
            switch (jamr.nlIds.size()) {
                case 3: {
                    switch (dateType) {
                        case "year": {
                            jamrIdToUse = 2;
                            break;
                        }
                        case "month": {
                            jamrIdToUse = 1;
                            break;
                        }
                        case "day": {
                            jamrIdToUse = 0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (dateType) {
                        case "year": {
                            jamrIdToUse = 1;
                            break;
                        }
                        case "month": {
                            jamrIdToUse = 0;
                        }
                    }
                    break;
                }
                default: {
                    concept.getAlignment().copyFromJamrAlignment(jamr);
                }
            }
            if (jamrIdToUse > -1) {
                alignment.getWordIds().set(0, (Integer)jamr.nlIds.get(jamrIdToUse));
                alignment.getWords()[0] = (String)jamr.nlTokens.get(jamrIdToUse);
            }
            replacedWithJamr = true;
        }
        String placeholder = concept.getName() + "_" + counter;
        ArrayList<Integer> nlIds = new ArrayList<Integer>();
        ArrayList<String> nlTokens = new ArrayList<String>();
        int anonymizedId = -1;
        boolean modifiedSentenceLength = false;
        for (int wordId : alignment.getWordIds()) {
            if (wordId < 0 || wordId >= sentence.length) continue;
            int offsetWordId = wordId + dateOffset;
            String nlWord = sentence[wordId];
            if (dateType.equals("month") && nlWord.matches("\\p{Alpha}+")) {
                placeholder = "month_name_date-entity_" + counter;
            }
            String format = "";
            if (nlWord.matches("[0-9]{6}")) {
                format = "f1";
            } else if (nlWord.matches("[0-9]{8}")) {
                format = "f2";
            } else if (nlWord.matches("[0-9]{4}-[0-9]{2}-[0-9]{2}")) {
                format = "f3";
            }
            if (!format.equals("")) {
                placeholder = dateType + "_" + format + "_date-entity_" + counter;
                anonymizedId = offsetWordId;
                if (dateOffset > 0) {
                    this.adjustAlignmentIndices(anonymizedId, true, false);
                }
                if (anonymizedId < anonSentence.size() && ((String)anonSentence.get(anonymizedId)).matches("[0-9]{2,4}[-]?[0-9]{2}[-]?[0-9]{2}")) {
                    anonSentence.remove(anonymizedId);
                }
                anonSentence.add(anonymizedId, placeholder);
                modifiedSentenceLength = true;
            } else {
                anonymizedId = wordId + offset;
                anonSentence.set(anonymizedId, placeholder);
            }
            nlTokens.add(sentence[wordId]);
            nlIds.add(wordId);
        }
        if (replacedWithJamr) {
            anonymizedId = alignment.getWordIds().get(0);
        }
        if (!nlIds.isEmpty()) {
            this.anonymizationAlignments.add(new AmrAnonymizationAlignment(concept.getName() + "_" + counter, alignment.getToken(), nlTokens, nlIds, anonymizedId));
        } else {
            this.anonymizationAlignments.add(new AmrAnonymizationAlignment(placeholder, alignment.getToken()));
        }
        anonSentence.add(0, modifiedSentenceLength ? "y" : "n");
        return anonSentence.toArray(new String[0]);
    }

    private void createContentAlignment(String[] sentence, AmrConcept concept, Map<String, HistMap<String>> amrNlAlignmentsMap) {
        JamrAlignment jamrAlignment;
        HistMap<String> hist;
        AmrAlignment alignment = concept.getAlignment();
        ArrayList<Integer> nlIds = new ArrayList<Integer>();
        ArrayList<String> nlTokens = new ArrayList<String>();
        boolean createdContentAlignment = false;
        if (alignment != null && !alignment.isEmpty()) {
            alignment.getWordIds().stream().filter(wordId -> wordId >= 0 && wordId < sentence.length).map(wordId -> {
                nlTokens.add(sentence[wordId]);
                return wordId;
            }).forEach(wordId -> nlIds.add((Integer)wordId));
            if (!nlIds.isEmpty()) {
                AmrAnonymizationAlignment contentAlignment = new AmrAnonymizationAlignment(concept.getNodeId(), concept.getName(), nlTokens, nlIds, (Integer)nlIds.get(0));
                this.contentAlignments.add(contentAlignment);
                hist = amrNlAlignmentsMap.getOrDefault(contentAlignment.amrToken, new HistMap());
                hist.add(contentAlignment.getNlTokens().stream().collect(Collectors.joining(" ")).toLowerCase());
                amrNlAlignmentsMap.put(contentAlignment.amrToken, hist);
                createdContentAlignment = true;
            }
        }
        if (!createdContentAlignment && !concept.isCyclicReference() && this.jamrAlignments.containsKey(concept.nodeId) && !(jamrAlignment = this.jamrAlignments.get(concept.nodeId)).isEmpty()) {
            hist = amrNlAlignmentsMap.getOrDefault(jamrAlignment.amrToken, new HistMap());
            hist.add(jamrAlignment.getNlTokens().stream().collect(Collectors.joining(" ")).toLowerCase());
            amrNlAlignmentsMap.put(jamrAlignment.amrToken, hist);
        }
    }

    private String repack(String[] toks, Indexer<String> vocabulary, boolean processOovWords) {
        StringBuilder str = new StringBuilder();
        String prevTok = "";
        int totalWords = 0;
        for (int i = 0; i < toks.length; ++i) {
            String tok = toks[i];
            if (tok.equals("@-@") && prevTok.contains("_") && !prevTok.contains("date-entity")) {
                this.adjustAlignmentIndices(totalWords, true, true);
                continue;
            }
            if (!tok.equals(prevTok)) {
                str.append(!processOovWords || !this.isUnkWord(vocabulary, tok) ? tok : "<unk>").append(" ");
                ++totalWords;
                prevTok = tok;
                continue;
            }
            this.adjustAlignmentIndices(totalWords, true, true);
            prevTok = tok;
        }
        return str.toString().trim();
    }

    private String rejoinHyphenatedWords(String sent, boolean anonymizedSentence) {
        String[] toks = sent.split(" ");
        StringBuilder str = new StringBuilder(toks[0]);
        String prevTok = toks[0];
        int totalWords = 1;
        for (int i = 1; i < toks.length; ++i) {
            String tok = toks[i];
            if (tok.equals("@-@") && !prevTok.contains("_date-entity") && !prevTok.matches("[0-9]{2,4}[-]?[0-9]{2}[-]?[0-9]{2}") && !prevTok.matches("[0-9]+")) {
                str.append("-");
                if (!anonymizedSentence) {
                    this.addHyphenToNlAlignments(totalWords, "-");
                }
                this.adjustAlignmentIndices(totalWords, anonymizedSentence, true);
            } else if (prevTok.equals("@-@") && !tok.contains("_date-entity") && !tok.matches("[0-9]{2,4}[-]?[0-9]{2}[-]?[0-9]{2}") && !tok.matches("[0-9]+")) {
                str.append(tok);
                this.adjustAlignmentIndices(totalWords, anonymizedSentence, true);
            } else {
                str.append(" ").append(tok);
                ++totalWords;
            }
            prevTok = tok;
        }
        return str.toString();
    }

    private void addHyphenToNlAlignments(int index, String symbol) {
        this.addHyphenToNlAlignments(index, this.anonymizationAlignments, symbol);
        this.addHyphenToNlAlignments(index, this.contentAlignments, symbol);
        this.addHyphenToNlAlignments(index, this.jamrAlignments.values(), symbol);
    }

    private void addHyphenToNlAlignments(int index, Collection<? extends AmrAnonymizationAlignment> alignments, String symbol) {
        for (AmrAnonymizationAlignment amrAnonymizationAlignment : alignments) {
            int pos = amrAnonymizationAlignment.relativePosOfHyphenInNl(index);
            if (pos == -1) continue;
            String oldTok = amrAnonymizationAlignment.nlTokens.get(pos);
            amrAnonymizationAlignment.nlTokens.set(pos, oldTok + symbol + amrAnonymizationAlignment.nlTokens.remove(pos + 1));
            amrAnonymizationAlignment.nlIds.remove(pos + 1);
        }
    }

    private void adjustAlignmentIndices(int wordToBeAdjustedIndex, boolean anonymizedSentence, boolean negative) {
        this.adjustAlignmentIndices(wordToBeAdjustedIndex, this.anonymizationAlignments, anonymizedSentence, negative);
        this.adjustAlignmentIndices(wordToBeAdjustedIndex, this.contentAlignments, anonymizedSentence, negative);
        this.adjustAlignmentIndices(wordToBeAdjustedIndex, this.jamrAlignments.values(), anonymizedSentence, negative);
    }

    private void adjustAlignmentIndices(int wordToBeAdjustedIndex, Collection<? extends AmrAnonymizationAlignment> alignments, boolean anonymizedSentence, boolean negative) {
        alignments.stream().forEach(al -> al.adjust(wordToBeAdjustedIndex, anonymizedSentence, negative));
    }

    private String cleanupAnonymizedSentence(String sentenceIn) {
        StringBuilder str = new StringBuilder();
        for (String tok : sentenceIn.split(" ")) {
            if (tok.length() > 1 && tok.matches("[0-9]+[-.,]?[0-9]+")) {
                str.append("num_unk ");
                continue;
            }
            if (tok.length() > 1 && tok.startsWith("\u00a3")) {
                str.append("currency_unk ");
                continue;
            }
            str.append(tok).append(" ");
        }
        return str.toString().trim();
    }

    private boolean isUnkWord(Indexer<String> vocabulary, String word) {
        if (vocabulary.isEmpty() || vocabulary.size() == 3 && vocabulary.contains((Object)"<s>") && vocabulary.contains((Object)"</s>") && vocabulary.contains((Object)"<unk>")) {
            return false;
        }
        return !vocabulary.contains((Object)word.toLowerCase());
    }

    public void updateVocabularies(Indexer<String> amrVocabulary, HistMap<String> amrHist, Indexer<String> nlVocabulary, HistMap<String> nlHist) {
        for (AmrComponent amrToken : ((AmrLinearize)this.amr).getLinearizedGraph()) {
            amrVocabulary.add((Object)amrToken.getName());
            amrHist.add(amrToken.getName());
        }
        for (String word : this.getAnonymizedSentence().split(" ")) {
            nlVocabulary.add((Object)word.toLowerCase());
            nlHist.add(word.toLowerCase());
        }
    }

    @Override
    public String getAnonymizedSentence() {
        return this.anonymizedSentence.toLowerCase();
    }

    public String getSentenceNormalisedIndices(Indexer<String> vocabulary, boolean augmentLexicon) {
        StringBuilder str = new StringBuilder();
        str.append(vocabulary.getIndex((Object)"<s>"));
        for (String word : this.getAnonymizedSentence().split(" ")) {
            if (augmentLexicon) {
                str.append(" ").append(vocabulary.getIndex((Object)word.toLowerCase()));
                continue;
            }
            int index = vocabulary.indexOf((Object)word.toLowerCase());
            str.append(" ").append(index != -1 ? index : vocabulary.getIndex((Object)"<unk>"));
        }
        str.append(" ").append(vocabulary.getIndex((Object)"</s>"));
        return str.toString();
    }

    public String getAmrIndices(Indexer<String> vocabulary, boolean augmentLexicon) {
        StringBuilder str = new StringBuilder();
        str.append(vocabulary.getIndex((Object)"<s>"));
        for (String token : this.amr.toString().split(" ")) {
            if (augmentLexicon) {
                str.append(" ").append(vocabulary.getIndex((Object)token));
                continue;
            }
            int index = vocabulary.indexOf((Object)token);
            str.append(" ").append(index != -1 ? index : vocabulary.getIndex((Object)"<unk>"));
        }
        str.append(" ").append(vocabulary.getIndex((Object)"</s>"));
        return str.toString().trim();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public Collection<JamrAlignment> getJamrAlignments() {
        return this.jamrAlignments.values();
    }

    public Collection<AmrAnonymizationAlignment> getContentAlignments() {
        return this.contentAlignments;
    }

    public Set<AmrAnonymizationAlignment> getAnonymizationAlignments() {
        return this.anonymizationAlignments;
    }

    public String toStringPropositionsAnonymizedNl() {
        return String.format("%s\t%s\t%s", this.getId(), ((AmrLinearize)this.amr).propositionsToString(), this.getAnonymizedSentence());
    }

    public String toStringAnonymizationAlignments(boolean lowerCase) {
        StringBuilder str = new StringBuilder();
        this.anonymizationAlignments.stream().forEach(an -> str.append(an).append(" # "));
        return String.format("%s\t%s", this.getId(), this.anonymizationAlignments.isEmpty() ? "" : (lowerCase ? str.substring(0, str.length() - 3) : str.substring(0, str.length() - 3)).trim());
    }

    public String toStringContentAlignments() {
        StringBuilder str = new StringBuilder();
        this.contentAlignments.stream().forEach(an -> str.append(an).append(" # "));
        return String.format("%s\t%s", this.getId(), this.contentAlignments.isEmpty() ? "" : str.substring(0, str.length() - 3).trim());
    }

    public String toStringJamrAlignments() {
        StringBuilder str = new StringBuilder();
        this.jamrAlignments.values().stream().forEach(an -> str.append(an).append(" # "));
        return String.format("%s\t%s", this.getId(), this.jamrAlignments.isEmpty() ? "" : str.substring(0, str.length() - 3).trim());
    }

    public String toStringAmrNlStemsPosTags(StemmerPosTagger processor) {
        Pair<String, String> stemsPosTags = processor.processToString(this.getAnonymizedSentence(), this.getAnonymizedSentenceSize());
        return String.format("%s\t%s\t%s\t%s\t%s", this.getId(), this.amr.toString(), this.getAnonymizedSentence(), stemsPosTags.getFirst(), stemsPosTags.getSecond());
    }

    public String toStringAmrNlSeqAlignments(Collection<AmrAnonymizationAlignment> mergedAlignments) {
        Object[] sequence = new Integer[this.anonymizedSentence.split(" ").length];
        Arrays.fill(sequence, (Object)-1);
        HashMap nodeIdToAmrPosMap = new HashMap();
        mergedAlignments.stream().forEach(arg_0 -> AmrLinearizedSentence.lambda$toStringAmrNlSeqAlignments$7((Integer[])sequence, nodeIdToAmrPosMap, arg_0));
        List<AmrComponent> graph = ((AmrLinearize)this.amr).getLinearizedGraph();
        for (int i = 0; i < graph.size(); ++i) {
            AmrComponent node = graph.get(i);
            String nodeId = node.getNodeId();
            int nlId = nodeIdToAmrPosMap.getOrDefault(nodeId.isEmpty() ? node.getName() : nodeId, -1);
            if (node.getName().contains("_name_")) {
                nlId = nodeIdToAmrPosMap.getOrDefault(node.getName(), nodeIdToAmrPosMap.getOrDefault(nodeId, -1));
            }
            if (nlId == -1) continue;
            sequence[nlId] = i;
        }
        return this.id + "\t" + Arrays.asList(sequence).stream().map(String::valueOf).collect(Collectors.joining(" "));
    }

    public String toStringNlOnly() {
        return String.format("%s\t%s", this.getId(), this.sentence);
    }

    public String toStringIdToNumIdOnly() {
        return String.format("%s\t%s", this.id, this.incrId);
    }

    public String toString() {
        return String.format("%s\t%s\t%s", this.getId(), this.amr.toString(), this.getSentence());
    }

    public String toStringBrackets(boolean reshuffleChildren, boolean markLeaves, boolean outputSense, boolean concatBracketsWithRoles) {
        return String.format("%s\t%s\t%s", this.getId(), ((AmrLinearize)this.amr).toStringBrackets(reshuffleChildren, markLeaves, outputSense, concatBracketsWithRoles), this.getSentence());
    }

    public String toStringAnonymized(boolean outputBrackets, boolean reshuffleChildren, boolean markLeaves, boolean outputSense, boolean concatBracketsWithRoles) {
        return String.format("%s\t%s\t%s", this.getId(), outputBrackets ? ((AmrLinearize)this.amr).toStringBrackets(reshuffleChildren, markLeaves, outputSense, concatBracketsWithRoles) : this.amr.toString(), this.getAnonymizedSentence());
    }

    public String toStringLinearizeIndices(Indexer<String> amrVocabulary, Indexer<String> nlVocabulary, boolean augmentLexicon) {
        return String.format("0\t%s\t%s\t%s\t0", this.getId(), this.getAmrIndices(amrVocabulary, augmentLexicon), this.getSentenceNormalisedIndices(nlVocabulary, augmentLexicon));
    }

    private static /* synthetic */ void lambda$toStringAmrNlSeqAlignments$7(Integer[] sequence, Map nodeIdToAmrPosMap, AmrAnonymizationAlignment a) {
        if (!a.isEmpty() && a.anonymizedNlId < sequence.length) {
            nodeIdToAmrPosMap.put(a.anonymizedToken, a.anonymizedNlId);
        }
    }
}

